/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.patch.formove;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ui.ChangesTreeImpl;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class UndoApplyPatchDialog
extends DialogWrapper {
    private final List<? extends FilePath> myFailedFilePaths;
    private final Project myProject;
    private final boolean myShouldInformAboutBinaries;

    UndoApplyPatchDialog(@NotNull Project project, @NotNull List<? extends FilePath> filePaths, boolean shouldInformAboutBinaries) {
        super(project, true);
        this.myProject = project;
        this.setTitle("Patch Applying Partly Failed");
        this.setOKButtonText("Rollback");
        this.myFailedFilePaths = filePaths;
        this.myShouldInformAboutBinaries = shouldInformAboutBinaries;
        this.init();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel(new BorderLayout());
        int numFiles = this.myFailedFilePaths.size();
        JPanel labelsPanel = new JPanel(new BorderLayout());
        String detailedText = numFiles == 0 ? "" : String.format("Failed to apply %s below.<br>", StringUtil.pluralize((String)"file", (int)numFiles));
        JBLabel infoLabel = new JBLabel(XmlStringUtil.wrapInHtml((CharSequence)(detailedText + "Would you like to rollback all applied?")));
        labelsPanel.add((Component)infoLabel, "North");
        if (this.myShouldInformAboutBinaries) {
            JLabel warningLabel = new JLabel("Rollback will not affect binaries");
            warningLabel.setIcon(UIUtil.getBalloonWarningIcon());
            labelsPanel.add((Component)warningLabel, "Center");
        }
        panel2.add((Component)labelsPanel, "North");
        if (numFiles > 0) {
            ChangesTreeImpl.FilePaths browser2 = new ChangesTreeImpl.FilePaths(this.myProject, false, false, this.myFailedFilePaths, (JLabel)infoLabel){
                final /* synthetic */ JLabel val$infoLabel;
                {
                    this.val$infoLabel = jLabel;
                    super(project, showCheckboxes, highlightProblems, paths);
                }

                public Dimension getPreferredSize() {
                    return new Dimension(this.val$infoLabel.getPreferredSize().width, 50);
                }
            };
            panel2.add((Component)ScrollPaneFactory.createScrollPane((Component)((Object)browser2)), "Center");
        }
        return panel2;
    }
}

