/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.settings;

import com.intellij.application.options.colors.ColorAndFontDescription;
import com.intellij.application.options.colors.ColorAndFontDescriptionPanel;
import com.intellij.application.options.colors.ColorAndFontOptions;
import com.intellij.application.options.colors.ColorAndFontPanelFactory;
import com.intellij.application.options.colors.ColorAndFontSettingsListener;
import com.intellij.application.options.colors.CompositeColorDescriptionPanel;
import com.intellij.application.options.colors.NewColorAndFontPanel;
import com.intellij.application.options.colors.OptionsPanelImpl;
import com.intellij.application.options.colors.SchemesPanel;
import com.intellij.application.options.colors.TextAttributesDescription;
import com.intellij.diff.util.DiffLineSeparatorRenderer;
import com.intellij.diff.util.TextDiffTypeFactory;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.diff.impl.settings.DiffColorDescriptionPanel;
import com.intellij.openapi.diff.impl.settings.DiffPreviewPanel;
import com.intellij.openapi.editor.colors.EditorSchemeAttributeDescriptor;
import com.intellij.openapi.options.OptionsBundle;
import com.intellij.openapi.options.colors.AttributesDescriptor;
import com.intellij.openapi.options.colors.ColorAndFontDescriptorsProvider;
import com.intellij.openapi.options.colors.ColorDescriptor;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.codeStyle.DisplayPriority;
import com.intellij.psi.codeStyle.DisplayPrioritySortable;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class DiffColorsPageFactory
implements ColorAndFontPanelFactory,
ColorAndFontDescriptorsProvider,
DisplayPrioritySortable {
    public static final String DIFF_GROUP = ApplicationBundle.message((String)"title.diff", (Object[])new Object[0]);

    @Override
    @NotNull
    public NewColorAndFontPanel createPanel(final @NotNull ColorAndFontOptions options) {
        SchemesPanel schemesPanel = new SchemesPanel(options);
        CompositeColorDescriptionPanel descriptionPanel = new CompositeColorDescriptionPanel();
        descriptionPanel.addDescriptionPanel(new ColorAndFontDescriptionPanel(), (Condition<EditorSchemeAttributeDescriptor>)((Condition)it -> it instanceof ColorAndFontDescription));
        descriptionPanel.addDescriptionPanel(new DiffColorDescriptionPanel(options), (Condition<EditorSchemeAttributeDescriptor>)((Condition)it -> it instanceof TextAttributesDescription));
        final OptionsPanelImpl optionsPanel = new OptionsPanelImpl(options, schemesPanel, DIFF_GROUP, descriptionPanel);
        final DiffPreviewPanel previewPanel = new DiffPreviewPanel();
        schemesPanel.addListener(new ColorAndFontSettingsListener.Abstract(){

            @Override
            public void schemeChanged(@NotNull Object source) {
                previewPanel.setColorScheme(options.getSelectedScheme());
                optionsPanel.updateOptionsList();
            }
        });
        return new NewColorAndFontPanel(schemesPanel, optionsPanel, previewPanel, DIFF_GROUP, null, null);
    }

    @NotNull
    public AttributesDescriptor[] getAttributeDescriptors() {
        Object[] diffTypes = TextDiffTypeFactory.getInstance().getAllDiffTypes();
        return (AttributesDescriptor[])ContainerUtil.map2Array((Object[])diffTypes, AttributesDescriptor.class, type -> new AttributesDescriptor(OptionsBundle.message((String)"options.general.color.descriptor.vcs.diff.type.tag.prefix", (Object[])new Object[0]) + type.getName(), type.getKey()));
    }

    @NotNull
    public ColorDescriptor[] getColorDescriptors() {
        ArrayList<ColorDescriptor> descriptors = new ArrayList<ColorDescriptor>();
        descriptors.add(new ColorDescriptor(OptionsBundle.message((String)"options.general.color.descriptor.vcs.diff.separator.background", (Object[])new Object[0]), DiffLineSeparatorRenderer.BACKGROUND, ColorDescriptor.Kind.BACKGROUND));
        return descriptors.toArray(ColorDescriptor.EMPTY_ARRAY);
    }

    @Override
    @NotNull
    public String getPanelDisplayName() {
        return DIFF_GROUP;
    }

    @NotNull
    public String getDisplayName() {
        return DIFF_GROUP;
    }

    public DisplayPriority getPriority() {
        return DisplayPriority.COMMON_SETTINGS;
    }
}

