/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.settings;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.contents.DiffContent;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class DiffPreviewProvider {
    public static final ExtensionPointName<DiffPreviewProvider> EP_NAME = ExtensionPointName.create((String)"com.intellij.diffPreviewProvider");
    @NonNls
    private static final String LEFT_TEXT = "class MyClass {\n  int value;\n\n  void leftOnly() {}\n\n  void foo() {\n   // Left changes\n  }\n\n  void bar() {\n\n  }\n}\n\n\n";
    @NonNls
    private static final String CENTER_TEXT = "class MyClass {\n  int value;\n\n  void foo() {\n  }\n\n  void removedFromLeft() {}\n\n  void bar() {\n\n  }\n}\n\n\n";
    @NonNls
    private static final String RIGHT_TEXT = "class MyClass {\n  long value;\n\n  void foo() {\n   // Right changes\n  }\n\n  void removedFromLeft() {}\n\n  void bar() {\n  }\n\n}\n\n\n";

    @NotNull
    public abstract DiffContent[] createContents();

    @NotNull
    public static DiffContent[] getContents() {
        List providers = EP_NAME.getExtensionList();
        if (providers.size() != 0) {
            return ((DiffPreviewProvider)providers.get(0)).createContents();
        }
        return DiffPreviewProvider.createContent(LEFT_TEXT, CENTER_TEXT, RIGHT_TEXT, (FileType)StdFileTypes.JAVA);
    }

    @NotNull
    public static DiffContent[] createContent(@NotNull String left, @NotNull String center, @NotNull String right, @NotNull FileType fileType) {
        return new DiffContent[]{DiffPreviewProvider.createContent(left, fileType), DiffPreviewProvider.createContent(center, fileType), DiffPreviewProvider.createContent(right, fileType)};
    }

    @NotNull
    private static DiffContent createContent(@NotNull String text, @NotNull FileType fileType) {
        return DiffContentFactory.getInstance().create(text, fileType);
    }
}

