/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.util;

import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.DiffColors;
import com.intellij.openapi.diff.impl.util.TextDiffTypeEnum;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextDiffType {
    public static final TextDiffType INSERT = new TextDiffType(TextDiffTypeEnum.INSERT, DiffBundle.message((String)"diff.type.inserted.name", (Object[])new Object[0]), DiffColors.DIFF_INSERTED);
    public static final TextDiffType CHANGED = new TextDiffType(TextDiffTypeEnum.CHANGED, DiffBundle.message((String)"diff.type.changed.name", (Object[])new Object[0]), DiffColors.DIFF_MODIFIED);
    public static final TextDiffType DELETED = new TextDiffType(TextDiffTypeEnum.DELETED, DiffBundle.message((String)"diff.type.deleted.name", (Object[])new Object[0]), DiffColors.DIFF_DELETED);
    public static final TextDiffType CONFLICT = new TextDiffType(TextDiffTypeEnum.CONFLICT, DiffBundle.message((String)"diff.type.conflict.name", (Object[])new Object[0]), DiffColors.DIFF_CONFLICT);
    public static final TextDiffType NONE = new TextDiffType(TextDiffTypeEnum.NONE, DiffBundle.message((String)"diff.type.none.name", (Object[])new Object[0]), null);
    public static final List<TextDiffType> DIFF_TYPES = Arrays.asList(DELETED, CHANGED, INSERT);
    public static final List<TextDiffType> MERGE_TYPES = Arrays.asList(DELETED, CHANGED, INSERT, CONFLICT);
    private final TextDiffTypeEnum myType;
    private final TextAttributesKey myAttributesKey;
    private final String myDisplayName;

    @NotNull
    public static TextDiffType create(@Nullable TextDiffTypeEnum type) {
        if (TextDiffTypeEnum.INSERT.equals((Object)type)) {
            return INSERT;
        }
        if (TextDiffTypeEnum.CHANGED.equals((Object)type)) {
            return CHANGED;
        }
        if (TextDiffTypeEnum.DELETED.equals((Object)type)) {
            return DELETED;
        }
        if (TextDiffTypeEnum.CONFLICT.equals((Object)type)) {
            return CONFLICT;
        }
        return NONE;
    }

    private TextDiffType(TextDiffTypeEnum type, String displayName, TextAttributesKey attributesKey) {
        this.myType = type;
        this.myAttributesKey = attributesKey;
        this.myDisplayName = displayName;
    }

    public String getDisplayName() {
        return this.myDisplayName;
    }

    public TextAttributesKey getAttributesKey() {
        return this.myAttributesKey;
    }

    @Nullable
    public TextAttributes getTextAttributes(@NotNull EditorColorsScheme scheme2) {
        return scheme2.getAttributes(this.myAttributesKey);
    }

    @Nullable
    public Color getPolygonColor(Editor editor) {
        TextAttributes attributes = this.getTextAttributes(editor);
        return attributes == null ? null : attributes.getBackgroundColor();
    }

    @Nullable
    public TextAttributes getTextAttributes(@NotNull Editor editor) {
        return this.getTextAttributes(editor.getColorsScheme());
    }

    public String toString() {
        return this.myDisplayName;
    }

    public TextDiffTypeEnum getType() {
        return this.myType;
    }
}

