/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor;

import com.intellij.openapi.editor.CaretStateTransferableData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClipboardTextPerCaretSplitter {
    @NotNull
    public List<String> split(@NotNull String input, @Nullable CaretStateTransferableData caretData, int caretCount) {
        if (caretCount <= 0) {
            throw new IllegalArgumentException("Caret count must be positive");
        }
        if (caretCount == 1) {
            return Collections.singletonList(input);
        }
        ArrayList<String> result2 = new ArrayList<String>(caretCount);
        if (caretData == null) {
            String[] lines2 = input.split("\n", -1);
            int sourceCaretCount = lines2.length == 2 && lines2[1].isEmpty() ? 1 : lines2.length;
            for (int i = 0; i < caretCount; ++i) {
                if (sourceCaretCount == 1) {
                    result2.add(lines2[0]);
                    continue;
                }
                result2.add(i < lines2.length ? lines2[i] : "");
            }
        } else {
            int sourceCaretCount = caretData.startOffsets.length;
            for (int i = 0; i < caretCount; ++i) {
                if (sourceCaretCount == 1) {
                    result2.add(input);
                    continue;
                }
                result2.add(i < sourceCaretCount ? input.substring(caretData.startOffsets[i], caretData.endOffsets[i]) : "");
            }
        }
        return result2;
    }
}

