/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor;

import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import java.awt.Color;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LineExtensionInfo {
    @NotNull
    private final String myText;
    @Nullable
    private final Color myColor;
    @Nullable
    private final EffectType myEffectType;
    @Nullable
    private final Color myEffectColor;
    @Nullable
    private final Color myBgColor;
    @JdkConstants.FontStyle
    private final int myFontType;

    public LineExtensionInfo(@NotNull String text, @Nullable Color color, @Nullable EffectType effectType, @Nullable Color effectColor, @JdkConstants.FontStyle int fontType) {
        this.myText = text;
        this.myColor = color;
        this.myEffectType = effectType;
        this.myEffectColor = effectColor;
        this.myFontType = fontType;
        this.myBgColor = null;
    }

    public LineExtensionInfo(@NotNull String text, @NotNull TextAttributes attr) {
        this.myText = text;
        this.myColor = attr.getForegroundColor();
        this.myEffectType = attr.getEffectType();
        this.myEffectColor = attr.getEffectColor();
        this.myFontType = attr.getFontType();
        this.myBgColor = attr.getBackgroundColor();
    }

    @NotNull
    public String getText() {
        return this.myText;
    }

    @Nullable
    public Color getColor() {
        return this.myColor;
    }

    @Nullable
    public Color getBgColor() {
        return this.myBgColor;
    }

    @Nullable
    public EffectType getEffectType() {
        return this.myEffectType;
    }

    @Nullable
    public Color getEffectColor() {
        return this.myEffectColor;
    }

    @JdkConstants.FontStyle
    public int getFontType() {
        return this.myFontType;
    }
}

