/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.EditorCopyPasteHelper;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.actions.PasteAction;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Producer;
import java.awt.datatransfer.Transferable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasePasteHandler
extends EditorWriteActionHandler {
    protected Transferable myTransferable;

    public boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
        return !editor.isViewer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doExecute(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext) {
        this.myTransferable = this.getContentsToPaste(editor, dataContext);
        try {
            super.doExecute(editor, caret, dataContext);
        }
        catch (EditorCopyPasteHelper.TooLargeContentException e) {
            BasePasteHandler.contentLengthLimitExceededMessage(e.getContentLength());
        }
        finally {
            this.myTransferable = null;
        }
    }

    public void executeWriteAction(Editor editor, @Nullable Caret caret, DataContext dataContext) {
        if (this.myTransferable != null) {
            EditorCopyPasteHelper.getInstance().pasteTransferable(editor, this.myTransferable);
        }
    }

    protected Transferable getContentsToPaste(Editor editor, DataContext dataContext) {
        Producer producer = (Producer)PasteAction.TRANSFERABLE_PROVIDER.getData(dataContext);
        return EditorModificationUtil.getContentsToPasteToEditor((Producer)producer);
    }

    public static boolean isContentTooLarge(int contentLength) {
        return contentLength > FileUtilRt.LARGE_FOR_CONTENT_LOADING;
    }

    public static void contentLengthLimitExceededMessage(int contentLength) {
        Messages.showErrorDialog((String)EditorBundle.message((String)"content.to.paste.too.large.message", (Object[])new Object[]{StringUtil.formatFileSize((long)contentLength), StringUtil.formatFileSize((long)FileUtilRt.LARGE_FOR_CONTENT_LOADING)}), (String)EditorBundle.message((String)"content.to.paste.too.large.title", (Object[])new Object[0]));
    }
}

