/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorLastActionTracker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.keymap.impl.ModifierKeyDoubleClickHandler;
import com.intellij.openapi.util.Key;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CloneCaretActionHandler
extends EditorActionHandler {
    private static final Key<Integer> LEVEL = Key.create((String)"CloneCaretActionHandler.level");
    private static final Set<String> OUR_ACTIONS = new HashSet<String>(Arrays.asList("EditorCloneCaretAbove", "EditorCloneCaretBelow", "EditorLeftWithSelection", "EditorRightWithSelection", "EditorUpWithSelection", "EditorDownWithSelection", "EditorLineStartWithSelection", "EditorLineEndWithSelection", "EditorPageUpWithSelection", "EditorPageDownWithSelection", "EditorPreviousWordWithSelection", "EditorNextWordWithSelection"));
    private final boolean myCloneAbove;
    private boolean myRepeatedInvocation;

    public CloneCaretActionHandler(boolean above) {
        this.myCloneAbove = above;
    }

    public boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
        return editor.getCaretModel().supportsMultipleCarets() && (!ModifierKeyDoubleClickHandler.getInstance().isRunningAction() || EditorSettingsExternalizable.getInstance().addCaretsOnDoubleCtrl());
    }

    protected void doExecute(@NotNull Editor editor, @Nullable Caret targetCaret, DataContext dataContext) {
        if (ModifierKeyDoubleClickHandler.getInstance().isRunningAction() && !this.isRepeatedActionInvocation()) {
            FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.add.carets.using.double.ctrl");
        }
        if (targetCaret != null) {
            targetCaret.clone(this.myCloneAbove);
            return;
        }
        int currentLevel = 0;
        ArrayList<Caret> currentCarets = new ArrayList<Caret>();
        for (Caret caret : editor.getCaretModel().getAllCarets()) {
            int level = this.getLevel(caret);
            if (Math.abs(level) > Math.abs(currentLevel)) {
                currentLevel = level;
                currentCarets.clear();
            }
            if (Math.abs(level) != Math.abs(currentLevel)) continue;
            currentCarets.add(caret);
        }
        boolean removeCarets = currentLevel > 0 && this.myCloneAbove || currentLevel < 0 && !this.myCloneAbove;
        Integer newLevel = this.myCloneAbove ? currentLevel - 1 : currentLevel + 1;
        for (Caret caret : currentCarets) {
            if (removeCarets) {
                editor.getCaretModel().removeCaret(caret);
                continue;
            }
            Caret clone = caret;
            do {
                Caret original = clone;
                clone = clone.clone(this.myCloneAbove);
                if (original == caret) continue;
                editor.getCaretModel().removeCaret(original);
            } while (clone != null && caret.hasSelection() && !clone.hasSelection());
            if (clone == null) continue;
            clone.putUserData(LEVEL, (Object)newLevel);
        }
        if (removeCarets) {
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        }
    }

    public void setRepeatedInvocation(boolean value) {
        this.myRepeatedInvocation = value;
    }

    private int getLevel(Caret caret) {
        if (this.isRepeatedActionInvocation()) {
            Integer value = (Integer)caret.getUserData(LEVEL);
            return value == null ? 0 : value;
        }
        caret.putUserData(LEVEL, null);
        return 0;
    }

    private boolean isRepeatedActionInvocation() {
        if (this.myRepeatedInvocation) {
            return true;
        }
        String lastActionId = EditorLastActionTracker.getInstance().getLastActionId();
        return OUR_ACTIONS.contains(lastActionId);
    }
}

