/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.application.options.schemes.SchemeNameGenerator;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.keymap.KeyMapBundle;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.ex.KeymapManagerEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.containers.ContainerUtil;
import java.awt.AWTEvent;
import java.awt.event.KeyEvent;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CtrlYActionChooser {
    private static final String ASK_ABOUT_SHORTCUT = "ask.about.ctrl.y.shortcut";

    @Nullable
    private static Keymap getCurrentKeymap() {
        KeymapManager keymapManager2 = KeymapManager.getInstance();
        return keymapManager2 == null ? null : keymapManager2.getActiveKeymap();
    }

    @NotNull
    private static Keymap getRootKeymap(@NotNull Keymap keymap) {
        Keymap parent;
        while (keymap.canModify() && (parent = keymap.getParent()) != null) {
            keymap = parent;
        }
        return keymap;
    }

    private static boolean isCtrlY(AWTEvent event) {
        if (!(event instanceof KeyEvent)) {
            return false;
        }
        KeyEvent keyEvent = (KeyEvent)event;
        int modifiers = keyEvent.getModifiers();
        return keyEvent.getKeyCode() == 89 && (modifiers & 2) != 0 && (modifiers & 1) == 0 && (modifiers & 0x20) == 0 && (modifiers & 8) == 0 && (modifiers & 4) == 0;
    }

    private static void patchKeymap(@NotNull Keymap currentKeymap) {
        KeymapManager keymapManager2 = KeymapManager.getInstance();
        assert (keymapManager2 instanceof KeymapManagerEx);
        Keymap[] allKeymaps = ((KeymapManagerEx)keymapManager2).getAllKeymaps();
        String name = SchemeNameGenerator.getUniqueName(KeyMapBundle.message((String)"keymap.with.patched.redo.name", (Object[])new Object[]{currentKeymap.getPresentableName()}), n -> ContainerUtil.exists((Object[])allKeymaps, t -> n.equals(t.getName()) || n.equals(t.getPresentableName())));
        Keymap newKeymap = currentKeymap.deriveKeymap(name);
        KeyboardShortcut shortcut = KeyboardShortcut.fromString((String)"control Y");
        newKeymap.removeShortcut("EditorDeleteLine", (Shortcut)shortcut);
        newKeymap.addShortcut("$Redo", (Shortcut)shortcut);
        ((KeymapManagerEx)keymapManager2).getSchemeManager().addScheme(newKeymap);
        ((KeymapManagerEx)keymapManager2).setActiveKeymap(newKeymap);
    }

    private static void invokeRedo(DataContext dataContext) {
        AnAction action = ActionManager.getInstance().getAction("$Redo");
        if (action != null) {
            ActionUtil.invokeAction((AnAction)action, (DataContext)dataContext, (String)"MainMenu", null, null);
        }
    }

    public static boolean isCurrentShortcutOk(DataContext dataContext) {
        if (!PropertiesComponent.getInstance().isValueSet(ASK_ABOUT_SHORTCUT)) {
            return true;
        }
        Keymap keymap = CtrlYActionChooser.getCurrentKeymap();
        if (keymap == null) {
            return true;
        }
        Keymap rootKeymap = CtrlYActionChooser.getRootKeymap(keymap);
        if (!"$default".equals(rootKeymap.getName())) {
            return true;
        }
        AWTEvent event = IdeEventQueue.getInstance().getTrueCurrentEvent();
        if (!CtrlYActionChooser.isCtrlY(event)) {
            return true;
        }
        int savedCount = IdeEventQueue.getInstance().getEventCount();
        int choice = Messages.showDialog((String)KeyMapBundle.message((String)"keymap.patch.dialog.message", (Object[])new Object[0]), (String)KeyMapBundle.message((String)"keymap.patch.dialog.title", (Object[])new Object[0]), (String[])new String[]{KeyMapBundle.message((String)"keymap.patch.dialog.redo.option", (Object[])new Object[0]), KeyMapBundle.message((String)"keymap.patch.dialog.delete.line.option", (Object[])new Object[0]), KeyMapBundle.message((String)"keymap.patch.dialog.cancel.option", (Object[])new Object[0])}, (int)-1, (Icon)Messages.getInformationIcon(), null);
        IdeEventQueue.getInstance().setEventCount(savedCount);
        if (choice < 0 || choice > 1) {
            return false;
        }
        PropertiesComponent.getInstance().unsetValue(ASK_ABOUT_SHORTCUT);
        if (choice == 1) {
            return true;
        }
        CtrlYActionChooser.patchKeymap(keymap);
        CtrlYActionChooser.invokeRedo(dataContext);
        return false;
    }

    public static void askAboutShortcut() {
        PropertiesComponent.getInstance().setValue(ASK_ABOUT_SHORTCUT, true);
    }
}

