/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.actionSystem.LatencyAwareEditorAction;
import com.intellij.openapi.editor.ex.util.EditorUIUtil;
import com.intellij.util.DocumentUtil;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnterAction
extends EditorAction
implements LatencyAwareEditorAction {
    public EnterAction() {
        super((EditorActionHandler)new Handler());
        this.setInjectedContext(true);
    }

    public static void insertNewLineAtCaret(Editor editor) {
        EditorUIUtil.hideCursorInEditor(editor);
        Document document = editor.getDocument();
        if (!editor.isInsertMode()) {
            int caretLine = editor.getCaretModel().getLogicalPosition().line;
            int lineCount = document.getLineCount();
            if (caretLine < lineCount) {
                if (caretLine == lineCount - 1) {
                    document.insertString(document.getTextLength(), (CharSequence)"\n");
                }
                LogicalPosition pos = new LogicalPosition(caretLine + 1, 0);
                editor.getCaretModel().moveToLogicalPosition(pos);
                editor.getSelectionModel().removeSelection();
                EditorModificationUtil.scrollToCaret((Editor)editor);
            }
            return;
        }
        EditorModificationUtil.deleteSelectedText((Editor)editor);
        CharSequence text = document.getCharsSequence();
        int caretOffset = editor.getCaretModel().getOffset();
        int lineStartOffset = DocumentUtil.getLineStartOffset(caretOffset, document);
        int lineStartWsEndOffset = CharArrayUtil.shiftForward((CharSequence)text, (int)lineStartOffset, (String)" \t");
        String s = "\n" + text.subSequence(lineStartOffset, Math.min(caretOffset, lineStartWsEndOffset));
        document.insertString(caretOffset, (CharSequence)s);
        editor.getCaretModel().moveToOffset(caretOffset + s.length());
        EditorModificationUtil.scrollToCaret((Editor)editor);
        editor.getSelectionModel().removeSelection();
    }

    private static class Handler
    extends EditorWriteActionHandler {
        Handler() {
            super(true);
        }

        public void executeWriteAction(Editor editor, @Nullable Caret caret, DataContext dataContext) {
            CommandProcessor.getInstance().setCurrentCommandName(EditorBundle.message((String)"typing.command.name", (Object[])new Object[0]));
            EnterAction.insertNewLineAtCaret(editor);
        }

        public boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
            return !editor.isOneLineMode();
        }
    }
}

