/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actions.CloneCaretActionHandler;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PageDownWithSelectionAction
extends EditorAction {
    public PageDownWithSelectionAction() {
        super((EditorActionHandler)new Handler());
    }

    public static class Handler
    extends EditorActionHandler {
        public void doExecute(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext) {
            if (!editor.getCaretModel().supportsMultipleCarets()) {
                EditorActionUtil.moveCaretPageDown(editor, true);
                return;
            }
            if (editor.isColumnMode()) {
                int lines2 = editor.getScrollingModel().getVisibleArea().height / editor.getLineHeight();
                CloneCaretActionHandler handler2 = new CloneCaretActionHandler(false);
                for (int i = 0; i < lines2; ++i) {
                    handler2.execute(editor, caret, dataContext);
                    handler2.setRepeatedInvocation(true);
                }
            } else if (caret == null) {
                editor.getCaretModel().runForEachCaret(__ -> EditorActionUtil.moveCaretPageDown(editor, true));
            } else {
                EditorActionUtil.moveCaretPageDown(editor, true);
            }
        }
    }
}

