/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actions.TextComponentEditorAction;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public class TextStartAction
extends TextComponentEditorAction {
    public TextStartAction() {
        super(new Handler());
    }

    private static class Handler
    extends EditorActionHandler {
        private Handler() {
        }

        public void execute(@NotNull Editor editor, DataContext dataContext) {
            IdeDocumentHistory instance;
            editor.getCaretModel().removeSecondaryCarets();
            editor.getCaretModel().moveToOffset(0);
            editor.getSelectionModel().removeSelection();
            ScrollingModel scrollingModel = editor.getScrollingModel();
            scrollingModel.disableAnimation();
            scrollingModel.scrollToCaret(ScrollType.RELATIVE);
            scrollingModel.enableAnimation();
            Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
            if (project != null && (instance = IdeDocumentHistory.getInstance(project)) != null) {
                instance.includeCurrentCommandAsNavigation();
            }
        }
    }
}

