/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public class ToggleShowIndentLinesGloballyAction
extends ToggleAction
implements DumbAware {
    public boolean isSelected(@NotNull AnActionEvent e) {
        return EditorSettingsExternalizable.getInstance().isIndentGuidesShown();
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        Project project;
        EditorSettingsExternalizable.getInstance().setIndentGuidesShown(state);
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(e.getDataContext());
        if (editor != null && editor.getSettings().isIndentGuidesShown() != state) {
            editor.getSettings().setIndentGuidesShown(state);
        }
        if ((project = e.getProject()) != null) {
            DaemonCodeAnalyzer.getInstance((Project)project).restart();
        }
    }
}

