/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors.impl;

import com.intellij.application.options.EditorFontsConstants;
import com.intellij.configurationStore.SerializableScheme;
import com.intellij.ide.ui.ColorBlindness;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.DelegatingFontPreferences;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontCache;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.colors.ModifiableFontPreferences;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.ex.DefaultColorSchemesManager;
import com.intellij.openapi.editor.colors.impl.AppEditorFontOptions;
import com.intellij.openapi.editor.colors.impl.DefaultColorsScheme;
import com.intellij.openapi.editor.colors.impl.EditorColorsSchemeImpl;
import com.intellij.openapi.editor.colors.impl.EditorFontCacheImpl;
import com.intellij.openapi.editor.colors.impl.EmptyColorScheme;
import com.intellij.openapi.editor.colors.impl.FontPreferencesImpl;
import com.intellij.openapi.editor.colors.impl.ReadOnlyColorsScheme;
import com.intellij.openapi.editor.colors.impl.TextAttributesReader;
import com.intellij.openapi.editor.colors.impl.ValueElementReader;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.options.FontSize;
import com.intellij.openapi.options.SchemeState;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Ref;
import com.intellij.ui.ColorUtil;
import com.intellij.util.JdomKt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.JBIterable;
import gnu.trove.THashMap;
import java.awt.Color;
import java.awt.Font;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractColorsScheme
extends EditorFontCacheImpl
implements EditorColorsScheme,
SerializableScheme {
    public static final TextAttributes INHERITED_ATTRS_MARKER = new TextAttributes();
    public static final Color INHERITED_COLOR_MARKER = ColorUtil.marker((String)"INHERITED_COLOR_MARKER");
    public static final Color NULL_COLOR_MARKER = ColorUtil.marker((String)"NULL_COLOR_MARKER");
    public static final int CURR_VERSION = 142;
    private static final FontSize DEFAULT_FONT_SIZE = FontSize.SMALL;
    protected EditorColorsScheme myParentScheme;
    protected FontSize myQuickDocFontSize = DEFAULT_FONT_SIZE;
    @NotNull
    private FontPreferences myFontPreferences = new DelegatingFontPreferences(() -> AppEditorFontOptions.getInstance().getFontPreferences());
    @NotNull
    private FontPreferences myConsoleFontPreferences = new DelegatingFontPreferences(() -> this.myFontPreferences);
    private final ValueElementReader myValueReader = new TextAttributesReader();
    private String mySchemeName;
    private boolean myIsSaveNeeded;
    private boolean myCanBeDeleted = true;
    private int myVersion = 142;
    Map<ColorKey, Color> myColorsMap = ContainerUtilRt.newHashMap();
    Map<String, TextAttributes> myAttributesMap = new THashMap();
    @NonNls
    private static final String EDITOR_FONT = "font";
    @NonNls
    private static final String CONSOLE_FONT = "console-font";
    @NonNls
    private static final String EDITOR_FONT_NAME = "EDITOR_FONT_NAME";
    @NonNls
    private static final String CONSOLE_FONT_NAME = "CONSOLE_FONT_NAME";
    private Color myDeprecatedBackgroundColor = null;
    @NonNls
    private static final String SCHEME_ELEMENT = "scheme";
    @NonNls
    public static final String NAME_ATTR = "name";
    @NonNls
    private static final String VERSION_ATTR = "version";
    @NonNls
    private static final String BASE_ATTRIBUTES_ATTR = "baseAttributes";
    @NonNls
    private static final String DEFAULT_SCHEME_ATTR = "default_scheme";
    @NonNls
    private static final String PARENT_SCHEME_ATTR = "parent_scheme";
    @NonNls
    private static final String OPTION_ELEMENT = "option";
    @NonNls
    private static final String COLORS_ELEMENT = "colors";
    @NonNls
    private static final String ATTRIBUTES_ELEMENT = "attributes";
    @NonNls
    private static final String VALUE_ELEMENT = "value";
    @NonNls
    private static final String BACKGROUND_COLOR_NAME = "BACKGROUND";
    @NonNls
    private static final String LINE_SPACING = "LINE_SPACING";
    @NonNls
    private static final String CONSOLE_LINE_SPACING = "CONSOLE_LINE_SPACING";
    @NonNls
    private static final String FONT_SCALE = "FONT_SCALE";
    @NonNls
    private static final String EDITOR_FONT_SIZE = "EDITOR_FONT_SIZE";
    @NonNls
    private static final String CONSOLE_FONT_SIZE = "CONSOLE_FONT_SIZE";
    @NonNls
    private static final String EDITOR_LIGATURES = "EDITOR_LIGATURES";
    @NonNls
    private static final String CONSOLE_LIGATURES = "CONSOLE_LIGATURES";
    @NonNls
    private static final String EDITOR_QUICK_JAVADOC_FONT_SIZE = "EDITOR_QUICK_DOC_FONT_SIZE";
    private final Properties myMetaInfo = new Properties();
    private static final SimpleDateFormat META_INFO_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    @NonNls
    private static final String META_INFO_ELEMENT = "metaInfo";
    @NonNls
    private static final String PROPERTY_ELEMENT = "property";
    @NonNls
    private static final String PROPERTY_NAME_ATTR = "name";
    @NonNls
    private static final String META_INFO_CREATION_TIME = "created";
    @NonNls
    private static final String META_INFO_MODIFIED_TIME = "modified";
    @NonNls
    private static final String META_INFO_IDE = "ide";
    @NonNls
    private static final String META_INFO_IDE_VERSION = "ideVersion";
    @NonNls
    private static final String META_INFO_ORIGINAL = "originalScheme";

    protected AbstractColorsScheme(EditorColorsScheme parentScheme) {
        this.myParentScheme = parentScheme;
    }

    public AbstractColorsScheme() {
    }

    public void setDefaultMetaInfo(@Nullable AbstractColorsScheme parentScheme) {
        this.myMetaInfo.setProperty(META_INFO_CREATION_TIME, META_INFO_DATE_FORMAT.format(new Date()));
        this.myMetaInfo.setProperty(META_INFO_IDE, PlatformUtils.getPlatformPrefix());
        this.myMetaInfo.setProperty(META_INFO_IDE_VERSION, ApplicationInfoEx.getInstanceEx().getStrictVersion());
        if (parentScheme != null && parentScheme != EmptyColorScheme.INSTANCE) {
            this.myMetaInfo.setProperty(META_INFO_ORIGINAL, parentScheme.getName());
        }
    }

    @NotNull
    public Color getDefaultBackground() {
        Color c = this.getAttributes(HighlighterColors.TEXT).getBackgroundColor();
        return c != null ? c : Color.white;
    }

    @NotNull
    public Color getDefaultForeground() {
        Color c = this.getAttributes(HighlighterColors.TEXT).getForegroundColor();
        return c != null ? c : Color.black;
    }

    @NotNull
    public String getName() {
        return this.mySchemeName;
    }

    public void setFont(EditorFontType key, Font font) {
    }

    public abstract Object clone();

    public void copyTo(AbstractColorsScheme newScheme) {
        newScheme.myQuickDocFontSize = this.myQuickDocFontSize;
        if (this.myConsoleFontPreferences instanceof DelegatingFontPreferences) {
            newScheme.setUseEditorFontPreferencesInConsole();
        } else {
            newScheme.setConsoleFontPreferences(this.myConsoleFontPreferences);
        }
        if (this.myFontPreferences instanceof DelegatingFontPreferences) {
            newScheme.setUseAppFontPreferencesInEditor();
        } else {
            newScheme.setFontPreferences(this.myFontPreferences);
        }
        newScheme.myAttributesMap = new THashMap(this.myAttributesMap);
        newScheme.myColorsMap = new HashMap<ColorKey, Color>(this.myColorsMap);
        newScheme.myVersion = this.myVersion;
    }

    @NotNull
    public Set<ColorKey> getColorKeys() {
        return this.myColorsMap.keySet();
    }

    @NotNull
    public Map<String, TextAttributes> getDirectlyDefinedAttributes() {
        return new HashMap<String, TextAttributes>(this.myAttributesMap);
    }

    public void setEditorFontName(String fontName) {
        ModifiableFontPreferences currPreferences = this.ensureEditableFontPreferences();
        boolean useLigatures = currPreferences.useLigatures();
        int editorFontSize = this.getEditorFontSize();
        currPreferences.clear();
        currPreferences.register(fontName, editorFontSize);
        currPreferences.setUseLigatures(useLigatures);
        this.initFonts();
    }

    public void setEditorFontSize(int fontSize) {
        fontSize = EditorFontsConstants.checkAndFixEditorFontSize(fontSize);
        this.ensureEditableFontPreferences().register(this.myFontPreferences.getFontFamily(), fontSize);
        this.initFonts();
    }

    public void setUseAppFontPreferencesInEditor() {
        this.myFontPreferences = new DelegatingFontPreferences(() -> AppEditorFontOptions.getInstance().getFontPreferences());
        this.initFonts();
    }

    public boolean isUseAppFontPreferencesInEditor() {
        return this.myFontPreferences instanceof DelegatingFontPreferences;
    }

    public void setQuickDocFontSize(@NotNull FontSize fontSize) {
        if (this.myQuickDocFontSize != fontSize) {
            this.myQuickDocFontSize = fontSize;
            this.myIsSaveNeeded = true;
        }
    }

    public void setLineSpacing(float lineSpacing) {
        this.ensureEditableFontPreferences().setLineSpacing(lineSpacing);
    }

    @Override
    @NotNull
    public Font getFont(EditorFontType key) {
        return this.myFontPreferences instanceof DelegatingFontPreferences ? EditorFontCache.getInstance().getFont(key) : super.getFont(key);
    }

    public void setName(@NotNull String name) {
        this.mySchemeName = name;
    }

    @NotNull
    public FontPreferences getFontPreferences() {
        return this.myFontPreferences;
    }

    public void setFontPreferences(@NotNull FontPreferences preferences) {
        preferences.copyTo((FontPreferences)this.ensureEditableFontPreferences());
        this.initFonts();
    }

    public String getEditorFontName() {
        return this.getFont(EditorFontType.PLAIN).getFamily();
    }

    public int getEditorFontSize() {
        return this.myFontPreferences.getSize(this.myFontPreferences.getFontFamily());
    }

    @NotNull
    public FontSize getQuickDocFontSize() {
        return this.myQuickDocFontSize;
    }

    public float getLineSpacing() {
        return this.myFontPreferences.getLineSpacing();
    }

    protected void initFonts() {
        this.reset();
    }

    @Override
    protected EditorColorsScheme getFontCacheScheme() {
        return this;
    }

    public String toString() {
        return this.getName();
    }

    public void readExternal(@NotNull Element parentNode) {
        UISettings settings = UISettings.getInstanceOrNull();
        ColorBlindness blindness = settings == null ? null : settings.getColorBlindness();
        this.myValueReader.setAttribute(blindness == null ? null : blindness.name());
        if (SCHEME_ELEMENT.equals(parentNode.getName())) {
            this.readScheme(parentNode);
        } else {
            List children2 = parentNode.getChildren(SCHEME_ELEMENT);
            if (children2.isEmpty()) {
                throw new InvalidDataException("Scheme is not valid");
            }
            for (Element element : children2) {
                this.readScheme(element);
            }
        }
        this.initFonts();
        this.myVersion = 142;
    }

    private void readScheme(Element node) {
        boolean isDefault;
        this.myDeprecatedBackgroundColor = null;
        if (!SCHEME_ELEMENT.equals(node.getName())) {
            return;
        }
        this.setName(node.getAttributeValue("name"));
        int readVersion = Integer.parseInt(node.getAttributeValue(VERSION_ATTR, "0"));
        if (readVersion > 142) {
            throw new IllegalStateException("Unsupported color scheme version: " + readVersion);
        }
        this.myVersion = readVersion;
        String isDefaultScheme = node.getAttributeValue(DEFAULT_SCHEME_ATTR);
        boolean bl = isDefault = isDefaultScheme != null && Boolean.parseBoolean(isDefaultScheme);
        if (!isDefault) {
            this.myParentScheme = AbstractColorsScheme.getDefaultScheme(node.getAttributeValue(PARENT_SCHEME_ATTR, "Empty"));
        }
        this.myMetaInfo.clear();
        Ref fontScale = Ref.create();
        boolean clearEditorFonts = true;
        boolean clearConsoleFonts = true;
        for (Element childNode : node.getChildren()) {
            String childName;
            switch (childName = childNode.getName()) {
                case "option": {
                    this.readSettings(childNode, isDefault, (Ref<Float>)fontScale);
                    break;
                }
                case "font": {
                    this.readFontSettings(this.ensureEditableFontPreferences(), childNode, isDefault, (Float)fontScale.get(), clearEditorFonts);
                    clearEditorFonts = false;
                    break;
                }
                case "console-font": {
                    this.readFontSettings(this.ensureEditableConsoleFontPreferences(), childNode, isDefault, (Float)fontScale.get(), clearConsoleFonts);
                    clearConsoleFonts = false;
                    break;
                }
                case "colors": {
                    this.readColors(childNode);
                    break;
                }
                case "attributes": {
                    this.readAttributes(childNode);
                    break;
                }
                case "metaInfo": {
                    this.readMetaInfo(childNode);
                }
            }
        }
        if (this.myDeprecatedBackgroundColor != null) {
            TextAttributes textAttributes = this.myAttributesMap.get(HighlighterColors.TEXT.getExternalName());
            if (textAttributes == null) {
                textAttributes = new TextAttributes(Color.black, this.myDeprecatedBackgroundColor, null, EffectType.BOXED, 0);
                this.myAttributesMap.put(HighlighterColors.TEXT.getExternalName(), textAttributes);
            } else {
                textAttributes.setBackgroundColor(this.myDeprecatedBackgroundColor);
            }
        }
        if (this.myConsoleFontPreferences.getEffectiveFontFamilies().isEmpty()) {
            this.myFontPreferences.copyTo(this.myConsoleFontPreferences);
        }
        this.initFonts();
    }

    @NotNull
    private static EditorColorsScheme getDefaultScheme(@NotNull String name) {
        DefaultColorSchemesManager manager = DefaultColorSchemesManager.getInstance();
        EditorColorsScheme defaultScheme = manager.getScheme(name);
        if (defaultScheme == null) {
            defaultScheme = new TemporaryParent(name);
        }
        return defaultScheme;
    }

    private void readMetaInfo(@NotNull Element metaInfoElement) {
        this.myMetaInfo.clear();
        for (Element e : metaInfoElement.getChildren()) {
            String propertyName;
            if (!PROPERTY_ELEMENT.equals(e.getName()) || (propertyName = e.getAttributeValue("name")) == null) continue;
            this.myMetaInfo.setProperty(propertyName, e.getText());
        }
    }

    public void readAttributes(@NotNull Element childNode) {
        for (Element e : childNode.getChildren(OPTION_ELEMENT)) {
            String keyName = e.getAttributeValue("name");
            Element valueElement = e.getChild(VALUE_ELEMENT);
            Object attr = valueElement != null ? this.myValueReader.read(TextAttributes.class, valueElement) : (e.getAttributeValue(BASE_ATTRIBUTES_ATTR) != null ? INHERITED_ATTRS_MARKER : null);
            if (attr == null) continue;
            this.myAttributesMap.put(keyName, (TextAttributes)attr);
        }
    }

    public void readColors(@NotNull Element childNode) {
        for (Element colorElement : childNode.getChildren(OPTION_ELEMENT)) {
            String keyName = colorElement.getAttributeValue("name");
            Color valueColor = this.myValueReader.read(Color.class, colorElement);
            if (valueColor == null && colorElement.getAttributeValue(BASE_ATTRIBUTES_ATTR) != null) {
                valueColor = INHERITED_COLOR_MARKER;
            }
            if (BACKGROUND_COLOR_NAME.equals(keyName)) {
                this.myDeprecatedBackgroundColor = valueColor;
            }
            ColorKey name = ColorKey.find((String)keyName);
            this.myColorsMap.put(name, (Color)ObjectUtils.notNull((Object)valueColor, (Object)NULL_COLOR_MARKER));
        }
    }

    private void readSettings(@NotNull Element childNode, boolean isDefault, @NotNull Ref<Float> fontScale) {
        switch (childNode.getAttributeValue("name")) {
            case "FONT_SCALE": {
                fontScale.set((Object)this.myValueReader.read(Float.class, childNode));
                break;
            }
            case "LINE_SPACING": {
                Float value = this.myValueReader.read(Float.class, childNode);
                if (value == null) break;
                this.setLineSpacing(value.floatValue());
                break;
            }
            case "EDITOR_FONT_SIZE": {
                int value = this.readFontSize(childNode, isDefault, (Float)fontScale.get());
                if (value <= 0) break;
                this.setEditorFontSize(value);
                break;
            }
            case "EDITOR_FONT_NAME": {
                String value = this.myValueReader.read(String.class, childNode);
                if (value == null) break;
                this.setEditorFontName(value);
                break;
            }
            case "CONSOLE_LINE_SPACING": {
                Float value = this.myValueReader.read(Float.class, childNode);
                if (value == null) break;
                this.setConsoleLineSpacing(value.floatValue());
                break;
            }
            case "CONSOLE_FONT_SIZE": {
                int value = this.readFontSize(childNode, isDefault, (Float)fontScale.get());
                if (value <= 0) break;
                this.setConsoleFontSize(value);
                break;
            }
            case "CONSOLE_FONT_NAME": {
                String value = this.myValueReader.read(String.class, childNode);
                if (value == null) break;
                this.setConsoleFontName(value);
                break;
            }
            case "EDITOR_QUICK_DOC_FONT_SIZE": {
                FontSize value = this.myValueReader.read(FontSize.class, childNode);
                if (value == null) break;
                this.myQuickDocFontSize = value;
                break;
            }
            case "EDITOR_LIGATURES": {
                Boolean value = this.myValueReader.read(Boolean.class, childNode);
                if (value == null) break;
                this.ensureEditableFontPreferences().setUseLigatures(value.booleanValue());
                break;
            }
            case "CONSOLE_LIGATURES": {
                Boolean value = this.myValueReader.read(Boolean.class, childNode);
                if (value == null) break;
                this.ensureEditableConsoleFontPreferences().setUseLigatures(value.booleanValue());
                break;
            }
        }
    }

    private int readFontSize(Element element, boolean isDefault, Float fontScale) {
        if (isDefault) {
            return UISettings.getDefFontSize();
        }
        Integer intSize = this.myValueReader.read(Integer.class, element);
        if (intSize == null) {
            return -1;
        }
        return UISettings.restoreFontSize((int)intSize, (Float)fontScale);
    }

    private void readFontSettings(@NotNull ModifiableFontPreferences preferences, @NotNull Element element, boolean isDefaultScheme, @Nullable Float fontScale, boolean clearFonts) {
        if (clearFonts) {
            preferences.clearFonts();
        }
        List children2 = element.getChildren(OPTION_ELEMENT);
        String fontFamily = null;
        int size = -1;
        for (Object child2 : children2) {
            Element e = (Element)child2;
            if (EDITOR_FONT_NAME.equals(e.getAttributeValue("name"))) {
                fontFamily = this.myValueReader.read(String.class, e);
                continue;
            }
            if (!EDITOR_FONT_SIZE.equals(e.getAttributeValue("name"))) continue;
            size = this.readFontSize(e, isDefaultScheme, fontScale);
        }
        if (fontFamily != null && size > 1) {
            preferences.register(fontFamily, size);
        } else if (fontFamily != null) {
            preferences.addFontFamily(fontFamily);
        }
    }

    public void writeExternal(Element parentNode) {
        boolean useOldFontFormat;
        parentNode.setAttribute("name", this.getName());
        parentNode.setAttribute(VERSION_ATTR, Integer.toString(this.myVersion));
        if (!(this.myFontPreferences instanceof DelegatingFontPreferences) || !(this.myConsoleFontPreferences instanceof DelegatingFontPreferences)) {
            JdomKt.addOptionTag((Element)parentNode, (String)FONT_SCALE, (String)String.valueOf(UISettings.getDefFontScale()));
        }
        if (this.myParentScheme != null && this.myParentScheme != EmptyColorScheme.INSTANCE) {
            parentNode.setAttribute(PARENT_SCHEME_ATTR, this.myParentScheme.getName());
        }
        if (!this.myMetaInfo.isEmpty()) {
            parentNode.addContent(this.metaInfoToElement());
        }
        boolean bl = useOldFontFormat = this.myFontPreferences.getEffectiveFontFamilies().size() <= 1;
        if (!(this.myFontPreferences instanceof DelegatingFontPreferences)) {
            JdomKt.addOptionTag((Element)parentNode, (String)LINE_SPACING, (String)String.valueOf(this.getLineSpacing()));
            if (useOldFontFormat) {
                JdomKt.addOptionTag((Element)parentNode, (String)EDITOR_FONT_SIZE, (String)String.valueOf(this.getEditorFontSize()));
                JdomKt.addOptionTag((Element)parentNode, (String)EDITOR_FONT_NAME, (String)this.myFontPreferences.getFontFamily());
            } else {
                AbstractColorsScheme.writeFontPreferences(EDITOR_FONT, parentNode, this.myFontPreferences);
            }
            AbstractColorsScheme.writeLigaturesPreferences(parentNode, this.myFontPreferences, EDITOR_LIGATURES);
        }
        if (!(this.myConsoleFontPreferences instanceof DelegatingFontPreferences)) {
            if (this.myConsoleFontPreferences.getEffectiveFontFamilies().size() <= 1) {
                JdomKt.addOptionTag((Element)parentNode, (String)CONSOLE_FONT_NAME, (String)this.getConsoleFontName());
                if (this.getConsoleFontSize() != this.getEditorFontSize()) {
                    JdomKt.addOptionTag((Element)parentNode, (String)CONSOLE_FONT_SIZE, (String)Integer.toString(this.getConsoleFontSize()));
                }
            } else {
                AbstractColorsScheme.writeFontPreferences(CONSOLE_FONT, parentNode, this.myConsoleFontPreferences);
            }
            AbstractColorsScheme.writeLigaturesPreferences(parentNode, this.myConsoleFontPreferences, CONSOLE_LIGATURES);
            if (this.myFontPreferences instanceof DelegatingFontPreferences || this.getConsoleLineSpacing() != this.getLineSpacing()) {
                JdomKt.addOptionTag((Element)parentNode, (String)CONSOLE_LINE_SPACING, (String)Float.toString(this.getConsoleLineSpacing()));
            }
        }
        if (DEFAULT_FONT_SIZE != this.getQuickDocFontSize()) {
            JdomKt.addOptionTag((Element)parentNode, (String)EDITOR_QUICK_JAVADOC_FONT_SIZE, (String)this.getQuickDocFontSize().toString());
        }
        Element colorElements = new Element(COLORS_ELEMENT);
        Element attrElements = new Element(ATTRIBUTES_ELEMENT);
        this.writeColors(colorElements);
        this.writeAttributes(attrElements);
        if (!colorElements.getChildren().isEmpty()) {
            parentNode.addContent(colorElements);
        }
        if (!attrElements.getChildren().isEmpty()) {
            parentNode.addContent(attrElements);
        }
        this.myIsSaveNeeded = false;
    }

    private static void writeLigaturesPreferences(Element parentNode, FontPreferences preferences, String optionName) {
        if (preferences.useLigatures()) {
            JdomKt.addOptionTag((Element)parentNode, (String)optionName, (String)String.valueOf(true));
        }
    }

    private static void writeFontPreferences(@NotNull String key, @NotNull Element parent, @NotNull FontPreferences preferences) {
        for (String fontFamily : preferences.getRealFontFamilies()) {
            Element element = new Element(key);
            JdomKt.addOptionTag((Element)element, (String)EDITOR_FONT_NAME, (String)fontFamily);
            JdomKt.addOptionTag((Element)element, (String)EDITOR_FONT_SIZE, (String)String.valueOf(preferences.getSize(fontFamily)));
            parent.addContent(element);
        }
    }

    private void writeAttributes(@NotNull Element attrElements) {
        ArrayList<Map.Entry<String, TextAttributes>> list2 = new ArrayList<Map.Entry<String, TextAttributes>>(this.myAttributesMap.entrySet());
        list2.sort(Map.Entry.comparingByKey());
        for (Map.Entry entry : list2) {
            String keyName = (String)entry.getKey();
            TextAttributes attributes = (TextAttributes)entry.getValue();
            this.writeAttribute(attrElements, TextAttributesKey.find((String)keyName), attributes);
        }
    }

    private void writeAttribute(@NotNull Element attrElements, @NotNull TextAttributesKey key, @NotNull TextAttributes attributes) {
        if (attributes == INHERITED_ATTRS_MARKER) {
            boolean parentOverwritingInheritance;
            TextAttributesKey baseKey = key.getFallbackAttributeKey();
            TextAttributes parentAttributes = this.myParentScheme instanceof AbstractColorsScheme ? ((AbstractColorsScheme)this.myParentScheme).getDirectlyDefinedAttributes(key) : null;
            boolean bl = parentOverwritingInheritance = parentAttributes != null && parentAttributes != INHERITED_ATTRS_MARKER;
            if (parentOverwritingInheritance) {
                attrElements.addContent(new Element(OPTION_ELEMENT).setAttribute("name", key.getExternalName()).setAttribute(BASE_ATTRIBUTES_ATTR, baseKey != null ? baseKey.getExternalName() : ""));
            }
            return;
        }
        if (this.myParentScheme != null) {
            TextAttributes parentAttributes;
            TextAttributes textAttributes = parentAttributes = this.myParentScheme instanceof AbstractColorsScheme ? ((AbstractColorsScheme)this.myParentScheme).getDirectlyDefinedAttributes(key) : this.myParentScheme.getAttributes(key);
            if (attributes.equals((Object)parentAttributes)) {
                return;
            }
        }
        Element valueElement = new Element(VALUE_ELEMENT);
        attributes.writeExternal(valueElement);
        attrElements.addContent(new Element(OPTION_ELEMENT).setAttribute("name", key.getExternalName()).addContent(valueElement));
    }

    public void optimizeAttributeMap() {
        EditorColorsScheme parentScheme = this.myParentScheme;
        if (parentScheme == null) {
            return;
        }
        this.myAttributesMap.entrySet().removeIf(entry -> {
            String keyName = (String)entry.getKey();
            TextAttributes attrs = (TextAttributes)entry.getValue();
            TextAttributesKey key = TextAttributesKey.find((String)keyName);
            if (attrs == INHERITED_ATTRS_MARKER) {
                return !AbstractColorsScheme.hasExplicitlyDefinedAttributes(parentScheme, key);
            }
            TextAttributes parent = parentScheme instanceof DefaultColorsScheme ? ((DefaultColorsScheme)parentScheme).getAttributes(key, false) : parentScheme.getAttributes(key);
            return Comparing.equal((Object)parent, (Object)attrs);
        });
        this.myColorsMap.keySet().removeAll(JBIterable.from(this.myColorsMap.keySet()).filter(key -> {
            Color color = this.myColorsMap.get(key);
            if (color == INHERITED_COLOR_MARKER) {
                return !AbstractColorsScheme.hasExplicitlyDefinedColors(parentScheme, key);
            }
            Color parent = parentScheme instanceof DefaultColorsScheme ? ((DefaultColorsScheme)parentScheme).getColor((ColorKey)key, false) : parentScheme.getColor(key);
            return Comparing.equal((Object)parent, (Object)(color == NULL_COLOR_MARKER ? null : color));
        }).toList());
    }

    private static boolean hasExplicitlyDefinedAttributes(@NotNull EditorColorsScheme scheme2, @NotNull TextAttributesKey key) {
        TextAttributes directAttrs = scheme2 instanceof DefaultColorsScheme ? ((DefaultColorsScheme)scheme2).getDirectlyDefinedAttributes(key) : null;
        return directAttrs != null && directAttrs != INHERITED_ATTRS_MARKER;
    }

    private static boolean hasExplicitlyDefinedColors(@NotNull EditorColorsScheme scheme2, @NotNull ColorKey key) {
        Color directColor = scheme2 instanceof DefaultColorsScheme ? ((DefaultColorsScheme)scheme2).getDirectlyDefinedColor(key) : null;
        return directColor != null && directColor != INHERITED_COLOR_MARKER;
    }

    @NotNull
    private Element metaInfoToElement() {
        Element metaInfoElement = new Element(META_INFO_ELEMENT);
        this.myMetaInfo.setProperty(META_INFO_MODIFIED_TIME, META_INFO_DATE_FORMAT.format(new Date()));
        ArrayList<String> sortedPropertyNames = new ArrayList<String>(this.myMetaInfo.stringPropertyNames());
        sortedPropertyNames.sort(null);
        for (String propertyName : sortedPropertyNames) {
            String value = this.myMetaInfo.getProperty(propertyName);
            Element propertyInfo = new Element(PROPERTY_ELEMENT);
            propertyInfo.setAttribute("name", propertyName);
            propertyInfo.setText(value);
            metaInfoElement.addContent(propertyInfo);
        }
        return metaInfoElement;
    }

    private void writeColors(Element colorElements) {
        ArrayList<ColorKey> list2 = new ArrayList<ColorKey>(this.myColorsMap.keySet());
        list2.sort(null);
        for (ColorKey key : list2) {
            this.writeColor(colorElements, key);
        }
    }

    private void writeColor(@NotNull Element colorElements, @NotNull ColorKey key) {
        Color color = this.myColorsMap.get(key);
        if (color == INHERITED_COLOR_MARKER) {
            boolean parentOverwritingInheritance;
            ColorKey fallbackKey = key.getFallbackColorKey();
            Color parentFallback = this.myParentScheme instanceof AbstractColorsScheme ? ((AbstractColorsScheme)this.myParentScheme).getDirectlyDefinedColor(key) : null;
            boolean bl = parentOverwritingInheritance = parentFallback != null && parentFallback != INHERITED_COLOR_MARKER;
            if (fallbackKey != null && parentOverwritingInheritance) {
                colorElements.addContent(new Element(OPTION_ELEMENT).setAttribute("name", key.getExternalName()).setAttribute(BASE_ATTRIBUTES_ATTR, fallbackKey.getExternalName()));
            }
            return;
        }
        if (this.myParentScheme != null) {
            Color parent;
            Color color2 = parent = this.myParentScheme instanceof AbstractColorsScheme ? ((AbstractColorsScheme)this.myParentScheme).getDirectlyDefinedColor(key) : this.myParentScheme.getColor(key);
            if (parent != null && AbstractColorsScheme.colorsEqual(color, parent)) {
                return;
            }
        }
        String rgb = "";
        if (color != NULL_COLOR_MARKER) {
            rgb = Integer.toString(0xFFFFFF & color.getRGB(), 16);
            int alpha = 0xFF & color.getAlpha();
            if (alpha != 255) {
                rgb = rgb + Integer.toString(alpha, 16);
            }
        }
        JdomKt.addOptionTag((Element)colorElements, (String)key.getExternalName(), (String)rgb);
    }

    protected static boolean colorsEqual(@Nullable Color c1, @Nullable Color c2) {
        if (c1 == NULL_COLOR_MARKER) {
            return c1 == c2;
        }
        return Comparing.equal((Object)c1, (Object)(c2 == NULL_COLOR_MARKER ? null : c2));
    }

    private ModifiableFontPreferences ensureEditableFontPreferences() {
        if (!(this.myFontPreferences instanceof ModifiableFontPreferences)) {
            FontPreferencesImpl editablePrefs = new FontPreferencesImpl();
            this.myFontPreferences.copyTo((FontPreferences)editablePrefs);
            this.myFontPreferences = editablePrefs;
            ((FontPreferencesImpl)this.myFontPreferences).setChangeListener(() -> this.initFonts());
        }
        return (ModifiableFontPreferences)this.myFontPreferences;
    }

    @NotNull
    public FontPreferences getConsoleFontPreferences() {
        return this.myConsoleFontPreferences;
    }

    public void setUseEditorFontPreferencesInConsole() {
        this.myConsoleFontPreferences = new DelegatingFontPreferences(() -> this.myFontPreferences);
        this.initFonts();
    }

    public boolean isUseEditorFontPreferencesInConsole() {
        return this.myConsoleFontPreferences instanceof DelegatingFontPreferences;
    }

    public void setConsoleFontPreferences(@NotNull FontPreferences preferences) {
        preferences.copyTo((FontPreferences)this.ensureEditableConsoleFontPreferences());
        this.initFonts();
    }

    public String getConsoleFontName() {
        return this.myConsoleFontPreferences.getFontFamily();
    }

    private ModifiableFontPreferences ensureEditableConsoleFontPreferences() {
        if (!(this.myConsoleFontPreferences instanceof ModifiableFontPreferences)) {
            FontPreferencesImpl editablePrefs = new FontPreferencesImpl();
            this.myConsoleFontPreferences.copyTo((FontPreferences)editablePrefs);
            this.myConsoleFontPreferences = editablePrefs;
        }
        return (ModifiableFontPreferences)this.myConsoleFontPreferences;
    }

    public void setConsoleFontName(String fontName) {
        ModifiableFontPreferences consolePreferences = this.ensureEditableConsoleFontPreferences();
        int consoleFontSize = this.getConsoleFontSize();
        consolePreferences.clear();
        consolePreferences.register(fontName, consoleFontSize);
    }

    public int getConsoleFontSize() {
        String font = this.getConsoleFontName();
        UISettings uiSettings = UISettings.getInstanceOrNull();
        if ((uiSettings == null || !uiSettings.getPresentationMode()) && this.myConsoleFontPreferences.hasSize(font)) {
            return this.myConsoleFontPreferences.getSize(font);
        }
        return this.getEditorFontSize();
    }

    public void setConsoleFontSize(int fontSize) {
        ModifiableFontPreferences consoleFontPreferences = this.ensureEditableConsoleFontPreferences();
        fontSize = EditorFontsConstants.checkAndFixEditorFontSize(fontSize);
        consoleFontPreferences.register(this.getConsoleFontName(), fontSize);
        this.initFonts();
    }

    public float getConsoleLineSpacing() {
        return this.myConsoleFontPreferences.getLineSpacing();
    }

    public void setConsoleLineSpacing(float lineSpacing) {
        this.ensureEditableConsoleFontPreferences().setLineSpacing(lineSpacing);
    }

    @Nullable
    protected TextAttributes getFallbackAttributes(@NotNull TextAttributesKey fallbackKey) {
        TextAttributesKey cur = fallbackKey;
        while (true) {
            TextAttributes attrs = this.getDirectlyDefinedAttributes(cur);
            TextAttributesKey next = cur.getFallbackAttributeKey();
            if (attrs != null && (attrs != INHERITED_ATTRS_MARKER || next == null)) {
                return attrs;
            }
            if (next == null) {
                return null;
            }
            cur = next;
        }
    }

    @Nullable
    protected Color getFallbackColor(@NotNull ColorKey fallbackKey) {
        ColorKey cur = fallbackKey;
        Color color;
        while ((color = this.getDirectlyDefinedColor(cur)) != NULL_COLOR_MARKER) {
            ColorKey next = cur.getFallbackColorKey();
            if (color != null && (color != INHERITED_COLOR_MARKER || next == null)) {
                return color;
            }
            if (next == null) {
                return null;
            }
            cur = next;
        }
        return null;
    }

    @Nullable
    public TextAttributes getDirectlyDefinedAttributes(@NotNull TextAttributesKey key) {
        TextAttributes attributes = this.myAttributesMap.get(key.getExternalName());
        return attributes != null ? attributes : (this.myParentScheme instanceof AbstractColorsScheme ? ((AbstractColorsScheme)this.myParentScheme).getDirectlyDefinedAttributes(key) : null);
    }

    @Nullable
    public Color getDirectlyDefinedColor(@NotNull ColorKey key) {
        Color color = this.myColorsMap.get(key);
        return color != null ? color : (this.myParentScheme instanceof AbstractColorsScheme ? ((AbstractColorsScheme)this.myParentScheme).getDirectlyDefinedColor(key) : null);
    }

    @Override
    @NotNull
    public SchemeState getSchemeState() {
        return this.myIsSaveNeeded ? SchemeState.POSSIBLY_CHANGED : SchemeState.UNCHANGED;
    }

    public void setSaveNeeded(boolean value) {
        this.myIsSaveNeeded = value;
    }

    public boolean isReadOnly() {
        return false;
    }

    @NotNull
    public Properties getMetaProperties() {
        return this.myMetaInfo;
    }

    public boolean canBeDeleted() {
        return this.myCanBeDeleted;
    }

    public void setCanBeDeleted(boolean canBeDeleted) {
        this.myCanBeDeleted = canBeDeleted;
    }

    public boolean isVisible() {
        return true;
    }

    public static boolean isVisible(@NotNull EditorColorsScheme scheme2) {
        return !(scheme2 instanceof AbstractColorsScheme) || ((AbstractColorsScheme)scheme2).isVisible();
    }

    @Nullable
    public AbstractColorsScheme getOriginal() {
        EditorColorsScheme originalScheme;
        String originalSchemeName = this.getMetaProperties().getProperty(META_INFO_ORIGINAL);
        if (originalSchemeName != null && (originalScheme = EditorColorsManager.getInstance().getScheme(originalSchemeName)) instanceof AbstractColorsScheme && originalScheme != this) {
            return (AbstractColorsScheme)originalScheme;
        }
        return null;
    }

    public EditorColorsScheme getParentScheme() {
        return this.myParentScheme;
    }

    @Override
    @NotNull
    public Element writeScheme() {
        Element root = new Element(SCHEME_ELEMENT);
        this.writeExternal(root);
        return root;
    }

    public boolean settingsEqual(Object other) {
        return this.settingsEqual(other, null);
    }

    public boolean settingsEqual(Object other, @Nullable Predicate<ColorKey> colorKeyFilter) {
        if (!(other instanceof AbstractColorsScheme)) {
            return false;
        }
        AbstractColorsScheme otherScheme = (AbstractColorsScheme)other;
        if (AbstractColorsScheme.getBaseDefaultScheme(this) != AbstractColorsScheme.getBaseDefaultScheme(otherScheme)) {
            return false;
        }
        for (String propertyName : this.myMetaInfo.stringPropertyNames()) {
            if (propertyName.equals(META_INFO_CREATION_TIME) || propertyName.equals(META_INFO_MODIFIED_TIME) || propertyName.equals(META_INFO_IDE) || propertyName.equals(META_INFO_IDE_VERSION) || propertyName.equals(META_INFO_ORIGINAL) || Comparing.equal((String)this.myMetaInfo.getProperty(propertyName), (String)otherScheme.myMetaInfo.getProperty(propertyName))) continue;
            return false;
        }
        return AbstractColorsScheme.areDelegatingOrEqual(this.myFontPreferences, otherScheme.getFontPreferences()) && AbstractColorsScheme.areDelegatingOrEqual(this.myConsoleFontPreferences, otherScheme.getConsoleFontPreferences()) && this.attributesEqual(otherScheme) && this.colorsEqual(otherScheme, colorKeyFilter);
    }

    protected static boolean areDelegatingOrEqual(@NotNull FontPreferences preferences1, @NotNull FontPreferences preferences2) {
        boolean isDelegating1 = preferences1 instanceof DelegatingFontPreferences;
        boolean isDelegating2 = preferences2 instanceof DelegatingFontPreferences;
        return isDelegating1 || isDelegating2 ? isDelegating1 && isDelegating2 : preferences1.equals(preferences2);
    }

    protected boolean attributesEqual(AbstractColorsScheme otherScheme) {
        return this.myAttributesMap.equals(otherScheme.myAttributesMap);
    }

    protected boolean colorsEqual(AbstractColorsScheme otherScheme, @Nullable Predicate<ColorKey> colorKeyFilter) {
        if (this.myColorsMap.size() != otherScheme.myColorsMap.size()) {
            return false;
        }
        for (Map.Entry<ColorKey, Color> entry : this.myColorsMap.entrySet()) {
            ColorKey key;
            Color c2;
            Color c1 = entry.getValue();
            if (AbstractColorsScheme.colorsEqual(c1, c2 = otherScheme.myColorsMap.get(key = entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private static EditorColorsScheme getBaseDefaultScheme(@NotNull EditorColorsScheme scheme2) {
        if (!(scheme2 instanceof AbstractColorsScheme)) {
            return null;
        }
        if (scheme2 instanceof DefaultColorsScheme) {
            return scheme2;
        }
        EditorColorsScheme parent = ((AbstractColorsScheme)scheme2).myParentScheme;
        return parent != null ? AbstractColorsScheme.getBaseDefaultScheme(parent) : null;
    }

    public void setParent(@NotNull EditorColorsScheme newParent) {
        assert (newParent instanceof ReadOnlyColorsScheme) : "New parent scheme must be read-only";
        this.myParentScheme = newParent;
    }

    void resolveParent(@NotNull Function<? super String, ? extends EditorColorsScheme> nameResolver) {
        if (this.myParentScheme instanceof TemporaryParent) {
            String parentName = ((TemporaryParent)this.myParentScheme).getParentName();
            EditorColorsScheme newParent = nameResolver.apply(parentName);
            if (!(newParent instanceof ReadOnlyColorsScheme)) {
                throw new InvalidDataException(parentName);
            }
            this.myParentScheme = newParent;
        }
    }

    private static class TemporaryParent
    extends EditorColorsSchemeImpl {
        private final String myParentName;

        TemporaryParent(@NotNull String parentName) {
            super(EmptyColorScheme.INSTANCE);
            this.myParentName = parentName;
        }

        public String getParentName() {
            return this.myParentName;
        }

        @Override
        public TextAttributes getAttributes(@Nullable TextAttributesKey key) {
            return super.getAttributes(key);
        }

        @Override
        @Nullable
        public Color getColor(ColorKey key) {
            return super.getColor(key);
        }
    }
}

