/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors.impl;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.editor.colors.EditorFontCache;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.colors.ModifiableFontPreferences;
import com.intellij.openapi.editor.colors.impl.FontPreferencesImpl;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="DefaultFont", storages={@Storage(value="editor.xml")})
public class AppEditorFontOptions
implements PersistentStateComponent<PersistentFontPreferences> {
    private final FontPreferencesImpl myFontPreferences = new FontPreferencesImpl();

    public AppEditorFontOptions() {
        this.myFontPreferences.register(FontPreferences.DEFAULT_FONT_NAME, UISettings.restoreFontSize((int)FontPreferences.DEFAULT_FONT_SIZE, (Float)Float.valueOf(1.0f)));
    }

    public static AppEditorFontOptions getInstance() {
        return (AppEditorFontOptions)ServiceManager.getService(AppEditorFontOptions.class);
    }

    @Nullable
    public PersistentFontPreferences getState() {
        return new PersistentFontPreferences((FontPreferences)this.myFontPreferences);
    }

    public void loadState(@NotNull PersistentFontPreferences state) {
        AppEditorFontOptions.copyState(state, this.myFontPreferences);
        this.myFontPreferences.setChangeListener(() -> EditorFontCache.getInstance().reset());
    }

    private static void copyState(PersistentFontPreferences state, @NotNull ModifiableFontPreferences fontPreferences) {
        fontPreferences.clear();
        int fontSize = UISettings.restoreFontSize((int)state.FONT_SIZE, (Float)Float.valueOf(state.FONT_SCALE));
        fontPreferences.register(state.FONT_FAMILY, fontSize);
        fontPreferences.setLineSpacing(state.LINE_SPACING);
        fontPreferences.setUseLigatures(state.USE_LIGATURES);
        if (state.SECONDARY_FONT_FAMILY != null) {
            fontPreferences.register(state.SECONDARY_FONT_FAMILY, fontSize);
        }
    }

    public static void initDefaults(@NotNull ModifiableFontPreferences fontPreferences) {
        AppEditorFontOptions.copyState(PersistentFontPreferences.getDefaultState(), fontPreferences);
    }

    @NotNull
    public FontPreferences getFontPreferences() {
        return this.myFontPreferences;
    }

    public static class PersistentFontPreferences {
        public int FONT_SIZE = FontPreferences.DEFAULT_FONT_SIZE;
        @NotNull
        public String FONT_FAMILY = FontPreferences.DEFAULT_FONT_NAME;
        public float FONT_SCALE = 1.0f;
        public float LINE_SPACING = 1.0f;
        public boolean USE_LIGATURES = false;
        @Nullable
        public String SECONDARY_FONT_FAMILY;

        private PersistentFontPreferences() {
        }

        public PersistentFontPreferences(FontPreferences fontPreferences) {
            this.FONT_FAMILY = fontPreferences.getFontFamily();
            this.FONT_SIZE = fontPreferences.getSize(this.FONT_FAMILY);
            this.FONT_SCALE = UISettings.getDefFontScale();
            this.LINE_SPACING = fontPreferences.getLineSpacing();
            this.USE_LIGATURES = fontPreferences.useLigatures();
            List fontFamilies = fontPreferences.getEffectiveFontFamilies();
            if (fontFamilies.size() > 1) {
                this.SECONDARY_FONT_FAMILY = (String)fontFamilies.get(1);
            }
        }

        private static PersistentFontPreferences getDefaultState() {
            return new PersistentFontPreferences();
        }
    }
}

