/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors.impl;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.configurationStore.BundledSchemeEP;
import com.intellij.configurationStore.LazySchemeProcessor;
import com.intellij.configurationStore.SchemeDataHolder;
import com.intellij.configurationStore.SchemeExtensionProvider;
import com.intellij.ide.WelcomeWizardUtil;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.UITheme;
import com.intellij.ide.ui.laf.TempUIThemeBasedLookAndFeelInfo;
import com.intellij.ide.ui.laf.UIThemeBasedLookAndFeelInfo;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.ex.DefaultColorSchemesManager;
import com.intellij.openapi.editor.colors.impl.AbstractColorsScheme;
import com.intellij.openapi.editor.colors.impl.AdditionalTextAttributesEP;
import com.intellij.openapi.editor.colors.impl.DefaultColorsScheme;
import com.intellij.openapi.editor.colors.impl.EditorColorSchemesComparator;
import com.intellij.openapi.editor.colors.impl.EditorColorsSchemeImpl;
import com.intellij.openapi.editor.colors.impl.ReadOnlyColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.options.SchemeManager;
import com.intellij.openapi.options.SchemeManagerFactory;
import com.intellij.openapi.options.SchemeState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiModificationTrackerImpl;
import com.intellij.util.ComponentTreeEventDispatcher;
import com.intellij.util.JdomKt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.io.URLUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.xmlb.annotations.OptionTag;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Function;
import javax.swing.UIManager;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="EditorColorsManagerImpl", storages={@Storage(value="colors.scheme.xml")}, additionalExportFile="colors")
public class EditorColorsManagerImpl
extends EditorColorsManager
implements PersistentStateComponent<State> {
    private static final Logger LOG = Logger.getInstance(EditorColorsManagerImpl.class);
    private static final ExtensionPointName<BundledSchemeEP> BUNDLED_EP_NAME = ExtensionPointName.create((String)"com.intellij.bundledColorScheme");
    private final ComponentTreeEventDispatcher<EditorColorsListener> myTreeDispatcher = ComponentTreeEventDispatcher.create(EditorColorsListener.class);
    private final DefaultColorSchemesManager myDefaultColorSchemeManager;
    private final SchemeManager<EditorColorsScheme> mySchemeManager;
    static final String FILE_SPEC = "colors";
    private State myState = new State();
    private static final String TEMP_SCHEME_KEY = "TEMP_SCHEME_KEY";
    private static final String TEMP_SCHEME_FILE_KEY = "TEMP_SCHEME_FILE_KEY";

    public EditorColorsManagerImpl(@NotNull DefaultColorSchemesManager defaultColorSchemeManager, @NotNull SchemeManagerFactory schemeManagerFactory) {
        this.myDefaultColorSchemeManager = defaultColorSchemeManager;
        class EditorColorSchemeProcessor
        extends LazySchemeProcessor<EditorColorsScheme, EditorColorsSchemeImpl>
        implements SchemeExtensionProvider {
            EditorColorSchemeProcessor() {
            }

            @Override
            @NotNull
            public EditorColorsSchemeImpl createScheme(@NotNull SchemeDataHolder<? super EditorColorsSchemeImpl> dataHolder, @NotNull String name, @NotNull Function<? super String, String> attributeProvider2, boolean isBundled) {
                EditorColorsSchemeImpl scheme2 = isBundled ? new BundledScheme() : new EditorColorsSchemeImpl(null);
                scheme2.readExternal(dataHolder.read());
                if (isBundled) {
                    scheme2.optimizeAttributeMap();
                }
                return scheme2;
            }

            @Override
            @NotNull
            public SchemeState getState(@NotNull EditorColorsScheme scheme2) {
                return scheme2 instanceof ReadOnlyColorsScheme ? SchemeState.NON_PERSISTENT : SchemeState.POSSIBLY_CHANGED;
            }

            @Override
            public void onCurrentSchemeSwitched(@Nullable EditorColorsScheme oldScheme, @Nullable EditorColorsScheme newScheme) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    LafManager.getInstance().updateUI();
                    EditorColorsManagerImpl.this.schemeChangedOrSwitched(newScheme);
                });
            }

            @Override
            @NotNull
            @NonNls
            public String getSchemeExtension() {
                return ".icls";
            }

            @Override
            public boolean isSchemeEqualToBundled(@NotNull EditorColorsSchemeImpl scheme2) {
                if (!scheme2.getName().startsWith("_@user_")) {
                    return false;
                }
                AbstractColorsScheme bundledScheme = (AbstractColorsScheme)EditorColorsManagerImpl.this.mySchemeManager.findSchemeByName(scheme2.getName().substring("_@user_".length()));
                if (bundledScheme == null) {
                    return false;
                }
                return scheme2.settingsEqual(bundledScheme);
            }

            @Override
            public void reloaded(@NotNull SchemeManager<EditorColorsScheme> schemeManager2, @NotNull Collection<? extends EditorColorsScheme> schemes) {
                EditorColorsManagerImpl.this.loadBundledSchemes();
                EditorColorsManagerImpl.this.loadSchemesFromThemes();
                EditorColorsManagerImpl.this.initEditableDefaultSchemesCopies();
                EditorColorsManagerImpl.this.initEditableBundledSchemesCopies();
            }
        }
        this.mySchemeManager = schemeManagerFactory.create(FILE_SPEC, new EditorColorSchemeProcessor());
        this.initDefaultSchemes();
        this.loadBundledSchemes();
        this.loadSchemesFromThemes();
        this.mySchemeManager.loadSchemes();
        this.initEditableDefaultSchemesCopies();
        this.initEditableBundledSchemesCopies();
        this.resolveLinksToBundledSchemes();
        this.initScheme();
    }

    private void initDefaultSchemes() {
        for (DefaultColorsScheme defaultScheme : this.myDefaultColorSchemeManager.getAllSchemes()) {
            this.mySchemeManager.addScheme(defaultScheme);
        }
        this.loadAdditionalTextAttributes();
    }

    private void initEditableDefaultSchemesCopies() {
        for (DefaultColorsScheme defaultScheme : this.myDefaultColorSchemeManager.getAllSchemes()) {
            if (!defaultScheme.hasEditableCopy()) continue;
            this.createEditableCopy(defaultScheme, defaultScheme.getEditableCopyName());
        }
    }

    private void initScheme() {
        String schemeName;
        LafManager lm;
        UIManager.LookAndFeelInfo laf;
        String wizardEditorScheme = WelcomeWizardUtil.getWizardEditorScheme();
        EditorColorsScheme scheme2 = null;
        if (wizardEditorScheme != null) {
            scheme2 = this.getScheme(wizardEditorScheme);
            LOG.assertTrue(scheme2 != null, (Object)("Wizard scheme " + wizardEditorScheme + " not found"));
        }
        if (scheme2 == null && (laf = (lm = LafManager.getInstance()).getCurrentLookAndFeel()) instanceof UIThemeBasedLookAndFeelInfo && (schemeName = ((UIThemeBasedLookAndFeelInfo)laf).getTheme().getEditorSchemeName()) != null) {
            scheme2 = this.getScheme(schemeName);
        }
        if (scheme2 == null) {
            scheme2 = UIUtil.isUnderDarcula() ? this.getScheme("Darcula") : this.getDefaultScheme();
        }
        this.setGlobalSchemeInner(scheme2);
    }

    private void loadBundledSchemes() {
        if (!EditorColorsManagerImpl.isUnitTestOrHeadlessMode()) {
            for (BundledSchemeEP ep : BUNDLED_EP_NAME.getExtensionList()) {
                this.mySchemeManager.loadBundledScheme(ep.getPath() + ".xml", (Object)ep);
            }
        }
    }

    private void loadSchemesFromThemes() {
        if (!EditorColorsManagerImpl.isUnitTestOrHeadlessMode()) {
            for (UIManager.LookAndFeelInfo laf : LafManager.getInstance().getInstalledLookAndFeels()) {
                UITheme theme;
                String path;
                if (!(laf instanceof UIThemeBasedLookAndFeelInfo) || (path = (theme = ((UIThemeBasedLookAndFeelInfo)laf).getTheme()).getEditorScheme()) == null) continue;
                this.mySchemeManager.loadBundledScheme(path, theme);
            }
        }
    }

    private void initEditableBundledSchemesCopies() {
        for (EditorColorsScheme scheme2 : this.mySchemeManager.getAllSchemes()) {
            if (!(scheme2 instanceof BundledScheme)) continue;
            this.createEditableCopy((BundledScheme)scheme2, "_@user_" + scheme2.getName());
        }
    }

    private void resolveLinksToBundledSchemes() {
        ArrayList<EditorColorsScheme> brokenSchemesList = new ArrayList<EditorColorsScheme>();
        for (EditorColorsScheme scheme2 : this.mySchemeManager.getAllSchemes()) {
            try {
                this.resolveSchemeParent(scheme2);
            }
            catch (InvalidDataException e) {
                brokenSchemesList.add(scheme2);
                String message = "Color scheme '" + scheme2.getName() + "' points to incorrect or non-existent default (base) scheme " + e.getMessage();
                Notifications.Bus.notify((Notification)new Notification("System Messages", "Incompatible color scheme", message, NotificationType.ERROR));
            }
        }
        for (EditorColorsScheme brokenScheme : brokenSchemesList) {
            this.mySchemeManager.removeScheme(brokenScheme);
        }
    }

    public void resolveSchemeParent(@NotNull EditorColorsScheme scheme2) {
        if (scheme2 instanceof AbstractColorsScheme && !(scheme2 instanceof ReadOnlyColorsScheme)) {
            ((AbstractColorsScheme)scheme2).resolveParent(name -> this.mySchemeManager.findSchemeByName((String)name));
        }
    }

    private void createEditableCopy(@NotNull AbstractColorsScheme initialScheme, @NotNull String editableCopyName) {
        AbstractColorsScheme editableCopy = (AbstractColorsScheme)this.getScheme(editableCopyName);
        if (editableCopy == null) {
            editableCopy = (AbstractColorsScheme)initialScheme.clone();
            editableCopy.setName(editableCopyName);
            this.mySchemeManager.addScheme(editableCopy);
        }
        editableCopy.setCanBeDeleted(false);
    }

    @Deprecated
    public static void schemeChangedOrSwitched() {
        EditorColorsManagerImpl manager = (EditorColorsManagerImpl)EditorColorsManagerImpl.getInstance();
        manager.schemeChangedOrSwitched(manager.getGlobalScheme());
    }

    public void schemeChangedOrSwitched(@Nullable EditorColorsScheme newScheme) {
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            DaemonCodeAnalyzer.getInstance((Project)project).restart();
            ((PsiModificationTrackerImpl)PsiManager.getInstance((Project)project).getModificationTracker()).incCounter();
        }
        ((EditorColorsListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(TOPIC)).globalSchemeChange(newScheme);
        ((EditorColorsListener)this.myTreeDispatcher.getMulticaster()).globalSchemeChange(newScheme);
    }

    private static boolean isUnitTestOrHeadlessMode() {
        return ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isHeadlessEnvironment();
    }

    public TextAttributes getDefaultAttributes(@NotNull TextAttributesKey key) {
        boolean dark = UIUtil.isUnderDarcula() && this.getScheme("Darcula") != null;
        return this.getScheme(dark ? "Darcula" : "Default").getAttributes(key);
    }

    private void loadAdditionalTextAttributes() {
        for (AdditionalTextAttributesEP attributesEP : (AdditionalTextAttributesEP[])AdditionalTextAttributesEP.EP_NAME.getExtensions()) {
            EditorColorsScheme editorColorsScheme = this.mySchemeManager.findSchemeByName(attributesEP.scheme);
            if (editorColorsScheme == null) {
                if (EditorColorsManagerImpl.isUnitTestOrHeadlessMode()) continue;
                LOG.warn("Cannot find scheme: " + attributesEP.scheme + " from plugin: " + attributesEP.getPluginDescriptor().getPluginId());
                continue;
            }
            URL resource = attributesEP.getLoaderForClass().getResource(attributesEP.file);
            if (resource == null) {
                LOG.warn("resource not found: " + attributesEP.file);
                continue;
            }
            try {
                Element root = JdomKt.loadElement((InputStream)URLUtil.openStream((URL)resource));
                Element attrs = (Element)ObjectUtils.notNull((Object)root.getChild("attributes"), (Object)root);
                Element colors = root.getChild(FILE_SPEC);
                AbstractColorsScheme scheme2 = (AbstractColorsScheme)editorColorsScheme;
                scheme2.readAttributes(attrs);
                if (colors == null) continue;
                scheme2.readColors(colors);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
    }

    public void addColorsScheme(@NotNull EditorColorsScheme scheme2) {
        if (!this.isDefaultScheme(scheme2) && !StringUtil.isEmpty((String)scheme2.getName())) {
            this.mySchemeManager.addScheme(scheme2);
        }
    }

    public void removeAllSchemes() {
    }

    @NotNull
    public EditorColorsScheme[] getAllSchemes() {
        EditorColorsScheme[] result2 = EditorColorsManagerImpl.getAllVisibleSchemes(this.mySchemeManager.getAllSchemes());
        Arrays.sort(result2, EditorColorSchemesComparator.INSTANCE);
        return result2;
    }

    private static EditorColorsScheme[] getAllVisibleSchemes(@NotNull Collection<? extends EditorColorsScheme> schemes) {
        ArrayList<EditorColorsScheme> visibleSchemes = new ArrayList<EditorColorsScheme>(schemes.size() - 1);
        for (EditorColorsScheme editorColorsScheme : schemes) {
            if (!AbstractColorsScheme.isVisible(editorColorsScheme)) continue;
            visibleSchemes.add(editorColorsScheme);
        }
        return visibleSchemes.toArray(new EditorColorsScheme[0]);
    }

    public void setGlobalScheme(@Nullable EditorColorsScheme scheme2) {
        Application application = ApplicationManager.getApplication();
        boolean notify = application instanceof ApplicationImpl && ((ApplicationImpl)application).isLoaded();
        this.mySchemeManager.setCurrent(scheme2 == null ? this.getDefaultScheme() : scheme2, notify);
    }

    private void setGlobalSchemeInner(@Nullable EditorColorsScheme scheme2) {
        this.mySchemeManager.setCurrent(scheme2 == null ? this.getDefaultScheme() : scheme2, false);
    }

    @NotNull
    private EditorColorsScheme getDefaultScheme() {
        DefaultColorsScheme defaultScheme = this.myDefaultColorSchemeManager.getFirstScheme();
        String editableCopyName = defaultScheme.getEditableCopyName();
        EditorColorsScheme editableCopy = this.getScheme(editableCopyName);
        assert (editableCopy != null) : "An editable copy of " + defaultScheme.getName() + " has not been initialized.";
        return editableCopy;
    }

    @NotNull
    public EditorColorsScheme getGlobalScheme() {
        EditorColorsScheme scheme2 = this.mySchemeManager.getActiveScheme();
        EditorColorsScheme editableCopy = this.getEditableCopy(scheme2);
        if (editableCopy != null) {
            return editableCopy;
        }
        return scheme2 == null ? this.getDefaultScheme() : scheme2;
    }

    @Nullable
    private EditorColorsScheme getEditableCopy(EditorColorsScheme scheme2) {
        EditorColorsScheme editableCopy;
        if (EditorColorsManagerImpl.isTempScheme(scheme2)) {
            return scheme2;
        }
        String editableCopyName = EditorColorsManagerImpl.getEditableCopyName(scheme2);
        if (editableCopyName != null && (editableCopy = this.getScheme(editableCopyName)) != null) {
            return editableCopy;
        }
        return null;
    }

    @Nullable
    private static String getEditableCopyName(EditorColorsScheme scheme2) {
        String editableCopyName = null;
        if (scheme2 instanceof DefaultColorsScheme && ((DefaultColorsScheme)scheme2).hasEditableCopy()) {
            editableCopyName = ((DefaultColorsScheme)scheme2).getEditableCopyName();
        } else if (scheme2 instanceof BundledScheme) {
            editableCopyName = "_@user_" + scheme2.getName();
        }
        return editableCopyName;
    }

    public EditorColorsScheme getScheme(@NotNull String schemeName) {
        return this.mySchemeManager.findSchemeByName(schemeName);
    }

    public void setUseOnlyMonospacedFonts(boolean value) {
        this.myState.USE_ONLY_MONOSPACED_FONTS = value;
    }

    public boolean isUseOnlyMonospacedFonts() {
        return this.myState.USE_ONLY_MONOSPACED_FONTS;
    }

    @Nullable
    public State getState() {
        String currentSchemeName = this.mySchemeManager.getCurrentSchemeName();
        if (currentSchemeName != null && !EditorColorsManagerImpl.isTempScheme(this.mySchemeManager.getActiveScheme())) {
            this.myState.colorScheme = "Default".equals(currentSchemeName) || "_@user_Default".equals(currentSchemeName) ? null : currentSchemeName;
        }
        return this.myState;
    }

    public void loadState(@NotNull State state) {
        this.myState = state;
        this.setGlobalSchemeInner(this.myState.colorScheme == null ? this.getDefaultScheme() : this.mySchemeManager.findSchemeByName(this.myState.colorScheme));
    }

    public boolean isDefaultScheme(EditorColorsScheme scheme2) {
        return scheme2 instanceof DefaultColorsScheme;
    }

    @NotNull
    public EditorColorsScheme getSchemeForCurrentUITheme() {
        EditorColorsScheme editableCopy;
        UITheme theme;
        String schemeName;
        EditorColorsScheme globalScheme;
        UIManager.LookAndFeelInfo lookAndFeelInfo = LafManager.getInstance().getCurrentLookAndFeel();
        EditorColorsScheme scheme2 = null;
        if (lookAndFeelInfo instanceof TempUIThemeBasedLookAndFeelInfo && EditorColorsManagerImpl.isTempScheme(globalScheme = EditorColorsManager.getInstance().getGlobalScheme())) {
            return globalScheme;
        }
        if (lookAndFeelInfo instanceof UIThemeBasedLookAndFeelInfo && (schemeName = (theme = ((UIThemeBasedLookAndFeelInfo)lookAndFeelInfo).getTheme()).getEditorSchemeName()) != null) {
            scheme2 = this.getScheme(schemeName);
            assert (scheme2 != null) : "Theme " + theme.getName() + " refers to unknown color scheme " + schemeName;
        }
        if (scheme2 == null) {
            String schemeName2 = UIUtil.isUnderDarcula() ? "Darcula" : "Default";
            scheme2 = this.myDefaultColorSchemeManager.getScheme(schemeName2);
            assert (scheme2 != null) : "The default scheme '" + schemeName2 + "' not found, available schemes: " + Arrays.toString(this.myDefaultColorSchemeManager.listNames());
        }
        return (editableCopy = this.getEditableCopy(scheme2)) != null ? editableCopy : scheme2;
    }

    @NotNull
    public SchemeManager<EditorColorsScheme> getSchemeManager() {
        return this.mySchemeManager;
    }

    public static boolean isTempScheme(EditorColorsScheme scheme2) {
        if (scheme2 == null) {
            return false;
        }
        return StringUtil.equals((CharSequence)scheme2.getMetaProperties().getProperty(TEMP_SCHEME_KEY), (CharSequence)Boolean.TRUE.toString());
    }

    @Nullable
    public static Path getTempSchemeOriginalFilePath(EditorColorsScheme scheme2) {
        String path;
        if (EditorColorsManagerImpl.isTempScheme(scheme2) && (path = scheme2.getMetaProperties().getProperty(TEMP_SCHEME_FILE_KEY)) != null) {
            return new File(path).toPath();
        }
        return null;
    }

    public static void setTempScheme(EditorColorsScheme scheme2, @Nullable VirtualFile originalSchemeFile) {
        if (scheme2 == null) {
            return;
        }
        scheme2.getMetaProperties().setProperty(TEMP_SCHEME_KEY, Boolean.TRUE.toString());
        if (originalSchemeFile != null) {
            scheme2.getMetaProperties().setProperty(TEMP_SCHEME_FILE_KEY, originalSchemeFile.getPath());
        }
    }

    static class State {
        public boolean USE_ONLY_MONOSPACED_FONTS = true;
        @OptionTag(tag="global_color_scheme", nameAttribute="", valueAttribute="name")
        public String colorScheme;

        State() {
        }
    }

    static class BundledScheme
    extends EditorColorsSchemeImpl
    implements ReadOnlyColorsScheme {
        BundledScheme() {
            super(null);
        }

        @Override
        public boolean isVisible() {
            return false;
        }
    }
}

