/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.ex.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.PrioritizedDocumentListener;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterClient;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class EmptyEditorHighlighter
implements EditorHighlighter,
PrioritizedDocumentListener {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.editor.ex.util.EmptyEditorHighlighter");
    private TextAttributes myAttributes;
    private int myTextLength = 0;
    private HighlighterClient myEditor;

    public EmptyEditorHighlighter(TextAttributes attributes) {
        this.myAttributes = attributes;
    }

    public void setAttributes(TextAttributes attributes) {
        this.myAttributes = attributes;
    }

    public void setText(@NotNull CharSequence text) {
        this.myTextLength = text.length();
    }

    public void setEditor(@NotNull HighlighterClient editor) {
        LOG.assertTrue(this.myEditor == null, (Object)"Highlighters cannot be reused with different editors");
        this.myEditor = editor;
    }

    public void setColorScheme(@NotNull EditorColorsScheme scheme2) {
        this.setAttributes(scheme2.getAttributes(HighlighterColors.TEXT));
    }

    public void documentChanged(@NotNull DocumentEvent e) {
        this.myTextLength += e.getNewLength() - e.getOldLength();
    }

    @Override
    public int getPriority() {
        return 2;
    }

    @NotNull
    public HighlighterIterator createIterator(int startOffset) {
        return new HighlighterIterator(){
            private int index = 0;

            public TextAttributes getTextAttributes() {
                return EmptyEditorHighlighter.this.myAttributes;
            }

            public int getStart() {
                return 0;
            }

            public int getEnd() {
                return EmptyEditorHighlighter.this.myTextLength;
            }

            public void advance() {
                ++this.index;
            }

            public void retreat() {
                --this.index;
            }

            public boolean atEnd() {
                return this.index != 0;
            }

            public Document getDocument() {
                return EmptyEditorHighlighter.this.myEditor.getDocument();
            }

            public IElementType getTokenType() {
                return IElementType.find((short)1);
            }
        };
    }
}

