/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.highlighter;

import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.fileTypes.EditorHighlighterProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeEditorHighlighterProviders;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.PlainSyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.LanguageSubstitutors;
import com.intellij.testFramework.LightVirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorHighlighterFactoryImpl
extends EditorHighlighterFactory {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.editor.highlighter.EditorHighlighterFactoryImpl");

    @NotNull
    public EditorHighlighter createEditorHighlighter(SyntaxHighlighter highlighter, @NotNull EditorColorsScheme colors) {
        if (highlighter == null) {
            highlighter = new PlainSyntaxHighlighter();
        }
        return new LexerEditorHighlighter(highlighter, colors);
    }

    @NotNull
    public EditorHighlighter createEditorHighlighter(@NotNull FileType fileType, @NotNull EditorColorsScheme settings, Project project) {
        if (fileType instanceof LanguageFileType) {
            return ((EditorHighlighterProvider)FileTypeEditorHighlighterProviders.INSTANCE.forFileType(fileType)).getEditorHighlighter(project, fileType, null, settings);
        }
        SyntaxHighlighter highlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((FileType)fileType, (Project)project, null);
        return this.createEditorHighlighter(highlighter, settings);
    }

    @NotNull
    public EditorHighlighter createEditorHighlighter(Project project, @NotNull FileType fileType) {
        return this.createEditorHighlighter(fileType, EditorColorsManager.getInstance().getGlobalScheme(), project);
    }

    @NotNull
    public EditorHighlighter createEditorHighlighter(@NotNull VirtualFile vFile, @NotNull EditorColorsScheme settings, @Nullable Project project) {
        FileType fileType = vFile.getFileType();
        if (fileType instanceof LanguageFileType) {
            LanguageFileType substFileType = EditorHighlighterFactoryImpl.substituteFileType(((LanguageFileType)fileType).getLanguage(), vFile, project);
            if (substFileType != null) {
                boolean isPlain;
                EditorHighlighterProvider provider = (EditorHighlighterProvider)FileTypeEditorHighlighterProviders.INSTANCE.forFileType((FileType)substFileType);
                EditorHighlighter editorHighlighter = provider.getEditorHighlighter(project, (FileType)substFileType, vFile, settings);
                boolean bl = isPlain = editorHighlighter.getClass() == LexerEditorHighlighter.class && ((LexerEditorHighlighter)editorHighlighter).isPlain();
                if (!isPlain) {
                    return editorHighlighter;
                }
            }
            try {
                return ((EditorHighlighterProvider)FileTypeEditorHighlighterProviders.INSTANCE.forFileType(fileType)).getEditorHighlighter(project, fileType, vFile, settings);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
        SyntaxHighlighter highlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((FileType)fileType, (Project)project, (VirtualFile)vFile);
        return this.createEditorHighlighter(highlighter, settings);
    }

    @Nullable
    private static LanguageFileType substituteFileType(Language language, VirtualFile vFile, Project project) {
        Language substLanguage;
        LanguageFileType fileType = null;
        if (vFile != null && project != null && (substLanguage = LanguageSubstitutors.INSTANCE.substituteLanguage(language, vFile, project)) != language) {
            fileType = substLanguage.getAssociatedFileType();
        }
        return fileType;
    }

    @NotNull
    public EditorHighlighter createEditorHighlighter(Project project, @NotNull VirtualFile file2) {
        return this.createEditorHighlighter(file2, EditorColorsManager.getInstance().getGlobalScheme(), project);
    }

    @NotNull
    public EditorHighlighter createEditorHighlighter(Project project, @NotNull String fileName2) {
        return this.createEditorHighlighter(EditorColorsManager.getInstance().getGlobalScheme(), fileName2, project);
    }

    @NotNull
    public EditorHighlighter createEditorHighlighter(@NotNull EditorColorsScheme settings, @NotNull String fileName2, @Nullable Project project) {
        return this.createEditorHighlighter((VirtualFile)new LightVirtualFile(fileName2), settings, project);
    }
}

