/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.codeInsight.daemon.GutterMark;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.TextAnnotationGutterProvider;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.impl.EditorGutterComponentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.ActiveGutterRenderer;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.JBColor;
import com.intellij.ui.paint.LinePainter2D;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.accessibility.SimpleAccessible;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.accessibility.AccessibleContext;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.LayoutFocusTraversalPolicy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AccessibleGutterLine
extends JPanel {
    private final EditorGutterComponentImpl myGutter;
    private AccessibleGutterElement mySelectedElement;
    private final int myLogicalLineNum;
    private final int myVisualLineNum;
    private static boolean actionHandlerInstalled;

    public static AccessibleGutterLine createAndActivate(@NotNull EditorGutterComponentImpl gutter) {
        return new AccessibleGutterLine(gutter);
    }

    public void escape(boolean requestFocusToEditor) {
        this.myGutter.remove(this);
        this.myGutter.repaint();
        this.myGutter.setCurrentAccessibleLine(null);
        if (requestFocusToEditor) {
            IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myGutter.getEditor().getContentComponent(), true);
        }
    }

    @Override
    public void paint(Graphics g) {
        this.mySelectedElement.paint(g);
    }

    public static void installListeners(final @NotNull EditorGutterComponentImpl gutter) {
        if (!actionHandlerInstalled) {
            actionHandlerInstalled = true;
            EditorActionManager.getInstance().setActionHandler("EditorShowGutterIconTooltip", new EditorActionHandler(){

                protected void doExecute(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext) {
                    AccessibleGutterLine line = ((EditorGutterComponentImpl)editor.getGutter()).getCurrentAccessibleLine();
                    if (line != null) {
                        line.showTooltipIfPresent();
                    }
                }
            });
        }
        gutter.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                gutter.setCurrentAccessibleLine(AccessibleGutterLine.createAndActivate(gutter));
            }
        });
        gutter.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                gutter.escapeCurrentAccessibleLine();
            }
        });
        gutter.getEditor().getCaretModel().addCaretListener(new CaretListener(){

            public void caretPositionChanged(@NotNull CaretEvent event) {
                AccessibleGutterLine line = gutter.getCurrentAccessibleLine();
                if (line != null) {
                    line.maybeLineChanged();
                }
            }
        });
    }

    private void moveRight() {
        IdeFocusManager.getGlobalInstance().requestFocus(this.getFocusTraversalPolicy().getComponentAfter(this, this.mySelectedElement), true);
    }

    private void moveLeft() {
        IdeFocusManager.getGlobalInstance().requestFocus(this.getFocusTraversalPolicy().getComponentBefore(this, this.mySelectedElement), true);
    }

    public void showTooltipIfPresent() {
        this.mySelectedElement.showTooltip();
    }

    private AccessibleGutterLine(@NotNull EditorGutterComponentImpl gutter) {
        super(null);
        List<GutterMark> row2;
        EditorImpl editor = gutter.getEditor();
        int lineHeight = editor.getLineHeight();
        this.myGutter = gutter;
        this.myLogicalLineNum = editor.getCaretModel().getPrimaryCaret().getLogicalPosition().line;
        this.myVisualLineNum = editor.getCaretModel().getPrimaryCaret().getVisualPosition().line;
        if (this.myGutter.isLineNumbersShown()) {
            this.addNewElement(new SimpleAccessible(){

                @NotNull
                public String getAccessibleName() {
                    return "line " + (AccessibleGutterLine.this.myLogicalLineNum + 1);
                }

                public String getAccessibleTooltipText() {
                    return null;
                }
            }, this.myGutter.getLineNumberAreaOffset(), 0, this.myGutter.getLineNumberAreaWidth(), lineHeight);
        }
        if (this.myGutter.isAnnotationsShown()) {
            int x2 = this.myGutter.getAnnotationsAreaOffset();
            int width = 0;
            String tooltipText = null;
            final StringBuilder buf = new StringBuilder("annotation: ");
            for (int i = 0; i < this.myGutter.myTextAnnotationGutters.size(); ++i) {
                TextAnnotationGutterProvider gutterProvider = this.myGutter.myTextAnnotationGutters.get(i);
                if (tooltipText == null) {
                    tooltipText = gutterProvider.getToolTip(this.myLogicalLineNum, (Editor)editor);
                }
                int annotationSize = this.myGutter.myTextAnnotationGutterSizes.get(i);
                buf.append((String)ObjectUtils.notNull((Object)gutterProvider.getLineText(this.myLogicalLineNum, (Editor)editor), (Object)""));
                width += annotationSize;
            }
            if (buf.length() > 0) {
                final String tt = tooltipText;
                this.addNewElement(new SimpleAccessible(){

                    @NotNull
                    public String getAccessibleName() {
                        return buf.toString();
                    }

                    public String getAccessibleTooltipText() {
                        return tt;
                    }
                }, x2, 0, width, lineHeight);
            }
        }
        if (this.myGutter.areIconsShown() && (row2 = this.myGutter.getGutterRenderers(this.myVisualLineNum)) != null) {
            this.myGutter.processIconsRow(this.myVisualLineNum, row2, (x, y, renderer2) -> {
                Icon icon = this.myGutter.scaleIcon(renderer2.getIcon());
                this.addNewElement(new SimpleAccessible(){

                    @NotNull
                    public String getAccessibleName() {
                        if (renderer2 instanceof SimpleAccessible) {
                            return ((SimpleAccessible)renderer2).getAccessibleName();
                        }
                        return "icon: " + renderer2.getClass().getSimpleName();
                    }

                    public String getAccessibleTooltipText() {
                        return renderer2.getTooltipText();
                    }
                }, x, 0, icon.getIconWidth(), lineHeight);
            });
        }
        if (this.myGutter.isLineMarkersShown()) {
            int firstVisibleOffset = editor.visualLineStartOffset(this.myVisualLineNum);
            int lastVisibleOffset = editor.visualLineStartOffset(this.myVisualLineNum + 1);
            this.myGutter.processRangeHighlighters(firstVisibleOffset, lastVisibleOffset, highlighter -> {
                Rectangle bounds2;
                Rectangle rect;
                LineMarkerRenderer renderer2 = highlighter.getLineMarkerRenderer();
                if (renderer2 instanceof ActiveGutterRenderer && (rect = this.myGutter.getLineRendererRectangle(highlighter)) != null && (bounds2 = ((ActiveGutterRenderer)renderer2).calcBounds((Editor)editor, this.myVisualLineNum, rect)) != null) {
                    this.addNewElement((SimpleAccessible)((ActiveGutterRenderer)renderer2), bounds2.x, 0, bounds2.width, bounds2.height);
                }
            });
        }
        this.setOpaque(false);
        this.setFocusable(false);
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicyProvider(true);
        this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
        this.setBounds(0, editor.visualLineToY(this.myVisualLineNum), this.myGutter.getWhitespaceSeparatorOffset(), lineHeight);
        this.myGutter.add(this);
        this.mySelectedElement = (AccessibleGutterElement)this.getFocusTraversalPolicy().getFirstComponent(this);
        if (this.mySelectedElement == null) {
            Rectangle b = this.getBounds();
            this.mySelectedElement = this.addNewElement(new SimpleAccessible(){

                @NotNull
                public String getAccessibleName() {
                    return "empty";
                }

                public String getAccessibleTooltipText() {
                    return null;
                }
            }, 0, 0, b.width, b.height);
        }
        this.installActionHandler(CommonShortcuts.ESCAPE, () -> this.escape(true));
        this.installActionHandler(CommonShortcuts.ENTER, () -> {});
        this.installActionHandler((ShortcutSet)MyShortcuts.MOVE_RIGHT, this::moveRight);
        this.installActionHandler((ShortcutSet)MyShortcuts.MOVE_LEFT, this::moveLeft);
        IdeFocusManager.getGlobalInstance().requestFocus((Component)this.mySelectedElement, true);
    }

    private void installActionHandler(ShortcutSet shortcut, Runnable action) {
        DumbAwareAction.create(e -> action.run()).registerCustomShortcutSet(shortcut, (JComponent)this);
    }

    @NotNull
    private AccessibleGutterElement addNewElement(@NotNull SimpleAccessible accessible, int x, int y, int width, int height) {
        AccessibleGutterElement obj = new AccessibleGutterElement(accessible, new Rectangle(x, y, width, height));
        this.add(obj);
        return obj;
    }

    @Override
    public void removeNotify() {
        this.repaint();
        super.removeNotify();
    }

    private void maybeLineChanged() {
        if (this.myLogicalLineNum == this.myGutter.getEditor().getCaretModel().getPrimaryCaret().getLogicalPosition().line) {
            return;
        }
        this.myGutter.remove(this);
        this.myGutter.setCurrentAccessibleLine(AccessibleGutterLine.createAndActivate(this.myGutter));
    }

    @Override
    public void repaint() {
        if (this.myGutter == null) {
            return;
        }
        int y = this.myGutter.getEditor().visualLineToY(this.myVisualLineNum);
        this.myGutter.repaint(0, y, this.myGutter.getWhitespaceSeparatorOffset(), y + this.myGutter.getEditor().getLineHeight());
    }

    private boolean isActive() {
        return this == this.myGutter.getCurrentAccessibleLine();
    }

    public static boolean isAccessibleGutterElement(Object element) {
        return element instanceof SimpleAccessible;
    }

    private class AccessibleGutterElement
    extends JLabel {
        @NotNull
        private final SimpleAccessible myAccessible;

        AccessibleGutterElement(@NotNull SimpleAccessible accessible, Rectangle bounds2) {
            this.myAccessible = accessible;
            this.setFocusable(true);
            this.setBounds(bounds2.x, bounds2.y, bounds2.width, AccessibleGutterLine.this.myGutter.getEditor().getLineHeight());
            this.setOpaque(false);
            this.setText(this.myAccessible.getAccessibleName());
            this.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    AccessibleGutterLine.this.mySelectedElement = AccessibleGutterElement.this;
                    AccessibleGutterElement.this.getParent().repaint();
                }

                @Override
                public void focusLost(FocusEvent e) {
                    if (!(e.getOppositeComponent() instanceof AccessibleGutterElement) && AccessibleGutterLine.this.isActive()) {
                        AccessibleGutterLine.this.escape(false);
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paint(Graphics g) {
            if (AccessibleGutterLine.this.mySelectedElement != this) {
                return;
            }
            Color oldColor = g.getColor();
            try {
                g.setColor((Color)JBColor.blue);
                Point parentLoc = this.getParent().getLocation();
                Rectangle bounds2 = this.getBounds();
                bounds2.setLocation(parentLoc.x + bounds2.x, parentLoc.y + bounds2.y);
                int y = bounds2.y + bounds2.height - JBUI.scale((int)1);
                LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)bounds2.x, (double)y, (double)(bounds2.x + bounds2.width), (double)y, (LinePainter2D.StrokeType)LinePainter2D.StrokeType.INSIDE, (double)JBUI.scale((int)1));
            }
            finally {
                g.setColor(oldColor);
            }
        }

        public void showTooltip() {
            if (this.myAccessible.getAccessibleTooltipText() != null) {
                Rectangle bounds2 = this.getBounds();
                Rectangle pBounds = this.getParent().getBounds();
                int x = pBounds.x + bounds2.x + bounds2.width / 2;
                int y = pBounds.y + bounds2.y + bounds2.height / 2;
                MouseEvent e = new MouseEvent(AccessibleGutterLine.this.myGutter, 503, System.currentTimeMillis(), 0, x, y, 0, false, 1);
                AccessibleGutterLine.this.myGutter.tooltipAvailable(this.myAccessible.getAccessibleTooltipText(), e, null);
            }
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new JLabel.AccessibleJLabel(){

                    @Override
                    public String getAccessibleName() {
                        return AccessibleGutterElement.this.getText();
                    }
                };
            }
            return this.accessibleContext;
        }
    }

    private static class MyShortcuts {
        static final CustomShortcutSet MOVE_RIGHT = new CustomShortcutSet(new Shortcut[]{new KeyboardShortcut(KeyStroke.getKeyStroke(39, 0), null), new KeyboardShortcut(KeyStroke.getKeyStroke(9, 0), null)});
        static final CustomShortcutSet MOVE_LEFT = new CustomShortcutSet(new Shortcut[]{new KeyboardShortcut(KeyStroke.getKeyStroke(37, 0), null), new KeyboardShortcut(KeyStroke.getKeyStroke(9, 64), null)});

        private MyShortcuts() {
        }
    }
}

