/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.InlayImpl;
import com.intellij.openapi.editor.impl.RangeMarkerTree;
import com.intellij.util.DocumentUtil;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AfterLineEndInlayImpl<R extends EditorCustomElementRenderer>
extends InlayImpl<R, AfterLineEndInlayImpl> {
    private static int ourGlobalCounter = 0;
    final int myOrder = ourGlobalCounter++;

    AfterLineEndInlayImpl(@NotNull EditorImpl editor, int offset, boolean relatesToPrecedingText, @NotNull R renderer2) {
        super(editor, offset, relatesToPrecedingText, renderer2);
    }

    @Override
    RangeMarkerTree<AfterLineEndInlayImpl> getTree() {
        return this.myEditor.getInlayModel().myAfterLineEndElementsTree;
    }

    @Override
    void doUpdateSize() {
        this.myWidthInPixels = this.myRenderer.calcWidthInPixels((Inlay)this);
        if (this.myWidthInPixels <= 0) {
            throw new IllegalArgumentException("Positive width should be defined for an after-line-end element");
        }
    }

    @Override
    Point getPosition() {
        VisualPosition pos = this.getVisualPosition();
        return this.myEditor.visualPositionToXY(pos);
    }

    @Override
    @Nullable
    public Rectangle getBounds() {
        int targetOffset = DocumentUtil.getLineEndOffset(this.getOffset(), this.myEditor.getDocument());
        if (this.myEditor.getFoldingModel().isOffsetCollapsed(targetOffset)) {
            return null;
        }
        Point pos = this.getPosition();
        return new Rectangle(pos.x, pos.y, this.getWidthInPixels(), this.getHeightInPixels());
    }

    @NotNull
    public Inlay.Placement getPlacement() {
        return Inlay.Placement.AFTER_LINE_END;
    }

    @NotNull
    public VisualPosition getVisualPosition() {
        int offset = this.getOffset();
        int logicalLine = this.myEditor.getDocument().getLineNumber(offset);
        int lineEndOffset = this.myEditor.getDocument().getLineEndOffset(logicalLine);
        VisualPosition position = this.myEditor.offsetToVisualPosition(lineEndOffset, true, true);
        if (this.myEditor.getFoldingModel().isOffsetCollapsed(lineEndOffset)) {
            return position;
        }
        List<Inlay> inlays = this.myEditor.getInlayModel().getAfterLineEndElementsForLogicalLine(logicalLine);
        int order = inlays.indexOf(this);
        return new VisualPosition(position.line, position.column + 1 + order);
    }

    public int getHeightInPixels() {
        return this.myEditor.getLineHeight();
    }
}

