/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.InlayImpl;
import com.intellij.openapi.editor.impl.MarkerTreeWithPartialSums;
import java.awt.Point;
import java.util.List;
import java.util.function.IntSupplier;
import org.jetbrains.annotations.NotNull;

class BlockInlayImpl<R extends EditorCustomElementRenderer>
extends InlayImpl<R, BlockInlayImpl>
implements IntSupplier {
    final boolean myShowAbove;
    final int myPriority;
    private int myHeightInPixels;

    BlockInlayImpl(@NotNull EditorImpl editor, int offset, boolean relatesToPrecedingText, boolean showAbove, int priority, @NotNull R renderer2) {
        super(editor, offset, relatesToPrecedingText, renderer2);
        this.myShowAbove = showAbove;
        this.myPriority = priority;
    }

    @Override
    MarkerTreeWithPartialSums<BlockInlayImpl> getTree() {
        return this.myEditor.getInlayModel().myBlockElementsTree;
    }

    @Override
    void doUpdateSize() {
        this.myWidthInPixels = this.myRenderer.calcWidthInPixels((Inlay)this);
        if (this.myWidthInPixels < 0) {
            throw new IllegalArgumentException("Non-negative width should be defined for a block element");
        }
        int oldHeightInPixels = this.myHeightInPixels;
        this.myHeightInPixels = this.myRenderer.calcHeightInPixels((Inlay)this);
        if (oldHeightInPixels != this.myHeightInPixels) {
            ((MarkerTreeWithPartialSums)this.getTree()).valueUpdated(this);
        }
        if (this.myHeightInPixels < 0) {
            throw new IllegalArgumentException("Non-negative height should be defined for a block element");
        }
    }

    @Override
    Point getPosition() {
        int visualLine = this.myEditor.offsetToVisualLine(this.getOffset());
        int y = this.myEditor.visualLineToY(visualLine);
        List<Inlay> allInlays = this.myEditor.getInlayModel().getBlockElementsForVisualLine(visualLine, this.myShowAbove);
        if (this.myShowAbove) {
            boolean found = false;
            for (Inlay inlay : allInlays) {
                if (inlay == this) {
                    found = true;
                }
                if (!found) continue;
                y -= inlay.getHeightInPixels();
            }
        } else {
            y += this.myEditor.getLineHeight();
            for (Inlay inlay : allInlays) {
                if (inlay == this) break;
                y += inlay.getHeightInPixels();
            }
        }
        return new Point(0, y);
    }

    public int getHeightInPixels() {
        return this.myHeightInPixels;
    }

    @NotNull
    public Inlay.Placement getPlacement() {
        return this.myShowAbove ? Inlay.Placement.ABOVE_LINE : Inlay.Placement.BELOW_LINE;
    }

    @NotNull
    public VisualPosition getVisualPosition() {
        return this.myEditor.offsetToVisualPosition(this.getOffset());
    }

    @Override
    public int getAsInt() {
        return this.myHeightInPixels;
    }
}

