/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.diagnostic.Dumpable;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretAction;
import com.intellij.openapi.editor.CaretActionListener;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.CaretState;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.ex.PrioritizedDocumentListener;
import com.intellij.openapi.editor.impl.CaretImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.InlineInlayImpl;
import com.intellij.openapi.editor.impl.RangeMarkerTree;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyClipboardOwner;
import gnu.trove.TIntArrayList;
import java.awt.GraphicsEnvironment;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CaretModelImpl
implements CaretModel,
PrioritizedDocumentListener,
Disposable,
Dumpable,
InlayModel.Listener {
    private final EditorImpl myEditor;
    private final EventDispatcher<CaretListener> myCaretListeners = EventDispatcher.create(CaretListener.class);
    private final EventDispatcher<CaretActionListener> myCaretActionListeners = EventDispatcher.create(CaretActionListener.class);
    private TextAttributes myTextAttributes;
    boolean myIsInUpdate;
    final RangeMarkerTree<CaretImpl.PositionMarker> myPositionMarkerTree;
    final RangeMarkerTree<CaretImpl.SelectionMarker> mySelectionMarkerTree;
    private final LinkedList<CaretImpl> myCarets = new LinkedList();
    @NotNull
    private volatile CaretImpl myPrimaryCaret;
    private CaretImpl myCurrentCaret;
    private boolean myPerformCaretMergingAfterCurrentOperation;
    private boolean myVisualPositionUpdateScheduled;
    int myDocumentUpdateCounter;
    private static final Comparator<VisualPosition> VISUAL_POSITION_COMPARATOR = (o1, o2) -> {
        if (o1.line != o2.line) {
            return o1.line - o2.line;
        }
        return o1.column - o2.column;
    };
    private static final Comparator<Caret> CARET_POSITION_COMPARATOR = (o1, o2) -> VISUAL_POSITION_COMPARATOR.compare(o1.getVisualPosition(), o2.getVisualPosition());

    public CaretModelImpl(@NotNull EditorImpl editor) {
        this.myEditor = editor;
        this.myEditor.addPropertyChangeListener(evt -> {
            if ("columnMode".equals(evt.getPropertyName()) && !this.myEditor.isColumnMode()) {
                for (CaretImpl caret : this.myCarets) {
                    caret.resetVirtualSelection();
                }
            }
        }, this);
        this.myPositionMarkerTree = new RangeMarkerTree(this.myEditor.getDocument());
        this.mySelectionMarkerTree = new RangeMarkerTree(this.myEditor.getDocument());
        this.myPrimaryCaret = new CaretImpl(this.myEditor, this);
        this.myCarets.add(this.myPrimaryCaret);
    }

    void onBulkDocumentUpdateStarted() {
    }

    void onBulkDocumentUpdateFinished() {
        this.doWithCaretMerging(() -> {});
    }

    public void documentChanged(@NotNull DocumentEvent e) {
        this.myIsInUpdate = false;
        ++this.myDocumentUpdateCounter;
        if (!this.myEditor.getDocument().isInBulkUpdate()) {
            this.doWithCaretMerging(() -> {});
            if (this.myVisualPositionUpdateScheduled) {
                this.updateVisualPosition();
            }
        }
    }

    public void beforeDocumentChange(@NotNull DocumentEvent e) {
        if (!this.myEditor.getDocument().isInBulkUpdate() && e.isWholeTextReplaced()) {
            for (CaretImpl caret : this.myCarets) {
                caret.updateCachedStateIfNeeded();
            }
        }
        this.myIsInUpdate = true;
        this.myVisualPositionUpdateScheduled = false;
    }

    @Override
    public int getPriority() {
        return 120;
    }

    public void dispose() {
        for (CaretImpl caret : this.myCarets) {
            Disposer.dispose((Disposable)caret);
        }
        this.mySelectionMarkerTree.dispose(this.myEditor.getDocument());
        this.myPositionMarkerTree.dispose(this.myEditor.getDocument());
    }

    public void updateVisualPosition() {
        for (CaretImpl caret : this.myCarets) {
            caret.updateVisualPosition();
        }
    }

    public void moveCaretRelatively(int columnShift, int lineShift, boolean withSelection, boolean blockSelection, boolean scrollToCaret) {
        this.getCurrentCaret().moveCaretRelatively(columnShift, lineShift, withSelection, scrollToCaret);
    }

    public void moveToLogicalPosition(@NotNull LogicalPosition pos) {
        this.getCurrentCaret().moveToLogicalPosition(pos);
    }

    public void moveToVisualPosition(@NotNull VisualPosition pos) {
        this.getCurrentCaret().moveToVisualPosition(pos);
    }

    public void moveToOffset(int offset) {
        this.getCurrentCaret().moveToOffset(offset);
    }

    public void moveToOffset(int offset, boolean locateBeforeSoftWrap) {
        this.getCurrentCaret().moveToOffset(offset, locateBeforeSoftWrap);
    }

    public boolean isUpToDate() {
        return this.getCurrentCaret().isUpToDate();
    }

    @NotNull
    public LogicalPosition getLogicalPosition() {
        return this.getCurrentCaret().getLogicalPosition();
    }

    @NotNull
    public VisualPosition getVisualPosition() {
        return this.getCurrentCaret().getVisualPosition();
    }

    public int getOffset() {
        return this.getCurrentCaret().getOffset();
    }

    public int getVisualLineStart() {
        return this.getCurrentCaret().getVisualLineStart();
    }

    public int getVisualLineEnd() {
        return this.getCurrentCaret().getVisualLineEnd();
    }

    int getWordAtCaretStart() {
        return this.getCurrentCaret().getWordAtCaretStart();
    }

    int getWordAtCaretEnd() {
        return this.getCurrentCaret().getWordAtCaretEnd();
    }

    public void addCaretListener(@NotNull CaretListener listener2) {
        this.myCaretListeners.addListener((EventListener)listener2);
    }

    public void removeCaretListener(@NotNull CaretListener listener2) {
        this.myCaretListeners.removeListener((EventListener)listener2);
    }

    @NotNull
    public TextAttributes getTextAttributes() {
        TextAttributes textAttributes = this.myTextAttributes;
        if (textAttributes == null) {
            this.myTextAttributes = textAttributes = new TextAttributes();
            if (this.myEditor.getSettings().isCaretRowShown()) {
                textAttributes.setBackgroundColor(this.myEditor.getColorsScheme().getColor(EditorColors.CARET_ROW_COLOR));
            }
        }
        return textAttributes;
    }

    public void reinitSettings() {
        this.myTextAttributes = null;
    }

    public boolean supportsMultipleCarets() {
        return true;
    }

    @NotNull
    public CaretImpl getCurrentCaret() {
        CaretImpl currentCaret = this.myCurrentCaret;
        return ApplicationManager.getApplication().isDispatchThread() && currentCaret != null ? currentCaret : this.getPrimaryCaret();
    }

    @NotNull
    public CaretImpl getPrimaryCaret() {
        return this.myPrimaryCaret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCaretCount() {
        LinkedList<CaretImpl> linkedList = this.myCarets;
        synchronized (linkedList) {
            return this.myCarets.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<Caret> getAllCarets() {
        ArrayList<Caret> carets;
        LinkedList<CaretImpl> linkedList = this.myCarets;
        synchronized (linkedList) {
            carets = new ArrayList<Caret>(this.myCarets);
        }
        Collections.sort(carets, CARET_POSITION_COMPARATOR);
        return carets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Caret getCaretAt(@NotNull VisualPosition pos) {
        LinkedList<CaretImpl> linkedList = this.myCarets;
        synchronized (linkedList) {
            for (CaretImpl caret : this.myCarets) {
                if (!caret.getVisualPosition().equals((Object)pos)) continue;
                return caret;
            }
            return null;
        }
    }

    @Nullable
    public Caret addCaret(@NotNull VisualPosition pos) {
        return this.addCaret(pos, true);
    }

    @Nullable
    public Caret addCaret(@NotNull VisualPosition pos, boolean makePrimary) {
        EditorImpl.assertIsDispatchThread();
        CaretImpl caret = new CaretImpl(this.myEditor, this);
        caret.doMoveToVisualPosition(pos, false);
        if (this.addCaret(caret, makePrimary)) {
            return caret;
        }
        Disposer.dispose((Disposable)caret);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean addCaret(@NotNull CaretImpl caretToAdd, boolean makePrimary) {
        EditorImpl.assertIsDispatchThread();
        for (CaretImpl caret : this.myCarets) {
            if (!CaretModelImpl.caretsOverlap(caret, caretToAdd)) continue;
            return false;
        }
        LinkedList<CaretImpl> linkedList = this.myCarets;
        synchronized (linkedList) {
            if (makePrimary) {
                this.myCarets.addLast(caretToAdd);
                this.myPrimaryCaret = caretToAdd;
            } else {
                this.myCarets.addFirst(caretToAdd);
            }
        }
        this.fireCaretAdded(caretToAdd);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeCaret(@NotNull Caret caret) {
        EditorImpl.assertIsDispatchThread();
        if (this.myCarets.size() <= 1 || !(caret instanceof CaretImpl)) {
            return false;
        }
        LinkedList<CaretImpl> linkedList = this.myCarets;
        synchronized (linkedList) {
            if (!this.myCarets.remove(caret)) {
                return false;
            }
            this.myPrimaryCaret = this.myCarets.getLast();
        }
        this.fireCaretRemoved(caret);
        Disposer.dispose((Disposable)caret);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSecondaryCarets() {
        EditorImpl.assertIsDispatchThread();
        ListIterator<CaretImpl> caretIterator = this.myCarets.listIterator(this.myCarets.size() - 1);
        while (caretIterator.hasPrevious()) {
            CaretImpl caret = caretIterator.previous();
            LinkedList<CaretImpl> linkedList = this.myCarets;
            synchronized (linkedList) {
                caretIterator.remove();
            }
            this.fireCaretRemoved(caret);
            Disposer.dispose((Disposable)caret);
        }
    }

    public void runForEachCaret(@NotNull CaretAction action) {
        this.runForEachCaret(action, false);
    }

    public void runForEachCaret(@NotNull CaretAction action, boolean reverseOrder) {
        EditorImpl.assertIsDispatchThread();
        if (this.myCurrentCaret != null) {
            throw new IllegalStateException("Recursive runForEachCaret invocations are not allowed");
        }
        ((CaretActionListener)this.myCaretActionListeners.getMulticaster()).beforeAllCaretsAction();
        this.doWithCaretMerging(() -> {
            try {
                List<Caret> sortedCarets = this.getAllCarets();
                if (reverseOrder) {
                    Collections.reverse(sortedCarets);
                }
                for (Caret caret : sortedCarets) {
                    this.myCurrentCaret = (CaretImpl)caret;
                    action.perform(caret);
                }
            }
            finally {
                this.myCurrentCaret = null;
            }
        });
        ((CaretActionListener)this.myCaretActionListeners.getMulticaster()).afterAllCaretsAction();
    }

    public void addCaretActionListener(@NotNull CaretActionListener listener2, @NotNull Disposable disposable) {
        this.myCaretActionListeners.addListener((EventListener)listener2, disposable);
    }

    public void runBatchCaretOperation(@NotNull Runnable runnable2) {
        EditorImpl.assertIsDispatchThread();
        this.doWithCaretMerging(runnable2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeOverlappingCaretsAndSelections() {
        EditorImpl.assertIsDispatchThread();
        if (this.myCarets.size() <= 1) {
            return;
        }
        LinkedList<CaretImpl> carets = new LinkedList<CaretImpl>(this.myCarets);
        Collections.sort(carets, CARET_POSITION_COMPARATOR);
        ListIterator it = carets.listIterator();
        CaretImpl keepPrimary = this.getPrimaryCaret();
        while (it.hasNext()) {
            CaretImpl toRemove2;
            CaretImpl toRetain;
            CaretImpl prevCaret = null;
            if (it.hasPrevious()) {
                prevCaret = (CaretImpl)((Object)it.previous());
                it.next();
            }
            CaretImpl currCaret = (CaretImpl)((Object)it.next());
            if (prevCaret == null || !CaretModelImpl.caretsOverlap(currCaret, prevCaret)) continue;
            int newSelectionStart = Math.min(currCaret.getSelectionStart(), prevCaret.getSelectionStart());
            int newSelectionEnd = Math.max(currCaret.getSelectionEnd(), prevCaret.getSelectionEnd());
            if (currCaret.getOffset() >= prevCaret.getSelectionStart() && currCaret.getOffset() <= prevCaret.getSelectionEnd()) {
                toRetain = prevCaret;
                toRemove2 = currCaret;
                it.remove();
                it.previous();
            } else {
                toRetain = currCaret;
                toRemove2 = prevCaret;
                it.previous();
                it.previous();
                it.remove();
            }
            if (toRemove2 == keepPrimary) {
                keepPrimary = toRetain;
            }
            this.removeCaret(toRemove2);
            if (newSelectionStart >= newSelectionEnd) continue;
            toRetain.setSelection(newSelectionStart, newSelectionEnd);
        }
        if (keepPrimary != this.getPrimaryCaret()) {
            LinkedList<CaretImpl> linkedList = this.myCarets;
            synchronized (linkedList) {
                this.myCarets.remove((Object)keepPrimary);
                this.myCarets.add(keepPrimary);
                this.myPrimaryCaret = keepPrimary;
            }
        }
    }

    private static boolean caretsOverlap(@NotNull CaretImpl firstCaret, @NotNull CaretImpl secondCaret) {
        if (firstCaret.getVisualPosition().equals((Object)secondCaret.getVisualPosition())) {
            return true;
        }
        int firstStart = firstCaret.getSelectionStart();
        int secondStart = secondCaret.getSelectionStart();
        int firstEnd = firstCaret.getSelectionEnd();
        int secondEnd = secondCaret.getSelectionEnd();
        return firstStart < secondStart && firstEnd > secondStart || firstStart > secondStart && firstStart < secondEnd || firstStart == secondStart && secondEnd != secondStart && firstEnd > firstStart || (CaretModelImpl.hasPureVirtualSelection(firstCaret) || CaretModelImpl.hasPureVirtualSelection(secondCaret)) && (firstStart == secondStart || firstEnd == secondEnd);
    }

    private static boolean hasPureVirtualSelection(@NotNull CaretImpl firstCaret) {
        return firstCaret.getSelectionStart() == firstCaret.getSelectionEnd() && firstCaret.hasVirtualSelection();
    }

    void doWithCaretMerging(@NotNull Runnable runnable2) {
        EditorImpl.assertIsDispatchThread();
        if (this.myPerformCaretMergingAfterCurrentOperation) {
            runnable2.run();
        } else {
            this.myPerformCaretMergingAfterCurrentOperation = true;
            try {
                runnable2.run();
                this.mergeOverlappingCaretsAndSelections();
            }
            finally {
                this.myPerformCaretMergingAfterCurrentOperation = false;
            }
        }
    }

    public void setCaretsAndSelections(@NotNull List<CaretState> caretStates) {
        this.setCaretsAndSelections(caretStates, true);
    }

    public void setCaretsAndSelections(@NotNull List<CaretState> caretStates, boolean updateSystemSelection) {
        EditorImpl.assertIsDispatchThread();
        if (caretStates.isEmpty()) {
            throw new IllegalArgumentException("At least one caret should exist");
        }
        this.doWithCaretMerging(() -> {
            CaretImpl caret;
            int index = 0;
            int oldCaretCount = this.myCarets.size();
            Iterator caretIterator = this.myCarets.iterator();
            TIntArrayList selectionStartsBefore = null;
            TIntArrayList selectionStartsAfter = null;
            TIntArrayList selectionEndsBefore = null;
            TIntArrayList selectionEndsAfter = null;
            for (CaretState caretState : caretStates) {
                if (index++ < oldCaretCount) {
                    caret = (CaretImpl)((Object)((Object)caretIterator.next()));
                    if (caretState != null && caretState.getCaretPosition() != null) {
                        caret.moveToLogicalPosition(caretState.getCaretPosition());
                    }
                } else {
                    caret = new CaretImpl(this.myEditor, this);
                    if (caretState != null && caretState.getCaretPosition() != null) {
                        caret.moveToLogicalPosition(caretState.getCaretPosition(), false, null, false, false);
                    }
                    LinkedList<CaretImpl> linkedList = this.myCarets;
                    synchronized (linkedList) {
                        this.myCarets.add(caret);
                        this.myPrimaryCaret = caret;
                    }
                    this.fireCaretAdded(caret);
                }
                if (caretState != null && caretState.getCaretPosition() != null && caretState.getVisualColumnAdjustment() != 0) {
                    caret.myVisualColumnAdjustment = caretState.getVisualColumnAdjustment();
                    caret.updateVisualPosition();
                }
                if (caretState == null || caretState.getSelectionStart() == null || caretState.getSelectionEnd() == null) continue;
                if (selectionStartsBefore == null) {
                    int capacity = caretStates.size();
                    selectionStartsBefore = new TIntArrayList(capacity);
                    selectionStartsAfter = new TIntArrayList(capacity);
                    selectionEndsBefore = new TIntArrayList(capacity);
                    selectionEndsAfter = new TIntArrayList(capacity);
                }
                selectionStartsBefore.add(caret.getSelectionStart());
                selectionEndsBefore.add(caret.getSelectionEnd());
                caret.doSetSelection(this.myEditor.logicalToVisualPosition(caretState.getSelectionStart()), this.myEditor.logicalPositionToOffset(caretState.getSelectionStart()), this.myEditor.logicalToVisualPosition(caretState.getSelectionEnd()), this.myEditor.logicalPositionToOffset(caretState.getSelectionEnd()), true, false, false);
                selectionStartsAfter.add(caret.getSelectionStart());
                selectionEndsAfter.add(caret.getSelectionEnd());
            }
            int caretsToRemove = this.myCarets.size() - caretStates.size();
            for (int i = 0; i < caretsToRemove; ++i) {
                LinkedList<CaretImpl> linkedList = this.myCarets;
                synchronized (linkedList) {
                    caret = this.myCarets.removeLast();
                    this.myPrimaryCaret = this.myCarets.getLast();
                }
                this.fireCaretRemoved(caret);
                Disposer.dispose((Disposable)caret);
            }
            if (updateSystemSelection) {
                this.updateSystemSelection();
            }
            if (selectionStartsBefore != null) {
                SelectionEvent event = new SelectionEvent((Editor)this.myEditor, selectionStartsBefore.toNativeArray(), selectionEndsBefore.toNativeArray(), selectionStartsAfter.toNativeArray(), selectionEndsAfter.toNativeArray());
                this.myEditor.getSelectionModel().fireSelectionChanged(event);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<CaretState> getCaretsAndSelections() {
        LinkedList<CaretImpl> linkedList = this.myCarets;
        synchronized (linkedList) {
            ArrayList<CaretState> states = new ArrayList<CaretState>(this.myCarets.size());
            for (CaretImpl caret : this.myCarets) {
                states.add(new CaretState(caret.getLogicalPosition(), caret.myVisualColumnAdjustment, caret.getSelectionStartLogicalPosition(), caret.getSelectionEndLogicalPosition()));
            }
            return states;
        }
    }

    void updateSystemSelection() {
        if (GraphicsEnvironment.isHeadless()) {
            return;
        }
        Clipboard clip = this.myEditor.getComponent().getToolkit().getSystemSelection();
        if (clip != null) {
            clip.setContents(new StringSelection(this.myEditor.getSelectionModel().getSelectedText(true)), (ClipboardOwner)EmptyClipboardOwner.INSTANCE);
        }
    }

    void fireCaretPositionChanged(@NotNull CaretEvent caretEvent) {
        ((CaretListener)this.myCaretListeners.getMulticaster()).caretPositionChanged(caretEvent);
    }

    private void fireCaretAdded(@NotNull Caret caret) {
        ((CaretListener)this.myCaretListeners.getMulticaster()).caretAdded(new CaretEvent(caret, caret.getLogicalPosition(), caret.getLogicalPosition()));
    }

    private void fireCaretRemoved(@NotNull Caret caret) {
        ((CaretListener)this.myCaretListeners.getMulticaster()).caretRemoved(new CaretEvent(caret, caret.getLogicalPosition(), caret.getLogicalPosition()));
    }

    public boolean isIteratingOverCarets() {
        return this.myCurrentCaret != null;
    }

    @NotNull
    public String dumpState() {
        return "[in update: " + this.myIsInUpdate + ", update counter: " + this.myDocumentUpdateCounter + ", perform caret merging: " + this.myPerformCaretMergingAfterCurrentOperation + ", current caret: " + (Object)((Object)this.myCurrentCaret) + ", all carets: " + ContainerUtil.map(this.myCarets, CaretImpl::dumpState) + "]";
    }

    public void onAdded(@NotNull Inlay inlay) {
        if (this.myEditor.getDocument().isInBulkUpdate()) {
            return;
        }
        Inlay.Placement placement = inlay.getPlacement();
        if (placement == Inlay.Placement.INLINE) {
            int offset = inlay.getOffset();
            for (CaretImpl caret : this.myCarets) {
                caret.onInlayAdded(offset);
            }
        } else if (placement != Inlay.Placement.AFTER_LINE_END || this.hasCaretInVirtualSpace()) {
            this.updateVisualPosition();
        }
    }

    public void onRemoved(@NotNull Inlay inlay) {
        if (this.myEditor.getDocument().isInBulkUpdate()) {
            return;
        }
        Inlay.Placement placement = inlay.getPlacement();
        if (this.myEditor.getDocument().isInEventsHandling()) {
            if (placement == Inlay.Placement.AFTER_LINE_END) {
                this.myVisualPositionUpdateScheduled = true;
            }
            return;
        }
        if (placement == Inlay.Placement.INLINE) {
            this.doWithCaretMerging(() -> {
                for (CaretImpl caret : this.myCarets) {
                    caret.onInlayRemoved(inlay.getOffset(), ((InlineInlayImpl)inlay).getOrder());
                }
            });
        } else if (placement != Inlay.Placement.AFTER_LINE_END || this.hasCaretInVirtualSpace()) {
            this.updateVisualPosition();
        }
    }

    public void onUpdated(@NotNull Inlay inlay) {
        if (this.myEditor.getDocument().isInBulkUpdate()) {
            return;
        }
        if (inlay.getPlacement() != Inlay.Placement.AFTER_LINE_END || this.hasCaretInVirtualSpace()) {
            this.updateVisualPosition();
        }
    }

    private boolean hasCaretInVirtualSpace() {
        return this.myEditor.getSettings().isVirtualSpace() && ContainerUtil.exists(this.myCarets, CaretImpl::isInVirtualSpace);
    }

    public void validateState() {
        for (CaretImpl caret : this.myCarets) {
            caret.validateState();
        }
    }
}

