/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.keymap.ex.KeymapManagerEx;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.UIUtil;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContextMenuImpl
extends JPanel
implements Disposable {
    @NonNls
    public static final String ACTION_GROUP = "EditorContextBarMenu";
    private final JComponent myComponent;
    private final JLayeredPane myLayeredPane;
    private ActionGroup myActionGroup;
    private boolean myVisible = false;
    private boolean myShow = false;
    private int myCurrentOpacity;
    private Timer myTimer;
    private EditorImpl myEditor;
    private boolean myDisposed;
    private ActionToolbar myActionToolbar;

    public ContextMenuImpl(JLayeredPane layeredPane, final @NotNull JScrollPane container, @NotNull EditorImpl editor) {
        this.setLayout(new BorderLayout(0, 0));
        this.myEditor = editor;
        this.myLayeredPane = layeredPane;
        ActionManager actionManager = ActionManager.getInstance();
        editor.addEditorMouseListener(new EditorMouseListener(){

            public void mouseExited(@NotNull EditorMouseEvent e) {
                if (!ContextMenuImpl.isInsideActivationArea(container, e.getMouseEvent().getPoint())) {
                    ContextMenuImpl.this.toggleContextToolbar(false);
                }
            }
        });
        editor.addEditorMouseMotionListener(new EditorMouseMotionListener(){

            public void mouseMoved(@NotNull EditorMouseEvent e) {
                ContextMenuImpl.this.toggleContextToolbar(ContextMenuImpl.isInsideActivationArea(container, e.getMouseEvent().getPoint()));
            }
        });
        AnAction action = actionManager.getAction(ACTION_GROUP);
        if (action == null) {
            action = new DefaultActionGroup();
            actionManager.registerAction(ACTION_GROUP, action);
        }
        if (action instanceof ActionGroup) {
            this.myActionGroup = (ActionGroup)action;
        }
        this.myComponent = this.createComponent();
        this.add(this.myComponent);
        this.setVisible(false);
        this.setOpaque(false);
    }

    private static boolean isInsideActivationArea(JScrollPane container, Point p) {
        JViewport viewport = container.getViewport();
        Rectangle r = viewport.getBounds();
        Point viewPosition = viewport.getViewPosition();
        Rectangle activationArea = new Rectangle(0, 0, r.width, r.height);
        return activationArea.contains(p.x, p.y - viewPosition.y);
    }

    public static boolean mayShowToolbar(@Nullable Document document) {
        if (document == null) {
            return false;
        }
        VirtualFile file2 = FileDocumentManager.getInstance().getFile(document);
        return file2 != null && file2.isValid();
    }

    private void toggleContextToolbar(boolean show) {
        if (this.myShow != show) {
            this.myShow = show;
            this.restartTimer();
        }
    }

    private void restartTimer() {
        if (this.myTimer != null && this.myTimer.isRunning()) {
            this.myTimer.stop();
        }
        this.myTimer = UIUtil.createNamedTimer((String)"Restart context menu", (int)500, (ActionListener)new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ContextMenuImpl.this.myDisposed) {
                    return;
                }
                if (ContextMenuImpl.this.myTimer != null && ContextMenuImpl.this.myTimer.isRunning()) {
                    ContextMenuImpl.this.myTimer.stop();
                }
                ContextMenuImpl.this.myActionToolbar.updateActionsImmediately();
                if (((Container)ContextMenuImpl.this.myActionToolbar).getComponentCount() == 0) {
                    ContextMenuImpl.this.myShow = false;
                    return;
                }
                ContextMenuImpl.this.myTimer = UIUtil.createNamedTimer((String)"Restart context menu now", (int)50, (ActionListener)new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (ContextMenuImpl.this.myShow) {
                            if (ContextMenuImpl.this.myVisible) {
                                ContextMenuImpl.this.scheduleHide();
                                return;
                            }
                            if (ContextMenuImpl.this.myLayeredPane.getIndexOf(ContextMenuImpl.this) == -1) {
                                ContextMenuImpl.this.myCurrentOpacity = 0;
                                ContextMenuImpl.this.myLayeredPane.add((Component)ContextMenuImpl.this, JLayeredPane.POPUP_LAYER);
                                ContextMenuImpl.this.setVisible(true);
                                ContextMenuImpl.this.myLayeredPane.revalidate();
                            }
                            ContextMenuImpl.this.myCurrentOpacity = ContextMenuImpl.this.myCurrentOpacity + 20;
                            if (ContextMenuImpl.this.myCurrentOpacity >= 100) {
                                ContextMenuImpl.this.myCurrentOpacity = 100;
                                ContextMenuImpl.this.myVisible = true;
                                ContextMenuImpl.this.myTimer.stop();
                                ContextMenuImpl.this.scheduleHide();
                            }
                        } else {
                            if (!ContextMenuImpl.this.myVisible) {
                                if (ContextMenuImpl.this.myTimer != null && ContextMenuImpl.this.myTimer.isRunning()) {
                                    ContextMenuImpl.this.myTimer.stop();
                                }
                                return;
                            }
                            ContextMenuImpl.this.myCurrentOpacity = ContextMenuImpl.this.myCurrentOpacity - 20;
                            if (ContextMenuImpl.this.myCurrentOpacity <= 0) {
                                ContextMenuImpl.this.myCurrentOpacity = 0;
                                ContextMenuImpl.this.myVisible = false;
                                ContextMenuImpl.this.myLayeredPane.remove(ContextMenuImpl.this);
                                ContextMenuImpl.this.myLayeredPane.repaint();
                            }
                        }
                        ContextMenuImpl.this.repaint();
                    }
                });
                ContextMenuImpl.this.myTimer.setRepeats(true);
                ContextMenuImpl.this.myTimer.start();
            }
        });
        this.myTimer.setRepeats(false);
        this.myTimer.start();
    }

    public void dispose() {
        this.myDisposed = true;
        this.myEditor = null;
        if (this.myTimer != null) {
            this.myTimer.stop();
            this.myTimer = null;
        }
    }

    private void scheduleHide() {
        if (this.myTimer != null && this.myTimer.isRunning()) {
            this.myTimer.stop();
        }
        this.myTimer = UIUtil.createNamedTimer((String)"Hide context menu", (int)1500, (ActionListener)new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PointerInfo pointerInfo;
                if (ContextMenuImpl.this.myDisposed) {
                    return;
                }
                if (ContextMenuImpl.this.myComponent.isVisible() && (pointerInfo = MouseInfo.getPointerInfo()) != null) {
                    Point location = pointerInfo.getLocation();
                    SwingUtilities.convertPointFromScreen(location, ContextMenuImpl.this.myComponent);
                    if (!ContextMenuImpl.this.myComponent.getBounds().contains(location)) {
                        ContextMenuImpl.this.toggleContextToolbar(false);
                    } else {
                        ContextMenuImpl.this.scheduleHide();
                    }
                }
            }
        });
        this.myTimer.setRepeats(false);
        this.myTimer.start();
    }

    private JComponent createComponent() {
        this.myActionToolbar = new ActionToolbarImpl("ContextToolbar", this.myActionGroup, true, DataManager.getInstance(), ActionManagerEx.getInstanceEx(), KeymapManagerEx.getInstanceEx());
        this.myActionToolbar.setTargetComponent((JComponent)this.myEditor.getContentComponent());
        this.myActionToolbar.setMinimumButtonSize(new Dimension(22, 22));
        this.myActionToolbar.setReservePlaceAutoPopupIcon(false);
        ContextMenuPanel contextMenuPanel = new ContextMenuPanel(this);
        contextMenuPanel.setLayout(new BorderLayout(0, 0));
        JComponent toolbarComponent = this.myActionToolbar.getComponent();
        toolbarComponent.setOpaque(false);
        contextMenuPanel.add(toolbarComponent);
        return contextMenuPanel;
    }

    private static class ContextMenuPanel
    extends JPanel {
        private final ContextMenuImpl myContextMenu;

        private ContextMenuPanel(ContextMenuImpl contextMenu) {
            this.myContextMenu = contextMenu;
            this.setBorder(BorderFactory.createEmptyBorder(1, 2, 1, 2));
            this.setOpaque(false);
        }

        @Override
        protected void paintChildren(Graphics g) {
            Graphics2D graphics = (Graphics2D)g.create();
            try {
                graphics.setComposite(AlphaComposite.getInstance(10, (float)this.myContextMenu.myCurrentOpacity / 100.0f));
                super.paintChildren(graphics);
            }
            finally {
                graphics.dispose();
            }
        }

        @Override
        public void paint(Graphics g) {
            this.paintComponent(g);
            super.paint(g);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paintComponent(Graphics g) {
            Rectangle r = this.getBounds();
            Graphics2D graphics = (Graphics2D)g.create();
            try {
                graphics.setComposite(AlphaComposite.getInstance(3, (float)this.myContextMenu.myCurrentOpacity / 600.0f));
                graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics.setColor(Color.GRAY);
                graphics.fillRoundRect(0, 0, r.width - 1, r.height - 1, 6, 6);
            }
            finally {
                graphics.dispose();
            }
        }
    }
}

