/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.ex.EditorPopupHandler;
import com.intellij.openapi.editor.impl.EditorMouseHoverPopupControl;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ContextMenuPopupHandler
implements EditorPopupHandler {
    @Nullable
    public abstract ActionGroup getActionGroup(@NotNull EditorMouseEvent var1);

    @Override
    public boolean handlePopup(@NotNull EditorMouseEvent event) {
        ActionGroup group = this.getActionGroup(event);
        if (group != null) {
            ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu("EditorPopup", group);
            MouseEvent e = event.getMouseEvent();
            Component c = e.getComponent();
            if (c != null && c.isShowing()) {
                JPopupMenu popupComponent = popupMenu.getComponent();
                ContextMenuPopupHandler.disableHoverPopupsWhileShowing(event.getEditor(), popupComponent);
                popupComponent.show(c, e.getX(), e.getY());
                event.consume();
            }
        }
        return true;
    }

    private static void disableHoverPopupsWhileShowing(final Editor editor, final Component popupComponent) {
        new UiNotifyConnector.Once(popupComponent, (Activatable)new Activatable.Adapter(){

            public void showNotify() {
                EditorMouseHoverPopupControl.disablePopups(editor);
                new UiNotifyConnector.Once(popupComponent, (Activatable)new Activatable.Adapter(){

                    public void hideNotify() {
                        EditorMouseHoverPopupControl.enablePopups(editor);
                    }
                });
            }
        });
    }

    @Nullable
    private static ActionGroup getGroupForId(@Nullable String groupId) {
        return groupId == null ? null : (ActionGroup)ObjectUtils.tryCast((Object)CustomActionsSchema.getInstance().getCorrectedAction(groupId), ActionGroup.class);
    }

    public static class Simple
    extends ContextMenuPopupHandler {
        private final ActionGroup myActionGroup;

        public Simple(ActionGroup actionGroup) {
            this.myActionGroup = actionGroup;
        }

        public Simple(String groupId) {
            this(ContextMenuPopupHandler.getGroupForId(groupId));
        }

        @Override
        @Nullable
        public ActionGroup getActionGroup(@NotNull EditorMouseEvent event) {
            return this.myActionGroup;
        }
    }

    public static abstract class ById
    extends ContextMenuPopupHandler {
        @Override
        @Nullable
        public ActionGroup getActionGroup(@NotNull EditorMouseEvent event) {
            return ContextMenuPopupHandler.getGroupForId(this.getActionGroupId(event));
        }

        @Nullable
        public abstract String getActionGroupId(@NotNull EditorMouseEvent var1);
    }
}

