/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.ide.CutProvider;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.PasteProvider;
import com.intellij.ide.actions.UndoRedoAction;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ReadOnlyFragmentModificationException;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.util.EditorUIUtil;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.ui.TypingTarget;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.Grayer;
import com.intellij.ui.components.Magnificator;
import com.intellij.ui.paint.PaintUtil;
import com.intellij.util.ui.JBSwingUtilities;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.ScreenReader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputMethodEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.im.InputMethodRequests;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleEditableText;
import javax.accessibility.AccessibleExtendedText;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.accessibility.AccessibleTextSequence;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.View;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorComponentImpl
extends JTextComponent
implements Scrollable,
DataProvider,
Queryable,
TypingTarget,
Accessible {
    private final EditorImpl myEditor;
    private final ApplicationImpl myApplication;

    public EditorComponentImpl(@NotNull EditorImpl editor) {
        this.myEditor = editor;
        this.enableEvents(2056L);
        this.enableInputMethods(true);
        this.setFocusCycleRoot(!ScreenReader.isActive());
        if (ScreenReader.isActive()) {
            this.setFocusable(true);
        }
        this.setOpaque(true);
        this.putClientProperty(Magnificator.CLIENT_PROPERTY_KEY, new Magnificator(){

            public Point magnify(double scale, Point at) {
                if (EditorComponentImpl.this.myEditor.isDisposed()) {
                    return at;
                }
                VisualPosition magnificationPosition = EditorComponentImpl.this.myEditor.xyToVisualPosition(at);
                double currentSize = EditorComponentImpl.this.myEditor.getColorsScheme().getEditorFontSize();
                int defaultFontSize = EditorColorsManager.getInstance().getGlobalScheme().getEditorFontSize();
                EditorComponentImpl.this.myEditor.setFontSize(Math.max((int)(currentSize * scale), defaultFontSize));
                return EditorComponentImpl.this.myEditor.visualPositionToXY(magnificationPosition);
            }
        });
        this.putClientProperty(UndoRedoAction.IGNORE_SWING_UNDO_MANAGER, Boolean.TRUE);
        this.myApplication = (ApplicationImpl)ApplicationManager.getApplication();
        this.setupJTextComponentContext();
        for (MouseListener mouseListener : this.getMouseListeners()) {
            this.removeMouseListener(mouseListener);
        }
        for (EventListener eventListener : this.getFocusListeners()) {
            this.removeFocusListener((FocusListener)eventListener);
        }
    }

    @Override
    public void paint(@NotNull Graphics g) {
        if (!this.isEnabled()) {
            g = new Grayer((Graphics2D)g, this.getBackground());
        }
        super.paint(g);
    }

    @NotNull
    public EditorImpl getEditor() {
        return this.myEditor;
    }

    public Object getData(@NotNull String dataId) {
        if (this.myEditor.isDisposed()) {
            return null;
        }
        if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
            return this.myEditor.getCopyProvider();
        }
        if (this.myEditor.isRendererMode()) {
            return null;
        }
        if (CommonDataKeys.EDITOR.is(dataId)) {
            return this.myEditor;
        }
        if (CommonDataKeys.CARET.is(dataId)) {
            return this.myEditor.getCaretModel().getCurrentCaret();
        }
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
            return this.myEditor.getDeleteProvider();
        }
        if (PlatformDataKeys.CUT_PROVIDER.is(dataId)) {
            return this.myEditor.getCutProvider();
        }
        if (PlatformDataKeys.PASTE_PROVIDER.is(dataId)) {
            return this.myEditor.getPasteProvider();
        }
        if (CommonDataKeys.EDITOR_VIRTUAL_SPACE.is(dataId)) {
            LogicalPosition location = this.myEditor.myLastMousePressedLocation;
            if (location == null) {
                location = this.myEditor.getCaretModel().getLogicalPosition();
            }
            return EditorUtil.inVirtualSpace(this.myEditor, location);
        }
        return null;
    }

    @Override
    public Color getBackground() {
        return this.myEditor.getBackgroundColor();
    }

    @Override
    public Dimension getPreferredSize() {
        return this.myEditor.getPreferredSize();
    }

    @Override
    public void setCursor(Cursor cursor) {
        super.setCursor(cursor);
        this.myEditor.myCursorSetExternally = true;
    }

    protected void fireResized() {
        this.processComponentEvent(new ComponentEvent(this, 101));
    }

    @Override
    protected void processInputMethodEvent(InputMethodEvent e) {
        if (!e.isConsumed()) {
            switch (e.getID()) {
                case 1100: {
                    this.myEditor.replaceInputMethodText(e);
                }
                case 1101: {
                    this.myEditor.inputMethodCaretPositionChanged(e);
                    e.consume();
                }
            }
        }
        super.processInputMethodEvent(e);
    }

    public ActionCallback type(String text) {
        ActionCallback result2 = new ActionCallback();
        UIUtil.invokeLaterIfNeeded(() -> this.myEditor.type(text).notify(result2));
        return result2;
    }

    @Override
    @Nullable
    public InputMethodRequests getInputMethodRequests() {
        return IdeEventQueue.getInstance().isInputMethodEnabled() ? this.myEditor.getInputMethodRequests() : null;
    }

    @Override
    protected Graphics getComponentGraphics(Graphics graphics) {
        return JBSwingUtilities.runGlobalCGTransform((JComponent)this, (Graphics)super.getComponentGraphics(graphics));
    }

    @Override
    public void paintComponent(Graphics g) {
        this.myEditor.measureTypingLatency();
        Graphics2D gg = (Graphics2D)g;
        UIUtil.setupComposite((Graphics2D)gg);
        if (this.myEditor.useEditorAntialiasing()) {
            EditorUIUtil.setupAntialiasing(gg);
        } else {
            UISettings.setupAntialiasing((Graphics)gg);
        }
        gg.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, this.myEditor.myFractionalMetricsHintValue);
        AffineTransform origTx = PaintUtil.alignTxToInt((Graphics2D)gg, (Point2D)PaintUtil.insets2offset((Insets)this.getInsets()), (boolean)true, (boolean)false, (PaintUtil.RoundingMode)PaintUtil.RoundingMode.CEIL);
        this.myEditor.paint(gg);
        if (origTx != null) {
            gg.setTransform(origTx);
        }
    }

    public void repaintEditorComponent() {
        this.repaint();
    }

    public void repaintEditorComponentExact(int x, int y, int width, int height) {
        this.repaint(x, y, width, height);
    }

    public void repaintEditorComponent(int x, int y, int width, int height) {
        int topOverhang = Math.max(0, this.myEditor.myView.getTopOverhang());
        int bottomOverhang = Math.max(0, this.myEditor.myView.getBottomOverhang());
        this.repaint(x, y - topOverhang, width, height + topOverhang + bottomOverhang);
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.myEditor.getPreferredSize();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 1) {
            return this.myEditor.getLineHeight();
        }
        return EditorUtil.getSpaceWidth(0, this.myEditor);
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 1) {
            int lineHeight = this.myEditor.getLineHeight();
            if (direction > 0) {
                int lineNumber = (visibleRect.y + visibleRect.height) / lineHeight;
                return lineHeight * lineNumber - visibleRect.y;
            }
            int lineNumber = (visibleRect.y - visibleRect.height) / lineHeight;
            return visibleRect.y - lineHeight * lineNumber;
        }
        return visibleRect.width;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return this.getParent() instanceof JViewport && this.getParent().getWidth() > this.getPreferredSize().width;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return this.getParent() instanceof JViewport && this.getParent().getHeight() > this.getPreferredSize().height;
    }

    public void putInfo(@NotNull Map<String, String> info) {
        this.myEditor.putInfo(info);
    }

    @Override
    @NonNls
    public String toString() {
        return "EditorComponent file=" + this.myEditor.getVirtualFile();
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleEditorComponentImpl();
        }
        return this.accessibleContext;
    }

    private void setupJTextComponentContext() {
        this.setDocument(new EditorAccessibilityDocument());
        this.setCaret(new EditorAccessibilityCaret());
    }

    @Override
    @Deprecated
    public Document getDocument() {
        return super.getDocument();
    }

    @Override
    public int getCaretPosition() {
        return this.myEditor.getCaretModel().getOffset();
    }

    @Override
    public void updateUI() {
        this.setUI(new EditorAccessibilityTextUI());
        UISettings.setupEditorAntialiasing((JComponent)this);
        this.invalidate();
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        return this.getToolTipText();
    }

    private void fireJTextComponentCaretChange(final com.intellij.openapi.editor.event.CaretEvent event) {
        CaretEvent swingEvent = new CaretEvent(this){

            @Override
            public int getDot() {
                Caret caret = event.getCaret();
                if (caret != null) {
                    return caret.getOffset();
                }
                return 0;
            }

            @Override
            public int getMark() {
                Caret caret = event.getCaret();
                if (caret != null) {
                    return caret.getLeadSelectionOffset();
                }
                return 0;
            }
        };
        for (CaretListener listener2 : this.getCaretListeners()) {
            listener2.caretUpdate(swingEvent);
        }
    }

    private void fireJTextComponentDocumentChange(final com.intellij.openapi.editor.event.DocumentEvent event) {
        List<javax.swing.event.DocumentListener> listeners = ((EditorAccessibilityDocument)this.getDocument()).getListeners();
        if (listeners == null) {
            return;
        }
        DocumentEvent swingEvent = new DocumentEvent(){

            @Override
            public int getOffset() {
                return event.getOffset();
            }

            @Override
            public int getLength() {
                return event.getNewLength();
            }

            @Override
            public Document getDocument() {
                return EditorComponentImpl.this.getDocument();
            }

            @Override
            public DocumentEvent.EventType getType() {
                return event.getOldLength() == 0 ? DocumentEvent.EventType.INSERT : (event.getNewLength() == 0 ? DocumentEvent.EventType.REMOVE : DocumentEvent.EventType.CHANGE);
            }

            @Override
            @Nullable
            public DocumentEvent.ElementChange getChange(Element element) {
                return null;
            }
        };
        for (javax.swing.event.DocumentListener listener2 : listeners) {
            DocumentEvent.EventType type = swingEvent.getType();
            if (type == DocumentEvent.EventType.INSERT) {
                listener2.insertUpdate(swingEvent);
                continue;
            }
            if (type == DocumentEvent.EventType.REMOVE) {
                listener2.removeUpdate(swingEvent);
                continue;
            }
            if (type != DocumentEvent.EventType.CHANGE) continue;
            listener2.changedUpdate(swingEvent);
        }
    }

    private static void notSupported() {
        throw new RuntimeException("Not supported for this text implementation");
    }

    @Override
    public void setText(String text) {
        this.editDocumentSafely(0, this.myEditor.getDocument().getTextLength(), text);
    }

    private void editDocumentSafely(int offset, int length, @Nullable String text) {
        DocumentEx document = this.myEditor.getDocument();
        RangeMarker marker = document.createRangeMarker(offset, offset + length);
        TransactionGuard.submitTransaction((Disposable)this.myEditor.getDisposable(), () -> {
            Project project = this.myEditor.getProject();
            if (!marker.isValid() || !FileDocumentManager.getInstance().requestWriting(document, project)) {
                marker.dispose();
                return;
            }
            CommandProcessor.getInstance().executeCommand(project, () -> WriteAction.run(() -> {
                document.startGuardedBlockChecking();
                try {
                    document.replaceString(marker.getStartOffset(), marker.getEndOffset(), StringUtil.notNullize((String)text));
                }
                catch (ReadOnlyFragmentModificationException e) {
                    EditorActionManager.getInstance().getReadonlyFragmentModificationHandler(document).handle(e);
                }
                finally {
                    document.stopGuardedBlockChecking();
                    marker.dispose();
                }
            }), "", (Object)document, UndoConfirmationPolicy.DEFAULT, document);
        });
    }

    private class AccessibleEditorComponentImpl
    extends JComponent.AccessibleJComponent
    implements AccessibleText,
    AccessibleEditableText,
    AccessibleExtendedText,
    com.intellij.openapi.editor.event.CaretListener,
    DocumentListener {
        private int myCaretPos;
        private static final int BEFORE = -1;
        private static final int HERE = 0;
        private static final int AFTER = 1;

        AccessibleEditorComponentImpl() {
            super(EditorComponentImpl.this);
            if (EditorComponentImpl.this.myEditor.isDisposed()) {
                return;
            }
            EditorComponentImpl.this.myEditor.getCaretModel().addCaretListener(this, EditorComponentImpl.this.myEditor.getDisposable());
            EditorComponentImpl.this.myEditor.getDocument().addDocumentListener(this);
            Disposer.register((Disposable)EditorComponentImpl.this.myEditor.getDisposable(), (Disposable)new Disposable(){

                public void dispose() {
                    EditorComponentImpl.this.myEditor.getDocument().removeDocumentListener(AccessibleEditorComponentImpl.this);
                }
            });
        }

        public void caretPositionChanged(@NotNull com.intellij.openapi.editor.event.CaretEvent e) {
            Caret caret = e.getCaret();
            if (caret == null) {
                return;
            }
            int dot = caret.getOffset();
            int mark = caret.getLeadSelectionOffset();
            if (this.myCaretPos != dot) {
                ApplicationManager.getApplication().assertIsDispatchThread();
                this.firePropertyChange("AccessibleCaret", new Integer(this.myCaretPos), new Integer(dot));
                if (SystemInfo.isMac) {
                    EditorComponentImpl.this.fireJTextComponentCaretChange(e);
                }
                this.myCaretPos = dot;
            }
            if (mark != dot) {
                ApplicationManager.getApplication().assertIsDispatchThread();
                this.firePropertyChange("AccessibleSelection", null, this.getSelectedText());
            }
        }

        public void documentChanged(@NotNull com.intellij.openapi.editor.event.DocumentEvent event) {
            Integer pos = event.getOffset();
            if (ApplicationManager.getApplication().isDispatchThread()) {
                this.firePropertyChange("AccessibleText", null, pos);
                if (SystemInfo.isMac) {
                    EditorComponentImpl.this.fireJTextComponentDocumentChange(event);
                }
            } else {
                ApplicationManager.getApplication().invokeLater(() -> {
                    this.firePropertyChange("AccessibleText", null, pos);
                    EditorComponentImpl.this.fireJTextComponentDocumentChange(event);
                });
            }
        }

        @Override
        @Nullable
        public String getAccessibleName() {
            if (this.accessibleName != null) {
                return this.accessibleName;
            }
            VirtualFile file2 = EditorComponentImpl.this.myEditor.getVirtualFile();
            if (file2 != null) {
                return "Editor for " + file2.getName();
            }
            return "Editor";
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            if (SystemInfo.isMac) {
                return TextAccessibleRole.TEXT_AREA;
            }
            return AccessibleRole.TEXT;
        }

        @Override
        public AccessibleText getAccessibleText() {
            if (Disposer.isDisposed((Disposable)EditorComponentImpl.this.myEditor.getDisposable())) {
                return null;
            }
            return this;
        }

        @Override
        public AccessibleEditableText getAccessibleEditableText() {
            if (Disposer.isDisposed((Disposable)EditorComponentImpl.this.myEditor.getDisposable())) {
                return null;
            }
            return this;
        }

        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet states = super.getAccessibleStateSet();
            if (EditorComponentImpl.this.myEditor.getDocument().isWritable()) {
                states.add(AccessibleState.EDITABLE);
            }
            states.add(AccessibleState.MULTI_LINE);
            return states;
        }

        @Override
        public int getIndexAtPoint(Point point) {
            LogicalPosition logicalPosition = EditorComponentImpl.this.myEditor.xyToLogicalPosition(point);
            return EditorComponentImpl.this.myEditor.logicalPositionToOffset(logicalPosition);
        }

        @Override
        public Rectangle getCharacterBounds(int offset) {
            if (offset < 0 || offset > EditorComponentImpl.this.myEditor.getDocument().getTextLength() - 1) {
                return null;
            }
            LogicalPosition pos = EditorComponentImpl.this.myEditor.offsetToLogicalPosition(offset);
            Point point = EditorComponentImpl.this.myEditor.logicalPositionToXY(pos);
            FontMetrics fontMetrics = EditorComponentImpl.this.myEditor.getFontMetrics(0);
            char c = EditorComponentImpl.this.myEditor.getDocument().getCharsSequence().subSequence(offset, offset + 1).charAt(0);
            return new Rectangle(point.x, point.y, fontMetrics.charWidth(c), fontMetrics.getHeight());
        }

        @Override
        public int getCharCount() {
            return EditorComponentImpl.this.myEditor.getDocument().getTextLength();
        }

        @Override
        public int getCaretPosition() {
            return EditorComponentImpl.this.myEditor.getCaretModel().getOffset();
        }

        @Override
        @Nullable
        public String getAtIndex(int part, int index) {
            return this.getTextAtOffset(part, index, 0);
        }

        @Override
        @Nullable
        public String getAfterIndex(int part, int index) {
            return this.getTextAtOffset(part, index, 1);
        }

        @Override
        @Nullable
        public String getBeforeIndex(int part, int index) {
            return this.getTextAtOffset(part, index, -1);
        }

        @Override
        public AttributeSet getCharacterAttribute(int index) {
            return new SimpleAttributeSet();
        }

        @Override
        public int getSelectionStart() {
            return EditorComponentImpl.this.myEditor.getSelectionModel().getSelectionStart();
        }

        @Override
        public int getSelectionEnd() {
            return EditorComponentImpl.this.myEditor.getSelectionModel().getSelectionEnd();
        }

        @Override
        @Nullable
        public String getSelectedText() {
            return EditorComponentImpl.this.myEditor.getSelectionModel().getSelectedText();
        }

        @Override
        public void setTextContents(String s) {
            EditorComponentImpl.this.setText(s);
        }

        @Override
        public void insertTextAtIndex(int index, String s) {
            EditorComponentImpl.this.editDocumentSafely(index, 0, s);
        }

        @Override
        public String getTextRange(int startIndex, int endIndex) {
            return EditorComponentImpl.this.myEditor.getDocument().getCharsSequence().subSequence(startIndex, endIndex).toString();
        }

        @Override
        public void delete(int startIndex, int endIndex) {
            EditorComponentImpl.this.editDocumentSafely(startIndex, endIndex - startIndex, null);
        }

        @Override
        public void cut(int startIndex, int endIndex) {
            EditorComponentImpl.this.myEditor.getSelectionModel().setSelection(startIndex, endIndex);
            DataContext dataContext = DataManager.getInstance().getDataContext((Component)EditorComponentImpl.this);
            CutProvider cutProvider = EditorComponentImpl.this.myEditor.getCutProvider();
            if (cutProvider.isCutEnabled(dataContext)) {
                cutProvider.performCut(dataContext);
            }
        }

        @Override
        public void paste(int startIndex) {
            EditorComponentImpl.this.myEditor.getCaretModel().moveToOffset(startIndex);
            DataContext dataContext = DataManager.getInstance().getDataContext((Component)EditorComponentImpl.this);
            PasteProvider pasteProvider = EditorComponentImpl.this.myEditor.getPasteProvider();
            if (pasteProvider.isPasteEnabled(dataContext)) {
                pasteProvider.performPaste(dataContext);
            }
        }

        @Override
        public void replaceText(int startIndex, int endIndex, String s) {
            EditorComponentImpl.this.editDocumentSafely(startIndex, endIndex, s);
        }

        @Override
        public void selectText(int startIndex, int endIndex) {
            EditorComponentImpl.this.myEditor.getSelectionModel().setSelection(startIndex, endIndex);
        }

        @Override
        public void setAttributes(int startIndex, int endIndex, AttributeSet as) {
        }

        @Override
        @Nullable
        public AccessibleTextSequence getTextSequenceAt(int part, int index) {
            return this.getSequenceAtIndex(part, index, 0);
        }

        @Override
        @Nullable
        public AccessibleTextSequence getTextSequenceAfter(int part, int index) {
            return this.getSequenceAtIndex(part, index, 1);
        }

        @Override
        @Nullable
        public AccessibleTextSequence getTextSequenceBefore(int part, int index) {
            return this.getSequenceAtIndex(part, index, -1);
        }

        @Override
        @Nullable
        public Rectangle getTextBounds(int startIndex, int endIndex) {
            LogicalPosition startPos = EditorComponentImpl.this.myEditor.offsetToLogicalPosition(startIndex);
            Point startPoint = EditorComponentImpl.this.myEditor.logicalPositionToXY(startPos);
            Rectangle rectangle = new Rectangle(startPoint);
            LogicalPosition endPos = EditorComponentImpl.this.myEditor.offsetToLogicalPosition(endIndex);
            Point endPoint = EditorComponentImpl.this.myEditor.logicalPositionToXY(endPos);
            FontMetrics fontMetrics = EditorComponentImpl.this.myEditor.getFontMetrics(0);
            char c = EditorComponentImpl.this.myEditor.getDocument().getCharsSequence().subSequence(endIndex - 1, endIndex).charAt(0);
            endPoint.x += fontMetrics.charWidth(c);
            endPoint.y += fontMetrics.getHeight();
            rectangle.add(endPoint);
            return rectangle;
        }

        @Nullable
        private String getTextAtOffset(int type, int offset, int direction) {
            DocumentEx document = EditorComponentImpl.this.myEditor.getDocument();
            if (offset < 0 || offset >= document.getTextLength()) {
                return null;
            }
            switch (type) {
                case 1: {
                    if (offset + direction >= document.getTextLength() || offset + direction < 0) break;
                    int startOffset = offset + direction;
                    return document.getCharsSequence().subSequence(startOffset, startOffset + 1).toString();
                }
                case 2: {
                    int wordStart = this.getWordAtOffsetStart(offset, direction);
                    int wordEnd = this.getWordAtOffsetEnd(offset, direction);
                    if (wordStart == -1 || wordEnd == -1) {
                        return null;
                    }
                    return EditorComponentImpl.this.myEditor.getDocument().getCharsSequence().subSequence(wordStart, wordEnd).toString();
                }
                case 3: {
                    int lineStart = this.getLineAtOffsetStart(offset, direction);
                    int lineEnd = this.getLineAtOffsetEnd(offset, direction);
                    if (lineStart == -1 || lineEnd == -1) {
                        return null;
                    }
                    return document.getCharsSequence().subSequence(lineStart, lineEnd).toString();
                }
                case 4: 
                case 5: {
                    assert (false) : type;
                    break;
                }
            }
            return null;
        }

        @Nullable
        private AccessibleTextSequence getSequenceAtIndex(int type, int offset, int direction) {
            assert (direction == -1 || direction == 0 || direction == 1);
            DocumentEx document = EditorComponentImpl.this.myEditor.getDocument();
            if (offset < 0 || offset >= document.getTextLength()) {
                return null;
            }
            switch (type) {
                case 1: {
                    AccessibleTextSequence charSequence = null;
                    if (offset + direction < document.getTextLength() && offset + direction >= 0) {
                        int startOffset = offset + direction;
                        charSequence = new AccessibleTextSequence(startOffset, startOffset + 1, document.getCharsSequence().subSequence(startOffset, startOffset + 1).toString());
                    }
                    return charSequence;
                }
                case 2: 
                case 5: {
                    int wordStart = this.getWordAtOffsetStart(offset, direction);
                    int wordEnd = this.getWordAtOffsetEnd(offset, direction);
                    if (wordStart == -1 || wordEnd == -1) {
                        return null;
                    }
                    return new AccessibleTextSequence(wordStart, wordEnd, document.getCharsSequence().subSequence(wordStart, wordEnd).toString());
                }
                case 3: 
                case 4: {
                    int lineStart = this.getLineAtOffsetStart(offset, direction);
                    int lineEnd = this.getLineAtOffsetEnd(offset, direction);
                    if (lineStart == -1 || lineEnd == -1) {
                        return null;
                    }
                    return new AccessibleTextSequence(lineStart, lineEnd, document.getCharsSequence().subSequence(lineStart, lineEnd).toString());
                }
            }
            return null;
        }

        private int getLineAtOffsetStart(int offset) {
            DocumentEx document = EditorComponentImpl.this.myEditor.getDocument();
            if (offset == 0) {
                return 0;
            }
            int lineNumber = ((EditorComponentImpl)EditorComponentImpl.this).myEditor.offsetToLogicalPosition((int)offset).line;
            return document.getLineStartOffset(lineNumber);
        }

        private int moveLineOffset(int offset, int direction) {
            if (direction == 1) {
                int lineNumber = ((EditorComponentImpl)EditorComponentImpl.this).myEditor.offsetToLogicalPosition((int)offset).line;
                DocumentEx document = EditorComponentImpl.this.myEditor.getDocument();
                if (++lineNumber == document.getLineCount()) {
                    return -1;
                }
                return document.getLineStartOffset(lineNumber);
            }
            if (direction == -1) {
                int lineNumber = ((EditorComponentImpl)EditorComponentImpl.this).myEditor.offsetToLogicalPosition((int)offset).line;
                if (--lineNumber < 0) {
                    return -1;
                }
                DocumentEx document = EditorComponentImpl.this.myEditor.getDocument();
                return document.getLineStartOffset(lineNumber);
            }
            assert (direction == 0);
            return offset;
        }

        private int getLineAtOffsetStart(int offset, int direction) {
            if ((offset = this.moveLineOffset(offset, direction)) == -1) {
                return -1;
            }
            return this.getLineAtOffsetStart(offset);
        }

        private int getLineAtOffsetEnd(int offset) {
            DocumentEx document = EditorComponentImpl.this.myEditor.getDocument();
            if (offset == 0) {
                return 0;
            }
            int lineNumber = ((EditorComponentImpl)EditorComponentImpl.this).myEditor.offsetToLogicalPosition((int)offset).line;
            return document.getLineEndOffset(lineNumber);
        }

        private int getLineAtOffsetEnd(int offset, int direction) {
            if ((offset = this.moveLineOffset(offset, direction)) == -1) {
                return -1;
            }
            return this.getLineAtOffsetEnd(offset);
        }

        private int moveWordOffset(int offset, int direction) {
            if (direction == 1) {
                int newOffset;
                DocumentEx document = EditorComponentImpl.this.myEditor.getDocument();
                CharSequence text = document.getCharsSequence();
                int maxOffset = document.getTextLength();
                boolean camel = EditorComponentImpl.this.myEditor.getSettings().isCamelWords();
                for (newOffset = offset - 1; newOffset < maxOffset && !EditorActionUtil.isWordEnd(text, newOffset, camel); ++newOffset) {
                }
                ++newOffset;
                while (newOffset < maxOffset) {
                    if (EditorActionUtil.isWordStart(text, newOffset, camel)) {
                        return newOffset;
                    }
                    ++newOffset;
                }
                return -1;
            }
            if (direction == -1) {
                int newOffset;
                DocumentEx document = EditorComponentImpl.this.myEditor.getDocument();
                CharSequence text = document.getCharsSequence();
                boolean camel = EditorComponentImpl.this.myEditor.getSettings().isCamelWords();
                for (newOffset = offset - 1; newOffset >= 0 && !EditorActionUtil.isWordStart(text, newOffset, camel); --newOffset) {
                }
                --newOffset;
                while (newOffset >= 0) {
                    if (EditorActionUtil.isWordEnd(text, newOffset, camel)) {
                        return newOffset;
                    }
                    --newOffset;
                }
                return -1;
            }
            assert (direction == 0);
            return offset;
        }

        private int getWordAtOffsetStart(int offset, int direction) {
            if ((offset = this.moveWordOffset(offset, direction)) == -1) {
                return -1;
            }
            return this.getWordAtOffsetStart(offset);
        }

        private int getWordAtOffsetEnd(int offset, int direction) {
            if ((offset = this.moveWordOffset(offset, direction)) == -1) {
                return -1;
            }
            return this.getWordAtOffsetEnd(offset);
        }

        private int getWordAtOffsetStart(int offset) {
            int newOffset;
            DocumentEx document = EditorComponentImpl.this.myEditor.getDocument();
            if (offset == 0) {
                return 0;
            }
            int lineNumber = ((EditorComponentImpl)EditorComponentImpl.this).myEditor.offsetToLogicalPosition((int)offset).line;
            CharSequence text = document.getCharsSequence();
            int minOffset = lineNumber > 0 ? document.getLineEndOffset(lineNumber - 1) : 0;
            boolean camel = EditorComponentImpl.this.myEditor.getSettings().isCamelWords();
            for (newOffset = offset - 1; newOffset > minOffset && !EditorActionUtil.isWordStart(text, newOffset, camel); --newOffset) {
            }
            return newOffset;
        }

        private int getWordAtOffsetEnd(int offset) {
            DocumentEx document = EditorComponentImpl.this.myEditor.getDocument();
            CharSequence text = document.getCharsSequence();
            if (offset >= document.getTextLength() - 1 || document.getLineCount() == 0) {
                return offset;
            }
            int newOffset = offset + 1;
            int lineNumber = ((EditorComponentImpl)EditorComponentImpl.this).myEditor.offsetToLogicalPosition((int)offset).line;
            int maxOffset = document.getLineEndOffset(lineNumber);
            if (newOffset > maxOffset) {
                if (lineNumber + 1 >= document.getLineCount()) {
                    return offset;
                }
                maxOffset = document.getLineEndOffset(lineNumber + 1);
            }
            boolean camel = EditorComponentImpl.this.myEditor.getSettings().isCamelWords();
            while (newOffset < maxOffset && !EditorActionUtil.isWordEnd(text, newOffset, camel)) {
                ++newOffset;
            }
            return newOffset;
        }
    }

    private static class TextAccessibleRole
    extends AccessibleRole {
        private static final AccessibleRole TEXT_AREA = new TextAccessibleRole("textarea");

        private TextAccessibleRole(String key) {
            super(key);
        }
    }

    private class EditorAccessibilityTextUI
    extends TextUI {
        private EditorAccessibilityTextUI() {
        }

        @Override
        @Nullable
        public Rectangle modelToView(JTextComponent tc, int offset) throws BadLocationException {
            return this.modelToView(tc, offset, Position.Bias.Forward);
        }

        @Override
        public int viewToModel(JTextComponent tc, Point pt) {
            LogicalPosition logicalPosition = EditorComponentImpl.this.myEditor.xyToLogicalPosition(pt);
            return EditorComponentImpl.this.myEditor.logicalPositionToOffset(logicalPosition);
        }

        @Override
        @Nullable
        public Rectangle modelToView(JTextComponent tc, int offset, Position.Bias bias) throws BadLocationException {
            LogicalPosition pos = EditorComponentImpl.this.myEditor.offsetToLogicalPosition(offset).leanForward(bias == Position.Bias.Forward);
            LogicalPosition posNext = EditorComponentImpl.this.myEditor.offsetToLogicalPosition(bias == Position.Bias.Forward ? offset + 1 : offset - 1).leanForward(bias != Position.Bias.Forward);
            Point point = EditorComponentImpl.this.myEditor.logicalPositionToXY(pos);
            Point pointNext = EditorComponentImpl.this.myEditor.logicalPositionToXY(posNext);
            return point.y == pointNext.y ? new Rectangle(Math.min(point.x, pointNext.x), point.y, Math.abs(point.x - pointNext.x), EditorComponentImpl.this.myEditor.getLineHeight()) : new Rectangle(point.x, point.y, 0, EditorComponentImpl.this.myEditor.getLineHeight());
        }

        @Override
        public int viewToModel(JTextComponent tc, Point pt, Position.Bias[] ignored) {
            return this.viewToModel(tc, pt);
        }

        @Override
        public int getNextVisualPositionFrom(JTextComponent t, int pos, Position.Bias b, int direction, Position.Bias[] biasRet) throws BadLocationException {
            EditorComponentImpl.notSupported();
            return 0;
        }

        @Override
        public void damageRange(JTextComponent t, int p0, int p1) {
            EditorComponentImpl.this.myEditor.repaint(p0, p1);
        }

        @Override
        public void damageRange(JTextComponent t, int p0, int p1, Position.Bias ignored1, Position.Bias ignored2) {
            this.damageRange(t, p0, p1);
        }

        @Override
        @Nullable
        public EditorKit getEditorKit(JTextComponent t) {
            EditorComponentImpl.notSupported();
            return null;
        }

        @Override
        @Nullable
        public View getRootView(JTextComponent t) {
            EditorComponentImpl.notSupported();
            return null;
        }
    }

    private class EditorAccessibilityCaret
    implements javax.swing.text.Caret {
        private EditorAccessibilityCaret() {
        }

        @Override
        public void install(JTextComponent jTextComponent) {
        }

        @Override
        public void deinstall(JTextComponent jTextComponent) {
        }

        @Override
        public void paint(Graphics graphics) {
        }

        @Override
        public void addChangeListener(ChangeListener changeListener) {
        }

        @Override
        public void removeChangeListener(ChangeListener changeListener) {
        }

        @Override
        public boolean isVisible() {
            return true;
        }

        @Override
        public void setVisible(boolean visible) {
        }

        @Override
        public boolean isSelectionVisible() {
            return true;
        }

        @Override
        public void setSelectionVisible(boolean visible) {
        }

        @Override
        public void setMagicCaretPosition(Point point) {
        }

        @Override
        @Nullable
        public Point getMagicCaretPosition() {
            return null;
        }

        @Override
        public void setBlinkRate(int rate) {
        }

        @Override
        public int getBlinkRate() {
            return 250;
        }

        @Override
        public int getDot() {
            return EditorComponentImpl.this.myEditor.getCaretModel().getOffset();
        }

        @Override
        public int getMark() {
            return EditorComponentImpl.this.myEditor.getSelectionModel().getSelectionStart();
        }

        @Override
        public void setDot(int offset) {
            if (!EditorComponentImpl.this.myEditor.isDisposed()) {
                EditorComponentImpl.this.myEditor.getCaretModel().moveToOffset(offset);
            }
        }

        @Override
        public void moveDot(int offset) {
            if (!EditorComponentImpl.this.myEditor.isDisposed()) {
                EditorComponentImpl.this.myEditor.getCaretModel().moveToOffset(offset);
            }
        }
    }

    private class EditorAccessibilityDocument
    implements Document,
    Element {
        private List<javax.swing.event.DocumentListener> myListeners;

        private EditorAccessibilityDocument() {
        }

        @Nullable
        public List<javax.swing.event.DocumentListener> getListeners() {
            return this.myListeners;
        }

        @Override
        public int getLength() {
            return EditorComponentImpl.this.myEditor.getDocument().getTextLength();
        }

        @Override
        public void addDocumentListener(javax.swing.event.DocumentListener documentListener) {
            if (this.myListeners == null) {
                this.myListeners = new ArrayList<javax.swing.event.DocumentListener>(2);
            }
            this.myListeners.add(documentListener);
        }

        @Override
        public void removeDocumentListener(javax.swing.event.DocumentListener documentListener) {
            if (this.myListeners != null) {
                this.myListeners.remove(documentListener);
            }
        }

        @Override
        public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        }

        @Override
        public void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
        }

        @Override
        @Nullable
        public Object getProperty(Object o) {
            return null;
        }

        @Override
        public void putProperty(Object o, Object o1) {
        }

        @Override
        public void remove(int offset, int length) throws BadLocationException {
            EditorComponentImpl.this.editDocumentSafely(offset, length, null);
        }

        @Override
        public void insertString(int offset, String text, AttributeSet attributeSet) throws BadLocationException {
            EditorComponentImpl.this.editDocumentSafely(offset, 0, text);
        }

        @Override
        public String getText(int offset, int length) throws BadLocationException {
            return (String)ReadAction.compute(() -> EditorComponentImpl.this.myEditor.getDocument().getText(new TextRange(offset, offset + length)));
        }

        @Override
        public void getText(int offset, int length, Segment segment) throws BadLocationException {
            char[] s = this.getText(offset, length).toCharArray();
            segment.array = s;
            segment.offset = 0;
            segment.count = s.length;
        }

        @Override
        @Nullable
        public Position getStartPosition() {
            EditorComponentImpl.notSupported();
            return null;
        }

        @Override
        @Nullable
        public Position getEndPosition() {
            EditorComponentImpl.notSupported();
            return null;
        }

        @Override
        @Nullable
        public Position createPosition(int i) throws BadLocationException {
            EditorComponentImpl.notSupported();
            return null;
        }

        @Override
        public Element[] getRootElements() {
            return new Element[]{this};
        }

        @Override
        public Element getDefaultRootElement() {
            return this;
        }

        @Override
        public void render(Runnable runnable2) {
            ApplicationManager.getApplication().runReadAction(runnable2);
        }

        @Override
        public Document getDocument() {
            return this;
        }

        @Override
        @Nullable
        public Element getParentElement() {
            return null;
        }

        @Override
        @Nullable
        public String getName() {
            return null;
        }

        @Override
        @Nullable
        public AttributeSet getAttributes() {
            return null;
        }

        @Override
        public int getStartOffset() {
            return 0;
        }

        @Override
        public int getEndOffset() {
            return this.getLength();
        }

        @Override
        public int getElementIndex(int i) {
            DocumentEx document = EditorComponentImpl.this.myEditor.getDocument();
            return document.getLineNumber(i);
        }

        @Override
        public int getElementCount() {
            DocumentEx document = EditorComponentImpl.this.myEditor.getDocument();
            return document.getLineCount();
        }

        @Override
        public Element getElement(final int i) {
            return new Element(){

                @Override
                public Document getDocument() {
                    return EditorAccessibilityDocument.this;
                }

                @Override
                public Element getParentElement() {
                    return EditorAccessibilityDocument.this;
                }

                @Override
                @Nullable
                public String getName() {
                    return null;
                }

                @Override
                @Nullable
                public AttributeSet getAttributes() {
                    return null;
                }

                @Override
                public int getStartOffset() {
                    DocumentEx document = EditorComponentImpl.this.myEditor.getDocument();
                    return document.getLineStartOffset(i);
                }

                @Override
                public int getEndOffset() {
                    DocumentEx document = EditorComponentImpl.this.myEditor.getDocument();
                    return document.getLineEndOffset(i);
                }

                @Override
                public int getElementIndex(int i2) {
                    return 0;
                }

                @Override
                public int getElementCount() {
                    return 0;
                }

                @Override
                @Nullable
                public Element getElement(int i2) {
                    return null;
                }

                @Override
                public boolean isLeaf() {
                    return true;
                }
            };
        }

        @Override
        public boolean isLeaf() {
            return false;
        }
    }
}

