/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionStub;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.BaseComponent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorLastActionTracker;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.impl.EditorImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorLastActionTrackerImpl
implements AnActionListener,
EditorMouseListener,
Disposable,
EditorLastActionTracker,
BaseComponent {
    private final ActionManager myActionManager;
    private final EditorEventMulticaster myEditorEventMulticaster;
    private String myLastActionId;
    private Editor myCurrentEditor;
    private Editor myLastEditor;

    EditorLastActionTrackerImpl(ActionManager actionManager, EditorFactory editorFactory) {
        this.myActionManager = actionManager;
        this.myEditorEventMulticaster = editorFactory.getEventMulticaster();
        editorFactory.addEditorFactoryListener(new EditorFactoryListener(){

            public void editorReleased(@NotNull EditorFactoryEvent event) {
                EditorImpl killedEditor = (EditorImpl)event.getEditor();
                if (EditorLastActionTrackerImpl.is(EditorLastActionTrackerImpl.this.myCurrentEditor, killedEditor)) {
                    EditorLastActionTrackerImpl.this.myCurrentEditor = null;
                }
                if (EditorLastActionTrackerImpl.is(EditorLastActionTrackerImpl.this.myLastEditor, killedEditor)) {
                    EditorLastActionTrackerImpl.this.myLastEditor = null;
                }
            }
        }, (Disposable)this);
    }

    private static boolean is(Editor currentEditor, EditorImpl killedEditor) {
        return currentEditor == killedEditor || currentEditor instanceof EditorWindow && ((EditorWindow)currentEditor).getDelegate() == killedEditor;
    }

    public void initComponent() {
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(TOPIC, (Object)this);
        this.myEditorEventMulticaster.addEditorMouseListener((EditorMouseListener)this, (Disposable)this);
    }

    public void dispose() {
    }

    @Nullable
    public String getLastActionId() {
        return this.myLastActionId;
    }

    public void beforeActionPerformed(@NotNull AnAction action, @NotNull DataContext dataContext, @NotNull AnActionEvent event) {
        this.myCurrentEditor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (this.myCurrentEditor != this.myLastEditor) {
            this.resetLastAction();
        }
    }

    public void afterActionPerformed(@NotNull AnAction action, @NotNull DataContext dataContext, @NotNull AnActionEvent event) {
        this.myLastActionId = this.getActionId(action);
        this.myLastEditor = this.myCurrentEditor;
        this.myCurrentEditor = null;
    }

    public void beforeEditorTyping(char c, @NotNull DataContext dataContext) {
        this.resetLastAction();
    }

    public void mousePressed(@NotNull EditorMouseEvent e) {
        this.resetLastAction();
    }

    public void mouseClicked(@NotNull EditorMouseEvent e) {
        this.resetLastAction();
    }

    public void mouseReleased(@NotNull EditorMouseEvent e) {
        this.resetLastAction();
    }

    private String getActionId(AnAction action) {
        return action instanceof ActionStub ? ((ActionStub)action).getId() : this.myActionManager.getId(action);
    }

    private void resetLastAction() {
        this.myLastActionId = null;
        this.myLastEditor = null;
    }
}

