/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.util.Key;
import org.jetbrains.annotations.NotNull;

public class EditorMouseHoverPopupControl {
    private static final Logger LOG = Logger.getInstance(EditorMouseHoverPopupControl.class);
    private static final Key<Integer> MOUSE_TRACKING_DISABLED_COUNT = Key.create((String)"MOUSE_TRACKING_DISABLED_COUNT");

    public static void disablePopups(@NotNull Editor editor) {
        EditorMouseHoverPopupControl.setTrackingDisabled(editor, true);
    }

    public static void enablePopups(@NotNull Editor editor) {
        EditorMouseHoverPopupControl.setTrackingDisabled(editor, false);
    }

    private static void setTrackingDisabled(@NotNull Editor editor, boolean value) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        Integer userData = (Integer)editor.getUserData(MOUSE_TRACKING_DISABLED_COUNT);
        int count = (userData == null ? 0 : userData) + (value ? 1 : -1);
        if (count < 0) {
            LOG.warn((Throwable)new IllegalStateException("Editor mouse hover popups weren't disabled previously"));
            count = 0;
        }
        editor.putUserData(MOUSE_TRACKING_DISABLED_COUNT, (Object)(count == 0 ? null : Integer.valueOf(count)));
    }

    public static boolean arePopupsDisabled(@NotNull Editor editor) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return editor.getUserData(MOUSE_TRACKING_DISABLED_COUNT) != null || editor.getComponent().getClientProperty(EditorImpl.IGNORE_MOUSE_TRACKING) != null;
    }
}

