/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.LineIterator;
import com.intellij.openapi.editor.ex.RangeMarkerEx;
import com.intellij.openapi.editor.impl.LineSet;
import com.intellij.openapi.editor.impl.RangeMarkerTree;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;

public class EditorTextFieldRendererDocument
extends UserDataHolderBase
implements DocumentEx {
    private final RangeMarkerTree<RangeMarkerEx> myRangeMarkers = new RangeMarkerTree<RangeMarkerEx>((Document)this){};
    private char[] myChars = ArrayUtil.EMPTY_CHAR_ARRAY;
    private String myString = "";
    private LineSet myLineSet = LineSet.createLineSet(this.myString);

    @Override
    public void setModificationStamp(long modificationStamp) {
    }

    @Override
    public void replaceText(@NotNull CharSequence chars, long newModificationStamp) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void moveText(int srcStart, int srcEnd, int dstOffset) {
        throw new UnsupportedOperationException();
    }

    public void setText(@NotNull CharSequence text) {
        String s = StringUtil.convertLineSeparators((String)text.toString());
        this.myChars = new char[s.length()];
        s.getChars(0, s.length(), this.myChars, 0);
        this.myString = new String(this.myChars);
        this.myLineSet = LineSet.createLineSet(this.myString);
    }

    @Override
    @NotNull
    public LineIterator createLineIterator() {
        return this.myLineSet.createIterator();
    }

    @Override
    public boolean removeRangeMarker(@NotNull RangeMarkerEx rangeMarker) {
        return this.myRangeMarkers.removeInterval(rangeMarker);
    }

    @Override
    public void registerRangeMarker(@NotNull RangeMarkerEx rangeMarker, int start2, int end, boolean greedyToLeft, boolean greedyToRight, int layer) {
        this.myRangeMarkers.addInterval(rangeMarker, start2, end, greedyToLeft, greedyToRight, false, layer);
    }

    @Override
    public boolean processRangeMarkers(@NotNull Processor<? super RangeMarker> processor2) {
        return this.myRangeMarkers.processAll(processor2);
    }

    @Override
    public boolean processRangeMarkersOverlappingWith(int start2, int end, @NotNull Processor<? super RangeMarker> processor2) {
        return this.myRangeMarkers.processOverlappingWith(start2, end, processor2);
    }

    @NotNull
    public CharSequence getImmutableCharSequence() {
        return this.myString;
    }

    @NotNull
    public char[] getChars() {
        return this.myChars;
    }

    public int getLineCount() {
        return this.myLineSet.findLineIndex(this.myChars.length) + 1;
    }

    public int getLineNumber(int offset) {
        return this.myLineSet.findLineIndex(offset);
    }

    public int getLineStartOffset(int line) {
        return this.myChars.length == 0 ? 0 : this.myLineSet.getLineStart(line);
    }

    public int getLineEndOffset(int line) {
        return this.myChars.length == 0 ? 0 : this.myLineSet.getLineEnd(line);
    }

    public void insertString(int offset, @NotNull CharSequence s) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void deleteString(int startOffset, int endOffset) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void replaceString(int startOffset, int endOffset, @NotNull CharSequence s) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean isWritable() {
        return false;
    }

    public long getModificationStamp() {
        return 0L;
    }

    @NotNull
    public RangeMarker createRangeMarker(int startOffset, int endOffset, boolean surviveOnExternalChange) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @NotNull
    public RangeMarker createGuardedBlock(int startOffset, int endOffset) {
        throw new UnsupportedOperationException("Not implemented");
    }
}

