/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.impl.CaretModelImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.ColorUtil;
import com.intellij.util.DocumentUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.event.MouseEvent;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FocusModeModel {
    public static final Key<List<RangeMarker>> FOCUS_MODE_RANGES = Key.create((String)"focus.mode.ranges");
    public static final Key<TextAttributes> FOCUS_MODE_ATTRIBUTES = Key.create((String)"editor.focus.mode.attributes");
    public static final int LAYER = 10000;
    private final List<RangeHighlighter> myFocusModeMarkup = ContainerUtil.newSmartList();
    @NotNull
    private final EditorImpl myEditor;
    private RangeMarker myFocusModeRange;

    public FocusModeModel(@NotNull EditorImpl editor) {
        this.myEditor = editor;
        this.myEditor.getScrollingModel().addVisibleAreaListener(e -> {
            AWTEvent event = IdeEventQueue.getInstance().getTrueCurrentEvent();
            if (event instanceof MouseEvent) {
                this.clearFocusMode();
            } else {
                this.myEditor.applyFocusMode();
            }
        });
        final CaretModelImpl caretModel = this.myEditor.getCaretModel();
        caretModel.addCaretListener(new CaretListener(){

            public void caretAdded(@NotNull CaretEvent event) {
                this.process(event);
            }

            public void caretPositionChanged(@NotNull CaretEvent event) {
                this.process(event);
            }

            public void caretRemoved(@NotNull CaretEvent event) {
                this.process(event);
            }

            private void process(@NotNull CaretEvent event) {
                Caret caret = event.getCaret();
                if (caret == caretModel.getPrimaryCaret()) {
                    FocusModeModel.this.applyFocusMode(caret);
                }
            }
        });
        this.myEditor.getSelectionModel().addSelectionListener(new SelectionListener(){

            public void selectionChanged(@NotNull SelectionEvent e) {
                FocusModeModel.this.myEditor.applyFocusMode();
            }
        });
    }

    public RangeMarker getFocusModeRange() {
        return this.myFocusModeRange;
    }

    public void applyFocusMode(@NotNull Caret caret) {
        List data = (List)this.myEditor.getUserData(FOCUS_MODE_RANGES);
        this.clearFocusMode();
        RangeMarker startMarker = FocusModeModel.findFocusMarker(caret.getSelectionStart(), data);
        if (startMarker != null) {
            RangeMarker endMarker = FocusModeModel.findFocusMarker(caret.getSelectionEnd(), data);
            this.applyFocusMode(this.enlargeFocusRangeIfNeeded((Segment)(endMarker == null ? startMarker : new TextRange(startMarker.getStartOffset(), endMarker.getEndOffset()))));
        }
    }

    public void clearFocusMode() {
        this.myFocusModeMarkup.forEach(arg_0 -> ((MarkupModelEx)this.myEditor.getMarkupModel()).removeHighlighter(arg_0));
        this.myFocusModeMarkup.clear();
        if (this.myFocusModeRange != null) {
            this.myFocusModeRange.dispose();
            this.myFocusModeRange = null;
        }
    }

    public boolean isInFocusMode(FoldRegion region) {
        return this.myFocusModeRange != null && !FocusModeModel.intersects(this.myFocusModeRange, (RangeMarker)region);
    }

    @NotNull
    private Segment enlargeFocusRangeIfNeeded(Segment range2) {
        int originalEnd;
        int end;
        DocumentEx document;
        int originalStart = range2.getStartOffset();
        int start2 = DocumentUtil.getLineStartOffset(originalStart, document = this.myEditor.getDocument());
        if (start2 < originalStart) {
            range2 = new TextRange(start2, range2.getEndOffset());
        }
        if ((end = DocumentUtil.getLineEndOffset(originalEnd = range2.getEndOffset(), document)) >= originalEnd) {
            range2 = new TextRange(range2.getStartOffset(), end < document.getTextLength() ? end + 1 : end);
        }
        return range2;
    }

    private void applyFocusMode(@NotNull Segment focusRange) {
        EditorColorsScheme scheme2 = (EditorColorsScheme)ObjectUtils.notNull((Object)this.myEditor.getColorsScheme(), (Object)EditorColorsManager.getInstance().getGlobalScheme());
        Color background = scheme2.getDefaultBackground();
        Color foreground = Registry.getColor((String)(ColorUtil.isDark((Color)background) ? "editor.focus.mode.color.dark" : "editor.focus.mode.color.light"), (Color)Color.GRAY);
        TextAttributes attributes = new TextAttributes(foreground, background, background, EffectType.LINE_UNDERSCORE, 0);
        this.myEditor.putUserData(FOCUS_MODE_ATTRIBUTES, attributes);
        MarkupModelEx markupModel = this.myEditor.getMarkupModel();
        DocumentEx document = this.myEditor.getDocument();
        int textLength = document.getTextLength();
        int start2 = focusRange.getStartOffset();
        int end = focusRange.getEndOffset();
        if (start2 <= textLength) {
            this.myFocusModeMarkup.add(markupModel.addRangeHighlighter(0, start2, 10000, attributes, HighlighterTargetArea.EXACT_RANGE));
        }
        if (end <= textLength) {
            this.myFocusModeMarkup.add(markupModel.addRangeHighlighter(end, textLength, 10000, attributes, HighlighterTargetArea.EXACT_RANGE));
        }
        this.myFocusModeRange = document.createRangeMarker(start2, end);
    }

    @Nullable
    private static RangeMarker findFocusMarker(int offset, @Nullable List<RangeMarker> data) {
        if (data == null) {
            return null;
        }
        for (RangeMarker marker : data) {
            if (marker.getStartOffset() > offset || offset > marker.getEndOffset()) continue;
            return marker;
        }
        return null;
    }

    private static boolean intersects(RangeMarker a, RangeMarker b) {
        return Math.max(a.getStartOffset(), b.getStartOffset()) < Math.min(a.getEndOffset(), b.getEndOffset());
    }
}

