/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.impl.FoldRegionImpl;
import com.intellij.openapi.editor.impl.RangeMarkerTree;
import com.intellij.openapi.editor.impl.SweepProcessor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class FoldRegionsTree {
    private final RangeMarkerTree<FoldRegionImpl> myMarkerTree;
    @NotNull
    private volatile CachedData myCachedData = new CachedData();
    private static final Comparator<FoldRegion> BY_END_OFFSET = Comparator.comparingInt(RangeMarker::getEndOffset);
    private static final Comparator<? super FoldRegion> BY_END_OFFSET_REVERSE = Collections.reverseOrder(BY_END_OFFSET);
    static final TObjectHashingStrategy<FoldRegion> OFFSET_BASED_HASHING_STRATEGY = new TObjectHashingStrategy<FoldRegion>(){

        public int computeHashCode(FoldRegion o) {
            return o.getStartOffset() * 31 + o.getEndOffset();
        }

        public boolean equals(FoldRegion o1, FoldRegion o2) {
            return o1.getStartOffset() == o2.getStartOffset() && o1.getEndOffset() == o2.getEndOffset();
        }
    };

    FoldRegionsTree(@NotNull RangeMarkerTree<FoldRegionImpl> markerTree) {
        this.myMarkerTree = markerTree;
    }

    void clear() {
        this.clearCachedValues();
        this.myMarkerTree.clear();
    }

    void clearCachedValues() {
        this.myCachedData = new CachedData();
    }

    void clearCachedInlayValues() {
        this.myCachedData.topFoldedInlaysHeightValid = false;
    }

    protected abstract boolean isFoldingEnabled();

    protected abstract boolean hasBlockInlays();

    protected abstract int getBlockInlaysHeight(int var1, int var2);

    CachedData rebuild() {
        final ArrayList<FoldRegion> visible = new ArrayList<FoldRegion>(this.myMarkerTree.size());
        SweepProcessor.Generator generator = processor2 -> this.myMarkerTree.processOverlappingWith(0, Integer.MAX_VALUE, (Processor<FoldRegionImpl>)processor2);
        SweepProcessor.sweep(generator, new SweepProcessor<FoldRegionImpl>(){
            FoldRegionImpl lastCollapsedRegion;

            @Override
            public boolean process(int offset, @NotNull FoldRegionImpl region, boolean atStart, @NotNull Collection<FoldRegionImpl> overlapping) {
                if (atStart && (this.lastCollapsedRegion == null || region.getEndOffset() > this.lastCollapsedRegion.getEndOffset())) {
                    if (!region.isExpanded()) {
                        this.hideContainedRegions(region);
                        this.lastCollapsedRegion = region;
                    }
                    visible.add(region);
                }
                return true;
            }

            private void hideContainedRegions(FoldRegion region) {
                for (int i = visible.size() - 1; i >= 0 && region.getStartOffset() == ((FoldRegion)visible.get(i)).getStartOffset(); --i) {
                    visible.remove(i);
                }
            }
        });
        FoldRegion[] visibleRegions = FoldRegionsTree.toFoldArray(visible);
        Arrays.sort(visibleRegions, BY_END_OFFSET_REVERSE);
        return this.updateCachedAndSortOffsets(visibleRegions, true);
    }

    @NotNull
    private static FoldRegion[] toFoldArray(@NotNull List<FoldRegion> topLevels) {
        return topLevels.isEmpty() ? FoldRegion.EMPTY_ARRAY : topLevels.toArray(FoldRegion.EMPTY_ARRAY);
    }

    void updateCachedOffsets() {
        CachedData cachedData = this.myCachedData;
        this.updateCachedAndSortOffsets(cachedData.visibleRegions, false);
    }

    private CachedData updateCachedAndSortOffsets(FoldRegion[] visibleRegions, boolean fromRebuild) {
        CachedData data;
        if (!this.isFoldingEnabled()) {
            return null;
        }
        if (visibleRegions == null) {
            return this.rebuild();
        }
        ArrayList<FoldRegion> topLevel = new ArrayList<FoldRegion>(visibleRegions.length / 2);
        for (FoldRegion region : visibleRegions) {
            if (!region.isValid()) {
                if (fromRebuild) {
                    throw new RuntimeExceptionWithAttachments("FoldRegionsTree.rebuild() failed", new Attachment[]{new Attachment("visibleRegions.txt", Arrays.toString(visibleRegions))});
                }
                return this.rebuild();
            }
            if (region.isExpanded()) continue;
            topLevel.add(region);
        }
        FoldRegion[] topLevelRegions = topLevel.toArray(FoldRegion.EMPTY_ARRAY);
        Arrays.sort(topLevelRegions, BY_END_OFFSET);
        int[] startOffsets = ArrayUtil.newIntArray((int)topLevelRegions.length);
        int[] endOffsets = ArrayUtil.newIntArray((int)topLevelRegions.length);
        int[] foldedLines = ArrayUtil.newIntArray((int)topLevelRegions.length);
        int foldedLinesSum = 0;
        for (int i = 0; i < topLevelRegions.length; ++i) {
            FoldRegion region = topLevelRegions[i];
            startOffsets[i] = region.getStartOffset();
            endOffsets[i] = region.getEndOffset() - 1;
            Document document = region.getDocument();
            foldedLines[i] = foldedLinesSum += document.getLineNumber(region.getEndOffset()) - document.getLineNumber(region.getStartOffset());
        }
        this.myCachedData = data = new CachedData(visibleRegions, topLevelRegions, startOffsets, endOffsets, foldedLines);
        return data;
    }

    boolean checkIfValidToCreate(int start2, int end) {
        return this.myMarkerTree.processOverlappingWith(start2, end, (Processor<FoldRegionImpl>)((Processor)region -> {
            int rStart = region.getStartOffset();
            int rEnd = region.getEndOffset();
            if (rStart < start2) {
                if (region.isValid() && start2 < rEnd && rEnd < end) {
                    return false;
                }
            } else if (rStart == start2) {
                if (rEnd == end) {
                    return false;
                }
            } else {
                if (rStart > end) {
                    return true;
                }
                if (region.isValid() && rStart < end && end < rEnd) {
                    return false;
                }
            }
            return true;
        }));
    }

    private CachedData ensureAvailableData() {
        CachedData cachedData = this.myCachedData;
        if (!cachedData.isAvailable()) {
            return this.rebuild();
        }
        return cachedData;
    }

    @Nullable
    FoldRegion fetchOutermost(int offset) {
        if (!this.isFoldingEnabled()) {
            return null;
        }
        CachedData cachedData = this.ensureAvailableData();
        int[] starts = cachedData.topStartOffsets;
        int[] ends = cachedData.topEndOffsets;
        if (starts == null || ends == null) {
            return null;
        }
        int i = ObjectUtils.binarySearch((int)0, (int)ends.length, mid -> ends[mid] < offset ? -1 : (starts[mid] > offset ? 1 : 0));
        return i < 0 ? null : cachedData.topLevelRegions[i];
    }

    @Nullable
    FoldRegion[] fetchVisible() {
        if (!this.isFoldingEnabled()) {
            return null;
        }
        CachedData cachedData = this.ensureAvailableData();
        return cachedData.visibleRegions;
    }

    @Nullable
    FoldRegion[] fetchTopLevel() {
        if (!this.isFoldingEnabled()) {
            return null;
        }
        CachedData cachedData = this.ensureAvailableData();
        return cachedData.topLevelRegions;
    }

    static boolean containsStrict(FoldRegion region, int offset) {
        return region.getStartOffset() < offset && offset < region.getEndOffset();
    }

    @NotNull
    FoldRegion[] fetchCollapsedAt(int offset) {
        if (!this.isFoldingEnabled()) {
            return FoldRegion.EMPTY_ARRAY;
        }
        ArrayList<FoldRegion> allCollapsed = new ArrayList<FoldRegion>();
        this.myMarkerTree.processContaining(offset, (Processor<FoldRegionImpl>)((Processor)region -> {
            if (!region.isExpanded() && FoldRegionsTree.containsStrict(region, offset)) {
                allCollapsed.add((FoldRegion)region);
            }
            return true;
        }));
        return FoldRegionsTree.toFoldArray(allCollapsed);
    }

    boolean intersectsRegion(int startOffset, int endOffset) {
        if (!this.isFoldingEnabled()) {
            return true;
        }
        return !this.myMarkerTree.processAll((Processor<FoldRegionImpl>)((Processor)region -> {
            boolean contains2;
            boolean contains1 = FoldRegionsTree.containsStrict(region, startOffset);
            return contains1 == (contains2 = FoldRegionsTree.containsStrict(region, endOffset));
        }));
    }

    @NotNull
    FoldRegion[] fetchAllRegions() {
        if (!this.isFoldingEnabled()) {
            return FoldRegion.EMPTY_ARRAY;
        }
        ArrayList<FoldRegion> regions = new ArrayList<FoldRegion>();
        this.myMarkerTree.processOverlappingWith(0, Integer.MAX_VALUE, (Processor<FoldRegionImpl>)new CommonProcessors.CollectProcessor(regions));
        return FoldRegionsTree.toFoldArray(regions);
    }

    private void forEach(@NotNull Consumer<? super FoldRegion> consumer) {
        this.myMarkerTree.processAll((Processor<FoldRegionImpl>)((Processor)region -> {
            consumer.consume(region);
            return true;
        }));
    }

    int getFoldedLinesCountBefore(int offset) {
        if (!this.isFoldingEnabled()) {
            return 0;
        }
        CachedData cachedData = this.ensureAvailableData();
        int idx = FoldRegionsTree.getLastTopLevelIndexBefore(cachedData, offset);
        if (idx == -1) {
            return 0;
        }
        assert (cachedData.topFoldedLines != null);
        return cachedData.topFoldedLines[idx];
    }

    int getTotalNumberOfFoldedLines() {
        if (!this.isFoldingEnabled()) {
            return 0;
        }
        CachedData cachedData = this.ensureAvailableData();
        int[] foldedLines = cachedData.topFoldedLines;
        if (foldedLines == null || foldedLines.length == 0) {
            return 0;
        }
        return foldedLines[foldedLines.length - 1];
    }

    int getHeightOfFoldedBlockInlaysBefore(int offset) {
        if (!this.isFoldingEnabled()) {
            return 0;
        }
        CachedData cachedData = this.ensureAvailableData();
        int idx = FoldRegionsTree.getLastTopLevelIndexBefore(cachedData, offset);
        if (idx == -1) {
            return 0;
        }
        cachedData.ensureInlayDataAvailable();
        return cachedData.topFoldedInlaysHeight[idx];
    }

    int getTotalHeightOfFoldedBlockInlays() {
        if (!this.isFoldingEnabled()) {
            return 0;
        }
        CachedData cachedData = this.ensureAvailableData();
        cachedData.ensureInlayDataAvailable();
        int[] foldedInlaysHeight = cachedData.topFoldedInlaysHeight;
        return foldedInlaysHeight.length == 0 ? 0 : foldedInlaysHeight[foldedInlaysHeight.length - 1];
    }

    int getLastTopLevelIndexBefore(int offset) {
        if (!this.isFoldingEnabled()) {
            return -1;
        }
        CachedData cachedData = this.ensureAvailableData();
        return FoldRegionsTree.getLastTopLevelIndexBefore(cachedData, offset);
    }

    private static int getLastTopLevelIndexBefore(CachedData cachedData, int offset) {
        int i;
        int[] endOffsets = cachedData.topEndOffsets;
        if (endOffsets == null) {
            return -1;
        }
        return (i = Arrays.binarySearch(endOffsets, --offset)) < 0 ? -i - 2 : i;
    }

    @Nullable
    FoldRegion getRegionAt(int startOffset, int endOffset) {
        FoldRegionImpl[] found = new FoldRegionImpl[]{null};
        this.myMarkerTree.processOverlappingWith(startOffset, endOffset, (Processor<FoldRegionImpl>)((Processor)region -> {
            if (region.getStartOffset() == startOffset && region.getEndOffset() == endOffset) {
                found[0] = region;
                return false;
            }
            return true;
        }));
        return found[0];
    }

    void clearDocumentRangesModificationStatus() {
        this.forEach((Consumer<? super FoldRegion>)((Consumer)region -> ((FoldRegionImpl)region).resetDocumentRegionChanged()));
    }

    private class CachedData {
        private final FoldRegion[] visibleRegions;
        private final FoldRegion[] topLevelRegions;
        private final int[] topStartOffsets;
        private final int[] topEndOffsets;
        private final int[] topFoldedLines;
        private int[] topFoldedInlaysHeight;
        private boolean topFoldedInlaysHeightValid;

        private CachedData() {
            this.visibleRegions = null;
            this.topLevelRegions = null;
            this.topStartOffsets = null;
            this.topEndOffsets = null;
            this.topFoldedLines = null;
        }

        private CachedData(@NotNull FoldRegion[] visibleRegions, @NotNull FoldRegion[] topLevelRegions, @NotNull int[] topStartOffsets, @NotNull int[] topEndOffsets, int[] topFoldedLines) {
            this.visibleRegions = visibleRegions;
            this.topLevelRegions = topLevelRegions;
            this.topStartOffsets = topStartOffsets;
            this.topEndOffsets = topEndOffsets;
            this.topFoldedLines = topFoldedLines;
            this.ensureInlayDataAvailable();
        }

        private boolean isAvailable() {
            return this.visibleRegions != null;
        }

        private void ensureInlayDataAvailable() {
            if (this.topFoldedInlaysHeightValid) {
                return;
            }
            this.topFoldedInlaysHeightValid = true;
            if (FoldRegionsTree.this.hasBlockInlays()) {
                int count = this.topLevelRegions.length;
                this.topFoldedInlaysHeight = ArrayUtil.newIntArray((int)count);
                int inlaysHeightSum = 0;
                for (int i = 0; i < count; ++i) {
                    this.topFoldedInlaysHeight[i] = inlaysHeightSum += FoldRegionsTree.this.getBlockInlaysHeight(this.topStartOffsets[i], this.topEndOffsets[i]);
                }
            } else {
                this.topFoldedInlaysHeight = null;
            }
        }
    }
}

