/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.diagnostic.Dumpable;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingGroup;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.FoldingListener;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.editor.ex.PrioritizedInternalDocumentListener;
import com.intellij.openapi.editor.ex.ScrollingModelEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.CaretImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.FoldRegionImpl;
import com.intellij.openapi.editor.impl.FoldRegionsTree;
import com.intellij.openapi.editor.impl.HardReferencingRangeMarkerTree;
import com.intellij.openapi.editor.impl.IntervalTreeImpl;
import com.intellij.openapi.editor.impl.RangeMarkerTree;
import com.intellij.openapi.editor.impl.ScrollingModelImpl;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.util.DocumentUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashSet;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FoldingModelImpl
extends InlayModel.SimpleAdapter
implements FoldingModelEx,
PrioritizedInternalDocumentListener,
Dumpable,
ModificationTracker {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.editor.impl.EditorFoldingModelImpl");
    public static final Key<Boolean> SELECT_REGION_ON_CARET_NEARBY = Key.create((String)"select.region.on.caret.nearby");
    private static final Key<SavedCaretPosition> SAVED_CARET_POSITION = Key.create((String)"saved.position.before.folding");
    private static final Key<Boolean> MARK_FOR_UPDATE = Key.create((String)"marked.for.position.update");
    private final List<FoldingListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private boolean myIsFoldingEnabled;
    private final EditorImpl myEditor;
    private final RangeMarkerTree<FoldRegionImpl> myRegionTree;
    private final FoldRegionsTree myFoldTree;
    private TextAttributes myFoldTextAttributes;
    private boolean myIsBatchFoldingProcessing;
    private boolean myDoNotCollapseCaret;
    private boolean myFoldRegionsProcessed;
    private int mySavedCaretShift;
    private final MultiMap<FoldingGroup, FoldRegion> myGroups = new MultiMap();
    private boolean myDocumentChangeProcessed = true;
    private final AtomicLong myExpansionCounter = new AtomicLong();

    FoldingModelImpl(@NotNull EditorImpl editor) {
        this.myEditor = editor;
        this.myIsFoldingEnabled = true;
        this.myIsBatchFoldingProcessing = false;
        this.myDoNotCollapseCaret = false;
        this.myRegionTree = new MyMarkerTree(editor.getDocument());
        this.myFoldTree = new FoldRegionsTree(this.myRegionTree){

            @Override
            protected boolean isFoldingEnabled() {
                return FoldingModelImpl.this.isFoldingEnabled();
            }

            @Override
            protected boolean hasBlockInlays() {
                return FoldingModelImpl.this.myEditor.getInlayModel().hasBlockElements();
            }

            @Override
            protected int getBlockInlaysHeight(int startOffset, int endOffset) {
                return EditorUtil.getTotalInlaysHeight(FoldingModelImpl.this.myEditor.getInlayModel().getBlockElementsInRange(startOffset, endOffset));
            }
        };
        this.myFoldRegionsProcessed = false;
        this.refreshSettings();
    }

    @Override
    @NotNull
    public List<FoldRegion> getGroupedRegions(@NotNull FoldingGroup group) {
        return (List)this.myGroups.get((Object)group);
    }

    @Override
    public void clearDocumentRangesModificationStatus() {
        FoldingModelImpl.assertIsDispatchThreadForEditor();
        this.myFoldTree.clearDocumentRangesModificationStatus();
    }

    @Override
    public boolean hasDocumentRegionChangedFor(@NotNull FoldRegion region) {
        FoldingModelImpl.assertReadAccess();
        return region instanceof FoldRegionImpl && ((FoldRegionImpl)region).hasDocumentRegionChanged();
    }

    public int getEndOffset(@NotNull FoldingGroup group) {
        List<FoldRegion> regions = this.getGroupedRegions(group);
        int endOffset = 0;
        for (FoldRegion region : regions) {
            if (!region.isValid()) continue;
            endOffset = Math.max(endOffset, region.getEndOffset());
        }
        return endOffset;
    }

    void refreshSettings() {
        this.myFoldTextAttributes = this.myEditor.getColorsScheme().getAttributes(EditorColors.FOLDED_TEXT_ATTRIBUTES);
    }

    @Override
    public boolean isFoldingEnabled() {
        return this.myIsFoldingEnabled;
    }

    public boolean isOffsetCollapsed(int offset) {
        FoldingModelImpl.assertReadAccess();
        return this.getCollapsedRegionAtOffset(offset) != null;
    }

    private boolean isOffsetInsideCollapsedRegion(int offset) {
        FoldingModelImpl.assertReadAccess();
        FoldRegion region = this.getCollapsedRegionAtOffset(offset);
        return region != null && region.getStartOffset() < offset;
    }

    private static void assertIsDispatchThreadForEditor() {
        ApplicationManager.getApplication().assertIsDispatchThread();
    }

    private static void assertReadAccess() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
    }

    private static void assertOurRegion(FoldRegion region) {
        if (!(region instanceof FoldRegionImpl)) {
            throw new IllegalArgumentException("Only regions created by this instance of FoldingModel are accepted");
        }
    }

    @Override
    public void setFoldingEnabled(boolean isEnabled) {
        FoldingModelImpl.assertIsDispatchThreadForEditor();
        this.myIsFoldingEnabled = isEnabled;
    }

    public FoldRegion addFoldRegion(int startOffset, int endOffset, @NotNull String placeholderText) {
        return this.createFoldRegion(startOffset, endOffset, placeholderText, null, false);
    }

    public void runBatchFoldingOperation(@NotNull Runnable operation) {
        this.runBatchFoldingOperation(operation, false, true);
    }

    public void runBatchFoldingOperation(@NotNull Runnable operation, boolean moveCaret) {
        this.runBatchFoldingOperation(operation, false, moveCaret);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runBatchFoldingOperation(@NotNull Runnable operation, boolean dontCollapseCaret, boolean moveCaret) {
        FoldingModelImpl.assertIsDispatchThreadForEditor();
        boolean oldDontCollapseCaret = this.myDoNotCollapseCaret;
        this.myDoNotCollapseCaret |= dontCollapseCaret;
        boolean oldBatchFlag = this.myIsBatchFoldingProcessing;
        if (!oldBatchFlag) {
            ((ScrollingModelImpl)this.myEditor.getScrollingModel()).finishAnimation();
            this.mySavedCaretShift = this.myEditor.visualLineToY(this.myEditor.getCaretModel().getVisualPosition().line) - this.myEditor.getScrollingModel().getVerticalScrollOffset();
        }
        this.myIsBatchFoldingProcessing = true;
        try {
            operation.run();
        }
        finally {
            if (!oldBatchFlag) {
                this.myIsBatchFoldingProcessing = false;
                if (this.myFoldRegionsProcessed) {
                    this.notifyBatchFoldingProcessingDone(moveCaret);
                    this.myFoldRegionsProcessed = false;
                }
            }
            this.myDoNotCollapseCaret = oldDontCollapseCaret;
        }
    }

    public void runBatchFoldingOperationDoNotCollapseCaret(@NotNull Runnable operation) {
        this.runBatchFoldingOperation(operation, true, true);
    }

    void flushCaretShift() {
        this.mySavedCaretShift = -1;
    }

    @NotNull
    public FoldRegion[] getAllFoldRegions() {
        FoldingModelImpl.assertReadAccess();
        return this.myFoldTree.fetchAllRegions();
    }

    @Nullable
    public FoldRegion getCollapsedRegionAtOffset(int offset) {
        return this.myFoldTree.fetchOutermost(offset);
    }

    @Nullable
    public FoldRegion getFoldRegion(int startOffset, int endOffset) {
        FoldingModelImpl.assertReadAccess();
        return this.myFoldTree.getRegionAt(startOffset, endOffset);
    }

    @Override
    @Nullable
    public FoldRegion getFoldingPlaceholderAt(@NotNull Point p) {
        FoldingModelImpl.assertReadAccess();
        LogicalPosition pos = this.myEditor.xyToLogicalPosition(p);
        int line = pos.line;
        if (line >= this.myEditor.getDocument().getLineCount()) {
            return null;
        }
        int offset = this.myEditor.logicalPositionToOffset(pos);
        return this.myFoldTree.fetchOutermost(offset);
    }

    public void removeFoldRegion(@NotNull FoldRegion region) {
        FoldingModelImpl.assertIsDispatchThreadForEditor();
        FoldingModelImpl.assertOurRegion(region);
        if (!this.myIsBatchFoldingProcessing) {
            LOG.error("Fold regions must be added or removed inside batchFoldProcessing() only.");
        }
        ((FoldRegionImpl)region).setExpanded(true, false);
        this.notifyListenersOnFoldRegionStateChange(region);
        this.notifyListenersOnFoldRegionRemove(region);
        this.myFoldRegionsProcessed = true;
        region.dispose();
    }

    void removeRegionFromTree(@NotNull FoldRegionImpl region) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!this.myEditor.getFoldingModel().isInBatchFoldingOperation()) {
            LOG.error("Fold regions must be added or removed inside batchFoldProcessing() only.");
        }
        this.myFoldRegionsProcessed = true;
        this.myRegionTree.removeInterval(region);
        this.removeRegionFromGroup(region);
    }

    void removeRegionFromGroup(@NotNull FoldRegion region) {
        this.myGroups.remove((Object)region.getGroup(), (Object)region);
    }

    void dispose() {
        this.doClearFoldRegions();
        this.myRegionTree.dispose(this.myEditor.getDocument());
    }

    @Override
    public void clearFoldRegions() {
        FoldRegion[] regions;
        if (!this.myIsBatchFoldingProcessing) {
            LOG.error("Fold regions must be added or removed inside batchFoldProcessing() only.");
            return;
        }
        for (FoldRegion region : regions = this.getAllFoldRegions()) {
            if (!region.isExpanded()) {
                this.notifyListenersOnFoldRegionStateChange(region);
            }
            this.notifyListenersOnFoldRegionRemove(region);
            region.dispose();
        }
        this.doClearFoldRegions();
    }

    private void doClearFoldRegions() {
        this.myGroups.clear();
        this.myFoldTree.clear();
    }

    void expandFoldRegion(@NotNull FoldRegion region, boolean notify) {
        FoldingModelImpl.assertIsDispatchThreadForEditor();
        if (region.isExpanded() || region.shouldNeverExpand()) {
            return;
        }
        if (!this.myIsBatchFoldingProcessing) {
            LOG.error("Fold regions must be collapsed or expanded inside batchFoldProcessing() only.");
        }
        for (Caret caret : this.myEditor.getCaretModel().getAllCarets()) {
            int savedOffset;
            FoldRegion[] allCollapsed;
            SavedCaretPosition savedPosition = (SavedCaretPosition)caret.getUserData(SAVED_CARET_POSITION);
            if (savedPosition == null || !savedPosition.isUpToDate(this.myEditor) || (allCollapsed = this.myFoldTree.fetchCollapsedAt(savedOffset = this.myEditor.logicalPositionToOffset(savedPosition.position))).length != 1 || allCollapsed[0] != region) continue;
            caret.putUserData(MARK_FOR_UPDATE, (Object)Boolean.TRUE);
        }
        this.myFoldRegionsProcessed = true;
        this.myExpansionCounter.incrementAndGet();
        ((FoldRegionImpl)region).setExpandedInternal(true);
        if (notify) {
            this.notifyListenersOnFoldRegionStateChange(region);
        }
    }

    void collapseFoldRegion(@NotNull FoldRegion region, boolean notify) {
        FoldingModelImpl.assertIsDispatchThreadForEditor();
        if (!region.isExpanded()) {
            return;
        }
        if (!this.myIsBatchFoldingProcessing) {
            LOG.error("Fold regions must be collapsed or expanded inside batchFoldProcessing() only.");
        }
        List<Caret> carets = this.myEditor.getCaretModel().getAllCarets();
        if (this.myDoNotCollapseCaret) {
            for (Caret caret : carets) {
                LogicalPosition caretPosition = caret.getLogicalPosition();
                int caretOffset = this.myEditor.logicalPositionToOffset(caretPosition);
                if (!FoldRegionsTree.containsStrict(region, caretOffset)) continue;
                return;
            }
        }
        for (Caret caret : carets) {
            SavedCaretPosition savedPosition;
            int caretOffset = caret.getOffset();
            if (!FoldRegionsTree.containsStrict(region, caretOffset) || (savedPosition = (SavedCaretPosition)caret.getUserData(SAVED_CARET_POSITION)) != null && savedPosition.isUpToDate(this.myEditor)) continue;
            caret.putUserData(SAVED_CARET_POSITION, (Object)new SavedCaretPosition(caret));
        }
        this.myFoldRegionsProcessed = true;
        ((FoldRegionImpl)region).setExpandedInternal(false);
        if (notify) {
            this.notifyListenersOnFoldRegionStateChange(region);
        }
    }

    private void notifyBatchFoldingProcessingDone(boolean moveCaretFromCollapsedRegion) {
        this.clearCachedValues();
        for (FoldingListener listener2 : this.myListeners) {
            listener2.onFoldProcessingEnd();
        }
        this.myEditor.updateCaretCursor();
        this.myEditor.recalculateSizeAndRepaint();
        this.myEditor.getGutterComponentEx().updateSize();
        this.myEditor.getGutterComponentEx().repaint();
        this.myEditor.invokeDelayedErrorStripeRepaint();
        for (Caret caret : this.myEditor.getCaretModel().getAllCarets()) {
            boolean markedForUpdate;
            LogicalPosition caretPosition = caret.getLogicalPosition();
            int caretOffset = this.myEditor.logicalPositionToOffset(caretPosition);
            int selectionStart = caret.getSelectionStart();
            int selectionEnd = caret.getSelectionEnd();
            LogicalPosition positionToUse = null;
            int offsetToUse = -1;
            FoldRegion collapsed = this.myFoldTree.fetchOutermost(caretOffset);
            SavedCaretPosition savedPosition = (SavedCaretPosition)caret.getUserData(SAVED_CARET_POSITION);
            boolean bl = markedForUpdate = caret.getUserData(MARK_FOR_UPDATE) != null;
            if (savedPosition != null && savedPosition.isUpToDate(this.myEditor)) {
                int savedOffset = this.myEditor.logicalPositionToOffset(savedPosition.position);
                FoldRegion collapsedAtSaved = this.myFoldTree.fetchOutermost(savedOffset);
                if (collapsedAtSaved == null) {
                    positionToUse = savedPosition.position;
                } else {
                    offsetToUse = collapsedAtSaved.getStartOffset();
                }
            }
            if (collapsed != null && positionToUse == null) {
                positionToUse = this.myEditor.offsetToLogicalPosition(collapsed.getStartOffset());
            }
            if ((markedForUpdate || moveCaretFromCollapsedRegion) && caret.isUpToDate()) {
                if (offsetToUse >= 0) {
                    caret.moveToOffset(offsetToUse);
                } else if (positionToUse != null) {
                    caret.moveToLogicalPosition(positionToUse);
                } else {
                    ((CaretImpl)caret).updateVisualPosition();
                }
            }
            caret.putUserData(SAVED_CARET_POSITION, (Object)savedPosition);
            caret.putUserData(MARK_FOR_UPDATE, null);
            if (this.isOffsetInsideCollapsedRegion(selectionStart) || this.isOffsetInsideCollapsedRegion(selectionEnd)) {
                caret.removeSelection();
                continue;
            }
            if (selectionStart >= this.myEditor.getDocument().getTextLength()) continue;
            caret.setSelection(selectionStart, selectionEnd);
        }
        if (this.mySavedCaretShift > 0) {
            ScrollingModelEx scrollingModel = this.myEditor.getScrollingModel();
            scrollingModel.disableAnimation();
            scrollingModel.scrollVertically(this.myEditor.visualLineToY(this.myEditor.getCaretModel().getVisualPosition().line) - this.mySavedCaretShift);
            scrollingModel.enableAnimation();
        }
    }

    @Override
    public void rebuild() {
        if (!this.myEditor.getDocument().isInBulkUpdate()) {
            this.myFoldTree.rebuild();
        }
    }

    public boolean isInBatchFoldingOperation() {
        return this.myIsBatchFoldingProcessing;
    }

    private void updateCachedOffsets() {
        this.myFoldTree.updateCachedOffsets();
    }

    public int getFoldedLinesCountBefore(int offset) {
        if (!this.myDocumentChangeProcessed && this.myEditor.getDocument().isInEventsHandling()) {
            return 0;
        }
        return this.myFoldTree.getFoldedLinesCountBefore(offset);
    }

    int getTotalNumberOfFoldedLines() {
        if (!this.myDocumentChangeProcessed && this.myEditor.getDocument().isInEventsHandling()) {
            return 0;
        }
        return this.myFoldTree.getTotalNumberOfFoldedLines();
    }

    int getHeightOfFoldedBlockInlaysBefore(int offset) {
        return this.myFoldTree.getHeightOfFoldedBlockInlaysBefore(offset);
    }

    int getTotalHeightOfFoldedBlockInlays() {
        return this.myFoldTree.getTotalHeightOfFoldedBlockInlays();
    }

    @Override
    @Nullable
    public FoldRegion[] fetchTopLevel() {
        return this.myFoldTree.fetchTopLevel();
    }

    @NotNull
    FoldRegion[] fetchCollapsedAt(int offset) {
        return this.myFoldTree.fetchCollapsedAt(offset);
    }

    @Override
    public boolean intersectsRegion(int startOffset, int endOffset) {
        return this.myFoldTree.intersectsRegion(startOffset, endOffset);
    }

    @Nullable
    FoldRegion[] fetchVisible() {
        return this.myFoldTree.fetchVisible();
    }

    @Override
    public int getLastCollapsedRegionBefore(int offset) {
        return this.myFoldTree.getLastTopLevelIndexBefore(offset);
    }

    @Override
    public TextAttributes getPlaceholderAttributes() {
        return this.myFoldTextAttributes;
    }

    void flushCaretPosition(@NotNull Caret caret) {
        caret.putUserData(SAVED_CARET_POSITION, null);
    }

    void onBulkDocumentUpdateStarted() {
        this.clearCachedValues();
    }

    void clearCachedValues() {
        this.myFoldTree.clearCachedValues();
    }

    void onBulkDocumentUpdateFinished() {
        this.myFoldTree.rebuild();
    }

    public void beforeDocumentChange(@NotNull DocumentEvent event) {
        if (this.myIsBatchFoldingProcessing) {
            LOG.error("Document changes are not allowed during batch folding update");
        }
        this.myDocumentChangeProcessed = false;
    }

    public void documentChanged(@NotNull DocumentEvent event) {
        try {
            if (!((DocumentEx)event.getDocument()).isInBulkUpdate()) {
                this.updateCachedOffsets();
            }
        }
        finally {
            this.myDocumentChangeProcessed = true;
        }
    }

    @Override
    public void moveTextHappened(@NotNull Document document, int start2, int end, int base) {
        if (!this.myEditor.getDocument().isInBulkUpdate()) {
            this.myFoldTree.rebuild();
        }
    }

    @Override
    public int getPriority() {
        return 60;
    }

    public void onUpdated(@NotNull Inlay inlay) {
        Inlay.Placement placement = inlay.getPlacement();
        if (placement == Inlay.Placement.ABOVE_LINE || placement == Inlay.Placement.BELOW_LINE) {
            this.myFoldTree.clearCachedInlayValues();
        }
    }

    @Override
    @Nullable
    public FoldRegion createFoldRegion(int startOffset, int endOffset, @NotNull String placeholder, @Nullable FoldingGroup group, boolean neverExpands) {
        FoldingModelImpl.assertIsDispatchThreadForEditor();
        if (!this.myIsBatchFoldingProcessing) {
            LOG.error("Fold regions must be added or removed inside batchFoldProcessing() only.");
            return null;
        }
        if (!this.isFoldingEnabled() || startOffset >= endOffset || DocumentUtil.isInsideSurrogatePair(this.myEditor.getDocument(), startOffset) || DocumentUtil.isInsideSurrogatePair(this.myEditor.getDocument(), endOffset) || !this.myFoldTree.checkIfValidToCreate(startOffset, endOffset)) {
            return null;
        }
        FoldRegionImpl region = new FoldRegionImpl(this.myEditor, startOffset, endOffset, placeholder, group, neverExpands);
        this.myRegionTree.addInterval(region, startOffset, endOffset, false, false, false, 0);
        LOG.assertTrue(region.isValid());
        this.myFoldRegionsProcessed = true;
        if (group != null) {
            this.myGroups.putValue((Object)group, (Object)region);
        }
        this.notifyListenersOnFoldRegionStateChange(region);
        LOG.assertTrue(region.isValid());
        return region;
    }

    @Override
    public void addListener(@NotNull FoldingListener listener2, @NotNull Disposable parentDisposable) {
        this.myListeners.add(listener2);
        Disposer.register((Disposable)parentDisposable, () -> this.myListeners.remove(listener2));
    }

    private void notifyListenersOnFoldRegionStateChange(@NotNull FoldRegion foldRegion) {
        for (FoldingListener listener2 : this.myListeners) {
            listener2.onFoldRegionStateChange(foldRegion);
        }
    }

    private void notifyListenersOnFoldRegionRemove(@NotNull FoldRegion foldRegion) {
        for (FoldingListener listener2 : this.myListeners) {
            listener2.beforeFoldRegionRemoved(foldRegion);
        }
    }

    @NotNull
    public String dumpState() {
        return Arrays.toString(this.myFoldTree.fetchTopLevel());
    }

    public String toString() {
        return this.dumpState();
    }

    public long getModificationCount() {
        return this.myExpansionCounter.get();
    }

    void validateState() {
        FoldRegion[] actualTopLevels;
        if (this.myEditor.getDocument().isInBulkUpdate()) {
            return;
        }
        FoldRegion[] allFoldRegions = this.getAllFoldRegions();
        boolean[] invisibleRegions = new boolean[allFoldRegions.length];
        for (int i = 0; i < allFoldRegions.length; ++i) {
            FoldRegion r1 = allFoldRegions[i];
            LOG.assertTrue(r1.isValid() && !DocumentUtil.isInsideSurrogatePair(this.myEditor.getDocument(), r1.getStartOffset()) && !DocumentUtil.isInsideSurrogatePair(this.myEditor.getDocument(), r1.getEndOffset()), (Object)"Invalid region");
            for (int j = i + 1; j < allFoldRegions.length; ++j) {
                FoldRegion r2 = allFoldRegions[j];
                int r1s = r1.getStartOffset();
                int r1e = r1.getEndOffset();
                int r2s = r2.getStartOffset();
                int r2e = r2.getEndOffset();
                LOG.assertTrue(r1s < r2s && (r1e <= r2s || r1e >= r2e) || r1s == r2s && r1e != r2e || r1s > r2s && r1s < r2e && r1e <= r2e || r1s >= r2e, (Object)"Disallowed relative position of regions");
                if (!r1.isExpanded() && r1s <= r2s && r1e >= r2e) {
                    invisibleRegions[j] = true;
                }
                if (r2.isExpanded() || r2s > r1s || r2e < r1e) continue;
                invisibleRegions[i] = true;
            }
        }
        THashSet visibleRegions = new THashSet(FoldRegionsTree.OFFSET_BASED_HASHING_STRATEGY);
        ArrayList<FoldRegion[]> topLevelRegions = new ArrayList<FoldRegion[]>();
        for (int i = 0; i < allFoldRegions.length; ++i) {
            if (invisibleRegions[i]) continue;
            FoldRegion[] region = allFoldRegions[i];
            LOG.assertTrue(visibleRegions.add(region), (Object)"Duplicate visible regions");
            if (region.isExpanded()) continue;
            topLevelRegions.add(region);
        }
        Collections.sort(topLevelRegions, Comparator.comparingInt(r -> r.getStartOffset()));
        FoldRegion[] actualVisibles = this.fetchVisible();
        if (actualVisibles != null) {
            for (FoldRegion r2 : actualVisibles) {
                LOG.assertTrue(visibleRegions.remove(r2), (Object)"Unexpected visible region");
            }
            LOG.assertTrue(visibleRegions.isEmpty(), (Object)"Missing visible region");
        }
        if ((actualTopLevels = this.fetchTopLevel()) != null) {
            LOG.assertTrue(actualTopLevels.length == topLevelRegions.size(), (Object)"Wrong number of top-level regions");
            for (int i = 0; i < actualTopLevels.length; ++i) {
                LOG.assertTrue(FoldRegionsTree.OFFSET_BASED_HASHING_STRATEGY.equals((Object)actualTopLevels[i], topLevelRegions.get(i)), (Object)"Unexpected top-level region");
            }
        }
    }

    private class MyMarkerTree
    extends HardReferencingRangeMarkerTree<FoldRegionImpl> {
        private boolean inCollectCall;

        private MyMarkerTree(Document document) {
            super(document);
        }

        @NotNull
        private FoldRegionImpl getRegion(@NotNull IntervalTreeImpl.IntervalNode<FoldRegionImpl> node) {
            assert (node.intervals.size() == 1);
            FoldRegionImpl region = (FoldRegionImpl)node.intervals.get(0).get();
            assert (region != null);
            return region;
        }

        @Override
        @NotNull
        protected HardReferencingRangeMarkerTree.Node<FoldRegionImpl> createNewNode(@NotNull FoldRegionImpl key, int start2, int end, boolean greedyToLeft, boolean greedyToRight, boolean stickingToRight, int layer) {
            return new HardReferencingRangeMarkerTree.Node<FoldRegionImpl>((RangeMarkerTree)this, key, start2, end, greedyToLeft, greedyToRight, stickingToRight){

                @Override
                void onRemoved() {
                    for (Getter getter : this.intervals) {
                        FoldingModelImpl.this.removeRegionFromGroup((FoldRegion)getter.get());
                    }
                }

                @Override
                void addIntervalsFrom(@NotNull IntervalTreeImpl.IntervalNode<FoldRegionImpl> otherNode) {
                    FoldRegionImpl region = MyMarkerTree.this.getRegion(this);
                    FoldRegionImpl otherRegion = MyMarkerTree.this.getRegion(otherNode);
                    if (otherRegion.mySizeBeforeUpdate > region.mySizeBeforeUpdate) {
                        MyMarkerTree.this.setNode(region, null);
                        this.removeIntervalInternal(0);
                        super.addIntervalsFrom(otherNode);
                    } else {
                        otherNode.setValid(false);
                        ((RangeMarkerTree.RMNode)otherNode).onRemoved();
                    }
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        boolean collectAffectedMarkersAndShiftSubtrees(@Nullable IntervalTreeImpl.IntervalNode<FoldRegionImpl> root, @NotNull DocumentEvent e, @NotNull List<? super IntervalTreeImpl.IntervalNode<FoldRegionImpl>> affected) {
            void result2;
            if (this.inCollectCall) {
                return super.collectAffectedMarkersAndShiftSubtrees(root, e, affected);
            }
            this.inCollectCall = true;
            try {
                boolean result22 = super.collectAffectedMarkersAndShiftSubtrees(root, e, affected);
            }
            finally {
                this.inCollectCall = false;
            }
            if (e.getOldLength() > 0) {
                for (IntervalTreeImpl.IntervalNode<FoldRegionImpl> intervalNode : affected) {
                    HardReferencingRangeMarkerTree.Node node = (HardReferencingRangeMarkerTree.Node)intervalNode;
                    FoldRegionImpl region = this.getRegion(node);
                    region.mySizeBeforeUpdate = region.isExpanded() ? 0 : node.intervalEnd() - node.intervalStart();
                }
            }
            return (boolean)result2;
        }
    }

    private static class SavedCaretPosition {
        private final LogicalPosition position;
        private final long docStamp;

        private SavedCaretPosition(Caret caret) {
            this.position = caret.getLogicalPosition();
            this.docStamp = caret.getEditor().getDocument().getModificationStamp();
        }

        private boolean isUpToDate(Editor editor) {
            return this.docStamp == editor.getDocument().getModificationStamp();
        }
    }
}

