/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.Patches;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.impl.ComplementaryFontsRegistry;
import com.intellij.openapi.editor.impl.view.FontLayoutService;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TIntHashSet;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.font.FontDesignMetrics;

public class FontInfo {
    private static final Logger LOG = Logger.getInstance(FontInfo.class);
    private static final boolean USE_ALTERNATIVE_CAN_DISPLAY_PROCEDURE = Registry.is((String)"ide.mac.fix.font.fallback");
    private static final FontRenderContext DEFAULT_CONTEXT = new FontRenderContext(null, false, false);
    private static final Font DUMMY_FONT = new Font(null);
    private final Font myFont;
    private final int mySize;
    @JdkConstants.FontStyle
    private final int myStyle;
    private final boolean myUseLigatures;
    private final TIntHashSet mySafeCharacters = new TIntHashSet();
    private final FontRenderContext myContext;
    private FontMetrics myFontMetrics = null;
    private static final Comparator<File> BY_NAME = Comparator.comparing(File::getName);

    @Deprecated
    public FontInfo(String familyName, int size, @JdkConstants.FontStyle int style) {
        this(familyName, size, style, style, false, null);
    }

    @Deprecated
    public FontInfo(String familyName, int size, @JdkConstants.FontStyle int style, boolean useLigatures) {
        this(familyName, size, style, useLigatures, null);
    }

    public FontInfo(String familyName, int size, @JdkConstants.FontStyle int style, boolean useLigatures, FontRenderContext fontRenderContext) {
        this(familyName, size, style, style, useLigatures, fontRenderContext);
    }

    FontInfo(String familyName, int size, @JdkConstants.FontStyle int style, @JdkConstants.FontStyle int realStyle, boolean useLigatures, FontRenderContext context) {
        this.mySize = size;
        this.myStyle = style;
        this.myUseLigatures = useLigatures;
        Font font = new Font(familyName, style, size);
        this.myFont = useLigatures ? FontInfo.getFontWithLigaturesEnabled(font, realStyle) : font;
        this.myContext = context;
    }

    @NotNull
    private static Font getFontWithLigaturesEnabled(Font font, @JdkConstants.FontStyle int fontStyle) {
        if (Patches.JDK_BUG_ID_7162125) {
            String familyName = font.getFamily();
            File fontFile = FontInfo.findFileForFont(familyName, fontStyle);
            if (fontFile == null) {
                LOG.info(font + "(style=" + fontStyle + ") not located");
                return font;
            }
            LOG.info(font + "(style=" + fontStyle + ") located at " + fontFile);
            try {
                font = Font.createFont(0, fontFile).deriveFont(fontStyle, font.getSize());
            }
            catch (Exception e) {
                LOG.warn("Couldn't load font", (Throwable)e);
                return font;
            }
        }
        return font.deriveFont(Collections.singletonMap(TextAttribute.LIGATURES, TextAttribute.LIGATURES_ON));
    }

    @Nullable
    private static File findFileForFont(@NotNull String familyName, int style) {
        File fontFile = FontInfo.doFindFileForFont(familyName, style);
        if (fontFile == null && style != 0) {
            fontFile = FontInfo.doFindFileForFont(familyName, 0);
        }
        if (fontFile == null) {
            fontFile = FontInfo.doFindFileForFont(familyName, -1);
        }
        return fontFile;
    }

    @Nullable
    private static File doFindFileForFont(@NotNull String familyName, int style) {
        List regulars;
        File[] localFiles;
        String normalizedFamilyName = familyName.toLowerCase(Locale.getDefault()).replace(" ", "");
        FilenameFilter filter = (file2, name) -> {
            String normalizedName = name.toLowerCase(Locale.getDefault());
            return !(!normalizedName.startsWith(normalizedFamilyName) || !normalizedName.endsWith(".otf") && !normalizedName.endsWith(".ttf") || style != -1 && style != FontInfo.getFontStyle(normalizedName));
        };
        ArrayList<File> files2 = new ArrayList<File>();
        File[] userFiles = new File(System.getProperty("user.home"), "Library/Fonts").listFiles(filter);
        if (userFiles != null) {
            files2.addAll(Arrays.asList(userFiles));
        }
        if ((localFiles = new File("/Library/Fonts").listFiles(filter)) != null) {
            files2.addAll(Arrays.asList(localFiles));
        }
        if (files2.isEmpty()) {
            return null;
        }
        if (style == 0 && !(regulars = ContainerUtil.filter(files2, file2 -> file2.getName().toLowerCase(Locale.getDefault()).contains("regular"))).isEmpty()) {
            return Collections.min(regulars, BY_NAME);
        }
        return Collections.min(files2, BY_NAME);
    }

    private static int getFontStyle(@NotNull String fontFileNameLowercase) {
        String baseName = fontFileNameLowercase.substring(0, fontFileNameLowercase.length() - 4);
        if (baseName.endsWith("-it")) {
            return 2;
        }
        if (baseName.endsWith("-boldit")) {
            return 3;
        }
        return ComplementaryFontsRegistry.getFontStyle(fontFileNameLowercase);
    }

    public boolean canDisplay(int codePoint) {
        try {
            if (codePoint < 128) {
                return true;
            }
            if (this.mySafeCharacters.contains(codePoint)) {
                return true;
            }
            if (this.canDisplayImpl(codePoint)) {
                this.mySafeCharacters.add(codePoint);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean canDisplayImpl(int codePoint) {
        if (!Character.isValidCodePoint(codePoint)) {
            return false;
        }
        if (USE_ALTERNATIVE_CAN_DISPLAY_PROCEDURE) {
            return this.myFont.createGlyphVector(DEFAULT_CONTEXT, new String(new int[]{codePoint}, 0, 1)).getGlyphCode(0) > 0;
        }
        return this.myFont.canDisplay(codePoint);
    }

    public Font getFont() {
        return this.myFont;
    }

    public int charWidth(int codePoint) {
        FontMetrics metrics = this.fontMetrics();
        return FontLayoutService.getInstance().charWidth(metrics, codePoint);
    }

    public float charWidth2D(int codePoint) {
        FontMetrics metrics = this.fontMetrics();
        return FontLayoutService.getInstance().charWidth2D(metrics, codePoint);
    }

    public synchronized FontMetrics fontMetrics() {
        if (this.myFontMetrics == null) {
            this.myFontMetrics = FontInfo.getFontMetrics(this.myFont, this.myContext == null ? FontInfo.getFontRenderContext(null) : this.myContext);
        }
        return this.myFontMetrics;
    }

    @NotNull
    public static FontMetrics getFontMetrics(@NotNull Font font, @NotNull FontRenderContext fontRenderContext) {
        return FontDesignMetrics.getMetrics(font, fontRenderContext);
    }

    public static FontRenderContext getFontRenderContext(Component component) {
        if (component == null) {
            return DEFAULT_CONTEXT;
        }
        return component.getFontMetrics(DUMMY_FONT).getFontRenderContext();
    }

    public int getSize() {
        return this.mySize;
    }

    @JdkConstants.FontStyle
    public int getStyle() {
        return this.myStyle;
    }

    public boolean areLigaturesEnabled() {
        return this.myUseLigatures;
    }

    public FontRenderContext getFontRenderContext() {
        return this.myContext;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FontInfo fontInfo = (FontInfo)o;
        return this.myFont.equals(fontInfo.myFont);
    }

    public int hashCode() {
        return this.myFont.hashCode();
    }
}

