/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditReadOnlyListener;
import com.intellij.openapi.editor.ex.LineIterator;
import com.intellij.openapi.editor.ex.RangeMarkerEx;
import com.intellij.openapi.editor.impl.LineSet;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.reference.SoftReference;
import com.intellij.util.Processor;
import com.intellij.util.text.ImmutableCharSequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FrozenDocument
implements DocumentEx {
    private final ImmutableCharSequence myText;
    @Nullable
    private volatile SoftReference<LineSet> myLineSet;
    private final long myStamp;
    private volatile SoftReference<String> myTextString;

    FrozenDocument(@NotNull ImmutableCharSequence text, @Nullable LineSet lineSet, long stamp, @Nullable String textString) {
        this.myText = text;
        this.myLineSet = lineSet == null ? null : new SoftReference((Object)lineSet);
        this.myStamp = stamp;
        this.myTextString = textString == null ? null : new SoftReference((Object)textString);
    }

    @NotNull
    private LineSet getLineSet() {
        LineSet lineSet = (LineSet)SoftReference.dereference(this.myLineSet);
        if (lineSet == null) {
            lineSet = LineSet.createLineSet((CharSequence)this.myText);
            this.myLineSet = new SoftReference((Object)lineSet);
        }
        return lineSet;
    }

    public FrozenDocument applyEvent(DocumentEvent event, int newStamp) {
        int offset = event.getOffset();
        int oldEnd = offset + event.getOldLength();
        ImmutableCharSequence newText = this.myText.delete(offset, oldEnd).insert(offset, event.getNewFragment());
        LineSet newLineSet = this.getLineSet().update((CharSequence)this.myText, offset, oldEnd, event.getNewFragment(), event.isWholeTextReplaced());
        return new FrozenDocument(newText, newLineSet, newStamp, null);
    }

    @Override
    @NotNull
    public LineIterator createLineIterator() {
        return this.getLineSet().createIterator();
    }

    @Override
    public void setModificationStamp(long modificationStamp) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void replaceText(@NotNull CharSequence chars, long newModificationStamp) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void moveText(int srcStart, int srcEnd, int dstOffset) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clearLineModificationFlags() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeRangeMarker(@NotNull RangeMarkerEx rangeMarker) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void registerRangeMarker(@NotNull RangeMarkerEx rangeMarker, int start2, int end, boolean greedyToLeft, boolean greedyToRight, int layer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean processRangeMarkers(@NotNull Processor<? super RangeMarker> processor2) {
        return true;
    }

    @Override
    public boolean processRangeMarkersOverlappingWith(int start2, int end, @NotNull Processor<? super RangeMarker> processor2) {
        return true;
    }

    @NotNull
    public String getText() {
        String s = (String)SoftReference.dereference(this.myTextString);
        if (s == null) {
            s = this.myText.toString();
            this.myTextString = new SoftReference((Object)s);
        }
        return s;
    }

    @NotNull
    public String getText(@NotNull TextRange range2) {
        return this.myText.subSequence(range2.getStartOffset(), range2.getEndOffset()).toString();
    }

    @NotNull
    public CharSequence getCharsSequence() {
        return this.myText;
    }

    @NotNull
    public CharSequence getImmutableCharSequence() {
        return this.myText;
    }

    public int getLineCount() {
        return this.getLineSet().getLineCount();
    }

    public int getLineNumber(int offset) {
        return this.getLineSet().findLineIndex(offset);
    }

    public int getLineStartOffset(int line) {
        if (line == 0) {
            return 0;
        }
        return this.getLineSet().getLineStart(line);
    }

    public int getLineEndOffset(int line) {
        if (this.getTextLength() == 0 && line == 0) {
            return 0;
        }
        int result2 = this.getLineSet().getLineEnd(line) - this.getLineSeparatorLength(line);
        assert (result2 >= 0);
        return result2;
    }

    public void insertString(int offset, @NotNull CharSequence s) {
        throw new UnsupportedOperationException();
    }

    public void deleteString(int startOffset, int endOffset) {
        throw new UnsupportedOperationException();
    }

    public void replaceString(int startOffset, int endOffset, @NotNull CharSequence s) {
        throw new UnsupportedOperationException();
    }

    public boolean isWritable() {
        return false;
    }

    public long getModificationStamp() {
        return this.myStamp;
    }

    @NotNull
    public RangeMarker createRangeMarker(int startOffset, int endOffset, boolean surviveOnExternalChange) {
        throw new UnsupportedOperationException();
    }

    public void setReadOnly(boolean isReadOnly) {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public RangeMarker createGuardedBlock(int startOffset, int endOffset) {
        throw new UnsupportedOperationException();
    }

    public void removeGuardedBlock(@NotNull RangeMarker block) {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public RangeMarker getOffsetGuard(int offset) {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public RangeMarker getRangeGuard(int start2, int end) {
        throw new UnsupportedOperationException();
    }

    public void startGuardedBlockChecking() {
        throw new UnsupportedOperationException();
    }

    public void stopGuardedBlockChecking() {
        throw new UnsupportedOperationException();
    }

    public void setText(@NotNull CharSequence text) {
        throw new UnsupportedOperationException();
    }

    public int getLineSeparatorLength(int line) {
        return this.getLineSet().getSeparatorLength(line);
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        throw new UnsupportedOperationException();
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setStripTrailingSpacesEnabled(boolean isEnabled) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeEditReadOnlyListener(@NotNull EditReadOnlyListener listener2) {
        throw new UnsupportedOperationException();
    }
}

