/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.impl.BlockInlayImpl;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.RangeMarkerTree;
import com.intellij.openapi.editor.impl.RangeMarkerWithGetterImpl;
import com.intellij.openapi.util.Key;
import java.awt.Point;
import java.awt.Rectangle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class InlayImpl<R extends EditorCustomElementRenderer, T extends InlayImpl>
extends RangeMarkerWithGetterImpl
implements Inlay<R> {
    static final Key<Integer> OFFSET_BEFORE_DISPOSAL = Key.create((String)"inlay.offset.before.disposal");
    @NotNull
    final EditorImpl myEditor;
    @NotNull
    final R myRenderer;
    private final boolean myRelatedToPrecedingText;
    int myWidthInPixels;

    InlayImpl(@NotNull EditorImpl editor, int offset, boolean relatesToPrecedingText, @NotNull R renderer2) {
        super(editor.getDocument(), offset, offset, false);
        this.myEditor = editor;
        this.myRelatedToPrecedingText = relatesToPrecedingText;
        this.myRenderer = renderer2;
        this.doUpdateSize();
        this.getTree().addInterval(this, offset, offset, false, false, relatesToPrecedingText, 0);
    }

    abstract RangeMarkerTree<T> getTree();

    @NotNull
    public Editor getEditor() {
        return this.myEditor;
    }

    public void updateSize() {
        int oldWidth = this.getWidthInPixels();
        int oldHeight = this.getHeightInPixels();
        this.doUpdateSize();
        if (oldWidth != this.getWidthInPixels() || oldHeight != this.getHeightInPixels()) {
            this.myEditor.getInlayModel().notifyChanged(this);
        } else {
            this.repaint();
        }
    }

    public void repaint() {
        Rectangle bounds2;
        EditorComponentImpl contentComponent;
        if (this.isValid() && !this.myEditor.isDisposed() && !this.myEditor.getDocument().isInBulkUpdate() && (contentComponent = this.myEditor.getContentComponent()).isShowing() && (bounds2 = this.getBounds()) != null) {
            if (this instanceof BlockInlayImpl) {
                bounds2.width = contentComponent.getWidth();
            }
            contentComponent.repaint(bounds2);
        }
    }

    abstract void doUpdateSize();

    @Override
    public void dispose() {
        if (this.isValid()) {
            int offset = this.getOffset();
            this.putUserData(OFFSET_BEFORE_DISPOSAL, offset);
            this.getTree().removeInterval(this);
            this.myEditor.getInlayModel().notifyRemoved(this);
        }
    }

    public int getOffset() {
        Integer offsetBeforeDisposal = (Integer)this.getUserData(OFFSET_BEFORE_DISPOSAL);
        return offsetBeforeDisposal == null ? this.getStartOffset() : offsetBeforeDisposal.intValue();
    }

    public boolean isRelatedToPrecedingText() {
        return this.myRelatedToPrecedingText;
    }

    abstract Point getPosition();

    @Nullable
    public Rectangle getBounds() {
        if (this.myEditor.getFoldingModel().isOffsetCollapsed(this.getOffset())) {
            return null;
        }
        Point pos = this.getPosition();
        return new Rectangle(pos.x, pos.y, this.getWidthInPixels(), this.getHeightInPixels());
    }

    @NotNull
    public R getRenderer() {
        return this.myRenderer;
    }

    public int getWidthInPixels() {
        return this.myWidthInPixels;
    }
}

