/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.diagnostic.Dumpable;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.PrioritizedInternalDocumentListener;
import com.intellij.openapi.editor.impl.AfterLineEndInlayImpl;
import com.intellij.openapi.editor.impl.BlockInlayImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.HardReferencingRangeMarkerTree;
import com.intellij.openapi.editor.impl.InlayImpl;
import com.intellij.openapi.editor.impl.InlineInlayImpl;
import com.intellij.openapi.editor.impl.IntervalTreeImpl;
import com.intellij.openapi.editor.impl.MarkerTreeWithPartialSums;
import com.intellij.openapi.editor.impl.RangeMarkerTree;
import com.intellij.util.DocumentUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.List;
import java.util.StringJoiner;
import java.util.function.Predicate;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InlayModelImpl
implements InlayModel,
Disposable,
Dumpable {
    private static final Logger LOG = Logger.getInstance(InlayModelImpl.class);
    private static final Comparator<Inlay> INLINE_ELEMENTS_COMPARATOR = Comparator.comparingInt(i -> i.getOffset()).thenComparing(i -> i.isRelatedToPrecedingText());
    private static final Comparator<BlockInlayImpl> BLOCK_ELEMENTS_PRIORITY_COMPARATOR = Comparator.comparingInt(i -> -i.myPriority);
    private static final Comparator<BlockInlayImpl> BLOCK_ELEMENTS_COMPARATOR = Comparator.comparing(i -> i.getPlacement()).thenComparing(i -> i.getPlacement() == Inlay.Placement.ABOVE_LINE ? i.myPriority : -i.myPriority);
    private static final Comparator<AfterLineEndInlayImpl> AFTER_LINE_END_ELEMENTS_OFFSET_COMPARATOR = Comparator.comparingInt(i -> i.getOffset()).thenComparingInt(i -> i.myOrder);
    private static final Comparator<AfterLineEndInlayImpl> AFTER_LINE_END_ELEMENTS_COMPARATOR = Comparator.comparingInt(i -> i.myOrder);
    private static final Processor<InlayImpl> UPDATE_SIZE_PROCESSOR = inlay -> {
        inlay.updateSize();
        return true;
    };
    private final EditorImpl myEditor;
    private final EventDispatcher<InlayModel.Listener> myDispatcher = EventDispatcher.create(InlayModel.Listener.class);
    final List<InlayImpl> myInlaysInvalidatedOnMove = new ArrayList<InlayImpl>();
    final RangeMarkerTree<InlineInlayImpl> myInlineElementsTree;
    final MarkerTreeWithPartialSums<BlockInlayImpl> myBlockElementsTree;
    final RangeMarkerTree<AfterLineEndInlayImpl> myAfterLineEndElementsTree;
    boolean myMoveInProgress;
    boolean myPutMergedIntervalsAtBeginning;
    private boolean myConsiderCaretPositionOnDocumentUpdates = true;
    private List<Inlay> myInlaysAtCaret;

    InlayModelImpl(@NotNull EditorImpl editor) {
        this.myEditor = editor;
        this.myInlineElementsTree = new InlineElementsTree(editor.getDocument());
        this.myBlockElementsTree = new BlockElementsTree(editor.getDocument());
        this.myAfterLineEndElementsTree = new AfterLineEndElementTree(editor.getDocument());
        this.myEditor.getDocument().addDocumentListener(new PrioritizedInternalDocumentListener(){

            @Override
            public int getPriority() {
                return 150;
            }

            public void beforeDocumentChange(@NotNull DocumentEvent event) {
                List<Inlay> inlays;
                int inlayCount;
                if (InlayModelImpl.this.myEditor.getDocument().isInBulkUpdate()) {
                    return;
                }
                int offset = event.getOffset();
                if (InlayModelImpl.this.myConsiderCaretPositionOnDocumentUpdates && event.getOldLength() == 0 && offset == InlayModelImpl.this.myEditor.getCaretModel().getOffset() && (inlayCount = (inlays = InlayModelImpl.this.getInlineElementsInRange(offset, offset)).size()) > 0) {
                    VisualPosition inlaysStartPosition = InlayModelImpl.this.myEditor.offsetToVisualPosition(offset, false, false);
                    VisualPosition caretPosition = InlayModelImpl.this.myEditor.getCaretModel().getVisualPosition();
                    if (inlaysStartPosition.line == caretPosition.line && caretPosition.column >= inlaysStartPosition.column && caretPosition.column <= inlaysStartPosition.column + inlayCount) {
                        InlayModelImpl.this.myInlaysAtCaret = inlays;
                        for (int i = 0; i < inlayCount; ++i) {
                            ((InlayImpl)inlays.get(i)).setStickingToRight(i >= caretPosition.column - inlaysStartPosition.column);
                        }
                    }
                }
            }

            public void documentChanged(@NotNull DocumentEvent event) {
                if (InlayModelImpl.this.myInlaysAtCaret != null) {
                    for (Inlay inlay : InlayModelImpl.this.myInlaysAtCaret) {
                        ((InlayImpl)inlay).setStickingToRight(inlay.isRelatedToPrecedingText());
                    }
                    InlayModelImpl.this.myInlaysAtCaret = null;
                }
            }

            @Override
            public void moveTextHappened(@NotNull Document document, int start2, int end, int base) {
                for (InlayImpl inlay : InlayModelImpl.this.myInlaysInvalidatedOnMove) {
                    InlayModelImpl.this.notifyRemoved(inlay);
                }
                InlayModelImpl.this.myInlaysInvalidatedOnMove.clear();
            }
        }, this);
    }

    void reinitSettings() {
        this.myInlineElementsTree.processAll(UPDATE_SIZE_PROCESSOR);
        this.myBlockElementsTree.processAll(UPDATE_SIZE_PROCESSOR);
        this.myAfterLineEndElementsTree.processAll(UPDATE_SIZE_PROCESSOR);
    }

    public void dispose() {
        this.myInlineElementsTree.dispose(this.myEditor.getDocument());
        this.myBlockElementsTree.dispose(this.myEditor.getDocument());
        this.myAfterLineEndElementsTree.dispose(this.myEditor.getDocument());
    }

    @Nullable
    public <T extends EditorCustomElementRenderer> Inlay<T> addInlineElement(int offset, boolean relatesToPrecedingText, @NotNull T renderer2) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        DocumentEx document = this.myEditor.getDocument();
        if (DocumentUtil.isInsideSurrogatePair(document, offset)) {
            return null;
        }
        offset = Math.max(0, Math.min(document.getTextLength(), offset));
        InlineInlayImpl<T> inlay = new InlineInlayImpl<T>(this.myEditor, offset, relatesToPrecedingText, renderer2);
        this.notifyAdded(inlay);
        return inlay;
    }

    @Nullable
    public <T extends EditorCustomElementRenderer> Inlay<T> addBlockElement(int offset, boolean relatesToPrecedingText, boolean showAbove, int priority, @NotNull T renderer2) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        offset = Math.max(0, Math.min(this.myEditor.getDocument().getTextLength(), offset));
        BlockInlayImpl<T> inlay = new BlockInlayImpl<T>(this.myEditor, offset, relatesToPrecedingText, showAbove, priority, renderer2);
        this.notifyAdded(inlay);
        return inlay;
    }

    @Nullable
    public <T extends EditorCustomElementRenderer> Inlay<T> addAfterLineEndElement(int offset, boolean relatesToPrecedingText, @NotNull T renderer2) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        DocumentEx document = this.myEditor.getDocument();
        offset = Math.max(0, Math.min(document.getTextLength(), offset));
        AfterLineEndInlayImpl<T> inlay = new AfterLineEndInlayImpl<T>(this.myEditor, offset, relatesToPrecedingText, renderer2);
        this.notifyAdded(inlay);
        return inlay;
    }

    @NotNull
    public List<Inlay> getInlineElementsInRange(int startOffset, int endOffset) {
        List<Inlay> range2 = InlayModelImpl.getElementsInRange(this.myInlineElementsTree, startOffset, endOffset, inlay -> true, INLINE_ELEMENTS_COMPARATOR);
        return range2;
    }

    @NotNull
    public <T> List<Inlay<? extends T>> getInlineElementsInRange(int startOffset, int endOffset, Class<T> type) {
        List<Inlay<? extends T>> range2 = InlayModelImpl.getElementsInRange(this.myInlineElementsTree, startOffset, endOffset, inlay -> type.isInstance(inlay.myRenderer), INLINE_ELEMENTS_COMPARATOR);
        return range2;
    }

    @NotNull
    public List<Inlay> getBlockElementsInRange(int startOffset, int endOffset) {
        List<Inlay> range2 = InlayModelImpl.getElementsInRange(this.myBlockElementsTree, startOffset, endOffset, inlay -> true, BLOCK_ELEMENTS_PRIORITY_COMPARATOR);
        return range2;
    }

    @NotNull
    public <T> List<Inlay<? extends T>> getBlockElementsInRange(int startOffset, int endOffset, Class<T> type) {
        List<Inlay<? extends T>> range2 = InlayModelImpl.getElementsInRange(this.myBlockElementsTree, startOffset, endOffset, inlay -> type.isInstance(inlay.myRenderer), BLOCK_ELEMENTS_PRIORITY_COMPARATOR);
        return range2;
    }

    private static <T extends Inlay> List<T> getElementsInRange(@NotNull IntervalTreeImpl<? extends T> tree, int startOffset, int endOffset, Predicate<? super T> predicate, Comparator<? super T> comparator2) {
        ArrayList result2 = new ArrayList();
        tree.processOverlappingWith(startOffset, endOffset, inlay -> {
            if (predicate.test(inlay)) {
                result2.add(inlay);
            }
            return true;
        });
        Collections.sort(result2, comparator2);
        return result2;
    }

    @NotNull
    public List<Inlay> getBlockElementsForVisualLine(int visualLine, boolean above) {
        int visibleLineCount = this.myEditor.getVisibleLineCount();
        if (visualLine < 0 || visualLine >= visibleLineCount) {
            return Collections.emptyList();
        }
        ArrayList<Inlay> result2 = new ArrayList<Inlay>();
        int startOffset = this.myEditor.visualLineStartOffset(visualLine);
        int endOffset = visualLine == visibleLineCount - 1 ? this.myEditor.getDocument().getTextLength() : this.myEditor.visualLineStartOffset(visualLine + 1) - 1;
        this.myBlockElementsTree.processOverlappingWith(startOffset, endOffset, (Processor<BlockInlayImpl>)((Processor)inlay -> {
            if (inlay.myShowAbove == above && !this.myEditor.getFoldingModel().isOffsetCollapsed(inlay.getOffset())) {
                result2.add((Inlay)inlay);
            }
            return true;
        }));
        Collections.sort(result2, BLOCK_ELEMENTS_COMPARATOR);
        return result2;
    }

    public int getHeightOfBlockElementsBeforeVisualLine(int visualLine) {
        int endOffset;
        if (visualLine < 0 || !this.hasBlockElements()) {
            return 0;
        }
        int visibleLineCount = this.myEditor.getVisibleLineCount();
        if (visualLine >= visibleLineCount) {
            return this.myBlockElementsTree.getSumOfValuesUpToOffset(Integer.MAX_VALUE) - this.myEditor.getFoldingModel().getTotalHeightOfFoldedBlockInlays();
        }
        int[] result2 = new int[]{0};
        int startOffset = this.myEditor.visualLineStartOffset(visualLine);
        int n = endOffset = visualLine >= visibleLineCount - 1 ? this.myEditor.getDocument().getTextLength() : this.myEditor.visualLineStartOffset(visualLine + 1) - 1;
        if (visualLine > 0) {
            result2[0] = result2[0] + (this.myBlockElementsTree.getSumOfValuesUpToOffset(startOffset - 1) - this.myEditor.getFoldingModel().getHeightOfFoldedBlockInlaysBefore(startOffset));
        }
        this.myBlockElementsTree.processOverlappingWith(startOffset, endOffset, (Processor<BlockInlayImpl>)((Processor)inlay -> {
            if (inlay.myShowAbove && !this.myEditor.getFoldingModel().isOffsetCollapsed(inlay.getOffset())) {
                result2[0] = result2[0] + inlay.getHeightInPixels();
            }
            return true;
        }));
        return result2[0];
    }

    public boolean hasBlockElements() {
        return this.myBlockElementsTree.size() > 0;
    }

    public boolean hasInlineElementsInRange(int startOffset, int endOffset) {
        return !this.myInlineElementsTree.processOverlappingWith(startOffset, endOffset, (Processor<InlineInlayImpl>)((Processor)inlay -> false));
    }

    public boolean hasInlineElements() {
        return this.myInlineElementsTree.size() > 0;
    }

    public boolean hasInlineElementAt(int offset) {
        return !this.myInlineElementsTree.processOverlappingWith(offset, offset, (Processor<InlineInlayImpl>)((Processor)inlay -> false));
    }

    public boolean hasInlineElementAt(@NotNull VisualPosition visualPosition) {
        int offset = this.myEditor.logicalPositionToOffset(this.myEditor.visualToLogicalPosition(visualPosition));
        int inlayCount = this.getInlineElementsInRange(offset, offset).size();
        if (inlayCount == 0) {
            return false;
        }
        VisualPosition inlayStartPosition = this.myEditor.offsetToVisualPosition(offset, false, false);
        return visualPosition.line == inlayStartPosition.line && visualPosition.column >= inlayStartPosition.column && visualPosition.column < inlayStartPosition.column + inlayCount;
    }

    @Nullable
    public Inlay getInlineElementAt(@NotNull VisualPosition visualPosition) {
        int offset = this.myEditor.logicalPositionToOffset(this.myEditor.visualToLogicalPosition(visualPosition));
        List<Inlay> inlays = this.getInlineElementsInRange(offset, offset);
        if (inlays.isEmpty()) {
            return null;
        }
        VisualPosition inlayStartPosition = this.myEditor.offsetToVisualPosition(offset, false, false);
        if (visualPosition.line != inlayStartPosition.line) {
            return null;
        }
        int inlayIndex = visualPosition.column - inlayStartPosition.column;
        return inlayIndex >= 0 && inlayIndex < inlays.size() ? inlays.get(inlayIndex) : null;
    }

    @Nullable
    public Inlay getElementAt(@NotNull Point point) {
        Inlay inlay;
        List<Inlay> inlays;
        boolean hasInlineElements = this.hasInlineElements();
        boolean hasBlockElements = this.hasBlockElements();
        boolean hasAfterLineEndElements = this.hasAfterLineEndElements();
        if (!(hasInlineElements || hasBlockElements || hasAfterLineEndElements)) {
            return null;
        }
        int offset = -1;
        VisualPosition visualPosition = this.myEditor.xyToVisualPosition(point);
        if (hasBlockElements) {
            int visualLine = visualPosition.line;
            int baseY = this.myEditor.visualLineToY(visualLine);
            if (point.y < baseY) {
                List<Inlay> inlays2 = this.getBlockElementsForVisualLine(visualLine, true);
                int yDiff = baseY - point.y;
                for (int i = inlays2.size() - 1; i >= 0; --i) {
                    Inlay inlay2 = inlays2.get(i);
                    int height = inlay2.getHeightInPixels();
                    if (yDiff <= height) {
                        return inlay2;
                    }
                    yDiff -= height;
                }
                throw new IllegalStateException();
            }
            int lineBottom = baseY + this.myEditor.getLineHeight();
            if (point.y >= lineBottom) {
                List<Inlay> inlays3 = this.getBlockElementsForVisualLine(visualLine, false);
                int yDiff = point.y - lineBottom;
                for (Inlay inlay3 : inlays3) {
                    int height = inlay3.getHeightInPixels();
                    if (yDiff < height) {
                        return inlay3;
                    }
                    yDiff -= height;
                }
                throw new IllegalStateException();
            }
        }
        if (hasInlineElements && !(inlays = this.getInlineElementsInRange(offset = this.myEditor.logicalPositionToOffset(this.myEditor.visualToLogicalPosition(visualPosition)), offset)).isEmpty()) {
            VisualPosition startVisualPosition = this.myEditor.offsetToVisualPosition(offset);
            int x = this.myEditor.visualPositionToXY((VisualPosition)startVisualPosition).x;
            inlay = InlayModelImpl.findInlay(inlays, point, x);
            if (inlay != null) {
                return inlay;
            }
        }
        if (hasAfterLineEndElements) {
            List<Inlay> inlays4;
            if (offset < 0) {
                offset = this.myEditor.logicalPositionToOffset(this.myEditor.visualToLogicalPosition(visualPosition));
            }
            int logicalLine = this.myEditor.getDocument().getLineNumber(offset);
            if (offset == this.myEditor.getDocument().getLineEndOffset(logicalLine) && !this.myEditor.getFoldingModel().isOffsetCollapsed(offset) && !(inlays4 = this.myEditor.getInlayModel().getAfterLineEndElementsForLogicalLine(logicalLine)).isEmpty()) {
                Rectangle bounds2 = inlays4.get(0).getBounds();
                assert (bounds2 != null);
                inlay = InlayModelImpl.findInlay(inlays4, point, bounds2.x);
                if (inlay != null) {
                    return inlay;
                }
            }
        }
        return null;
    }

    private static Inlay findInlay(List<Inlay> inlays, @NotNull Point point, int startX) {
        for (Inlay inlay : inlays) {
            int endX = startX + inlay.getWidthInPixels();
            if (point.x >= startX && point.x < endX) {
                return inlay;
            }
            startX = endX;
        }
        return null;
    }

    @NotNull
    public List<Inlay> getAfterLineEndElementsInRange(int startOffset, int endOffset) {
        if (!this.hasAfterLineEndElements()) {
            return Collections.emptyList();
        }
        List<Inlay> range2 = InlayModelImpl.getElementsInRange(this.myAfterLineEndElementsTree, startOffset, endOffset, inlay -> true, AFTER_LINE_END_ELEMENTS_OFFSET_COMPARATOR);
        return range2;
    }

    @NotNull
    public <T> List<Inlay<? extends T>> getAfterLineEndElementsInRange(int startOffset, int endOffset, Class<T> type) {
        if (!this.hasAfterLineEndElements()) {
            return Collections.emptyList();
        }
        List<Inlay<? extends T>> range2 = InlayModelImpl.getElementsInRange(this.myAfterLineEndElementsTree, startOffset, endOffset, inlay -> type.isInstance(inlay.myRenderer), AFTER_LINE_END_ELEMENTS_OFFSET_COMPARATOR);
        return range2;
    }

    @NotNull
    public List<Inlay> getAfterLineEndElementsForLogicalLine(int logicalLine) {
        DocumentEx document = this.myEditor.getDocument();
        if (!this.hasAfterLineEndElements() || logicalLine < 0 || logicalLine > 0 && logicalLine >= document.getLineCount()) {
            return Collections.emptyList();
        }
        ArrayList<Inlay> result2 = new ArrayList<Inlay>();
        int startOffset = document.getLineStartOffset(logicalLine);
        int endOffset = document.getLineEndOffset(logicalLine);
        this.myAfterLineEndElementsTree.processOverlappingWith(startOffset, endOffset, (Processor<AfterLineEndInlayImpl>)((Processor)inlay -> {
            result2.add((Inlay)inlay);
            return true;
        }));
        result2.sort(AFTER_LINE_END_ELEMENTS_COMPARATOR);
        return result2;
    }

    public boolean hasAfterLineEndElements() {
        return this.myAfterLineEndElementsTree.size() > 0;
    }

    public void setConsiderCaretPositionOnDocumentUpdates(boolean enabled) {
        this.myConsiderCaretPositionOnDocumentUpdates = enabled;
    }

    public void addListener(@NotNull InlayModel.Listener listener2, @NotNull Disposable disposable) {
        this.myDispatcher.addListener((EventListener)listener2, disposable);
    }

    private void notifyAdded(InlayImpl inlay) {
        ((InlayModel.Listener)this.myDispatcher.getMulticaster()).onAdded((Inlay)inlay);
    }

    void notifyChanged(InlayImpl inlay) {
        ((InlayModel.Listener)this.myDispatcher.getMulticaster()).onUpdated((Inlay)inlay);
    }

    void notifyRemoved(InlayImpl inlay) {
        ((InlayModel.Listener)this.myDispatcher.getMulticaster()).onRemoved((Inlay)inlay);
    }

    public void validateState() {
        for (Inlay inlay : this.getInlineElementsInRange(0, this.myEditor.getDocument().getTextLength())) {
            LOG.assertTrue(!DocumentUtil.isInsideSurrogatePair(this.myEditor.getDocument(), inlay.getOffset()));
        }
    }

    @NotNull
    public String dumpState() {
        return "Inline elements: " + InlayModelImpl.dumpInlays(this.myInlineElementsTree) + ", after-line-end elements: " + InlayModelImpl.dumpInlays(this.myAfterLineEndElementsTree) + ", block elements: " + InlayModelImpl.dumpInlays(this.myBlockElementsTree);
    }

    private static String dumpInlays(RangeMarkerTree<? extends InlayImpl> tree) {
        StringJoiner joiner = new StringJoiner(",", "[", "]");
        tree.processAll((Processor<? extends InlayImpl>)((Processor)o -> {
            joiner.add(Integer.toString(o.getOffset()));
            return true;
        }));
        return joiner.toString();
    }

    private class AfterLineEndElementTree
    extends HardReferencingRangeMarkerTree<AfterLineEndInlayImpl> {
        AfterLineEndElementTree(Document document) {
            super(document);
        }

        @Override
        void fireBeforeRemoved(@NotNull AfterLineEndInlayImpl inlay, @NotNull @NonNls Object reason) {
            if (inlay.getUserData(InlayImpl.OFFSET_BEFORE_DISPOSAL) == null) {
                InlayModelImpl.this.notifyRemoved(inlay);
            }
        }
    }

    private class BlockElementsTree
    extends MarkerTreeWithPartialSums<BlockInlayImpl> {
        BlockElementsTree(Document document) {
            super(document);
        }

        @Override
        void fireBeforeRemoved(@NotNull BlockInlayImpl inlay, @NotNull @NonNls Object reason) {
            if (inlay.getUserData(InlayImpl.OFFSET_BEFORE_DISPOSAL) == null) {
                InlayModelImpl.this.notifyRemoved(inlay);
            }
        }
    }

    private class InlineElementsTree
    extends HardReferencingRangeMarkerTree<InlineInlayImpl> {
        InlineElementsTree(Document document) {
            super(document);
        }

        @Override
        @NotNull
        protected HardReferencingRangeMarkerTree.Node<InlineInlayImpl> createNewNode(@NotNull InlineInlayImpl key, int start2, int end, boolean greedyToLeft, boolean greedyToRight, boolean stickingToRight, int layer) {
            return new HardReferencingRangeMarkerTree.Node<InlineInlayImpl>((RangeMarkerTree)this, key, start2, end, greedyToLeft, greedyToRight, stickingToRight){

                @Override
                void addIntervalsFrom(@NotNull IntervalTreeImpl.IntervalNode<InlineInlayImpl> otherNode) {
                    super.addIntervalsFrom(otherNode);
                    if (InlayModelImpl.this.myPutMergedIntervalsAtBeginning) {
                        List added = ContainerUtil.subList((List)this.intervals, (int)(this.intervals.size() - otherNode.intervals.size()));
                        ArrayList addedCopy = new ArrayList(added);
                        added.clear();
                        this.intervals.addAll(0, addedCopy);
                    }
                }
            };
        }

        @Override
        void fireBeforeRemoved(@NotNull InlineInlayImpl inlay, @NotNull @NonNls Object reason) {
            if (inlay.getUserData(InlayImpl.OFFSET_BEFORE_DISPOSAL) == null) {
                if (InlayModelImpl.this.myMoveInProgress) {
                    InlayModelImpl.this.myInlaysInvalidatedOnMove.add(inlay);
                } else {
                    InlayModelImpl.this.notifyRemoved(inlay);
                }
            }
        }
    }
}

