/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.ex.LineIterator;
import com.intellij.openapi.editor.impl.LineSet;

public class LineIteratorImpl
implements LineIterator {
    private int myLineIndex = 0;
    private final LineSet myLineSet;

    LineIteratorImpl(LineSet lineSet) {
        this.myLineSet = lineSet;
    }

    @Override
    public void start(int startOffset) {
        this.myLineIndex = this.myLineSet.findLineIndex(startOffset);
    }

    @Override
    public int getStart() {
        return this.myLineSet.getLineStart(this.myLineIndex);
    }

    @Override
    public int getEnd() {
        return this.myLineSet.getLineEnd(this.myLineIndex);
    }

    @Override
    public int getSeparatorLength() {
        return this.myLineSet.getSeparatorLength(this.myLineIndex);
    }

    @Override
    public int getLineNumber() {
        return this.myLineIndex;
    }

    @Override
    public void advance() {
        ++this.myLineIndex;
    }

    @Override
    public boolean atEnd() {
        return this.myLineIndex >= this.myLineSet.getLineCount() || this.myLineIndex < 0;
    }
}

