/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.StripTrailingSpacesFilter;
import com.intellij.openapi.editor.StripTrailingSpacesFilterFactory;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import java.util.BitSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiBasedStripTrailingSpacesFilter
implements StripTrailingSpacesFilter {
    @NotNull
    private final BitSet myDisabledLinesBitSet;
    @NotNull
    private final Document myDocument;
    private static final Logger LOG = Logger.getInstance(PsiBasedStripTrailingSpacesFilter.class);

    protected PsiBasedStripTrailingSpacesFilter(@NotNull Document document) {
        this.myDocument = document;
        this.myDisabledLinesBitSet = new BitSet(document.getLineCount());
    }

    public boolean isStripSpacesAllowedForLine(int line) {
        return !this.myDisabledLinesBitSet.get(line);
    }

    protected abstract void process(@NotNull PsiFile var1);

    @Nullable
    public static Language getDocumentLanguage(@NotNull Document document) {
        FileDocumentManager manager = FileDocumentManager.getInstance();
        VirtualFile file2 = manager.getFile(document);
        if (file2 != null && file2.isValid()) {
            return LanguageUtil.getFileLanguage((VirtualFile)file2);
        }
        return null;
    }

    @Nullable
    private static PsiFile getPsiFile(@Nullable Project project, @NotNull Document document) {
        if (project != null) {
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
            if (documentManager.isCommitted(document)) {
                return documentManager.getCachedPsiFile(document);
            }
        } else {
            VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
            LOG.warn("No current project is given, trailing spaces will be stripped later (postponed). File: " + (virtualFile != null ? virtualFile.getCanonicalPath() : "undefined"));
        }
        return null;
    }

    protected final void disableRange(@NotNull TextRange range2, boolean includeEndLine) {
        int startLine = this.myDocument.getLineNumber(range2.getStartOffset());
        int endLine = this.myDocument.getLineNumber(range2.getEndOffset());
        if (includeEndLine) {
            ++endLine;
        }
        this.myDisabledLinesBitSet.set(startLine, endLine);
    }

    public static abstract class Factory
    extends StripTrailingSpacesFilterFactory {
        @NotNull
        public final StripTrailingSpacesFilter createFilter(@Nullable Project project, @NotNull Document document) {
            Language language = PsiBasedStripTrailingSpacesFilter.getDocumentLanguage(document);
            if (language != null && this.isApplicableTo(language)) {
                PsiFile psiFile = PsiBasedStripTrailingSpacesFilter.getPsiFile(project, document);
                if (psiFile != null) {
                    PsiBasedStripTrailingSpacesFilter filter = this.createFilter(document);
                    filter.process(psiFile);
                    return filter;
                }
                return StripTrailingSpacesFilter.POSTPONED;
            }
            return StripTrailingSpacesFilter.ALL_LINES;
        }

        @NotNull
        protected abstract PsiBasedStripTrailingSpacesFilter createFilter(@NotNull Document var1);

        protected abstract boolean isApplicableTo(@NotNull Language var1);
    }
}

