/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.PrioritizedInternalDocumentListener;
import com.intellij.openapi.editor.ex.RangeMarkerEx;
import com.intellij.openapi.editor.impl.IntervalTreeImpl;
import com.intellij.openapi.editor.impl.RangeMarkerImpl;
import com.intellij.openapi.editor.impl.RedBlackTree;
import com.intellij.openapi.util.Getter;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class RangeMarkerTree<T extends RangeMarkerEx>
extends IntervalTreeImpl<T>
implements PrioritizedInternalDocumentListener {
    private static final int DUPLICATE_LIMIT = 30;

    RangeMarkerTree(@NotNull Document document) {
        document.addDocumentListener((DocumentListener)this);
    }

    RangeMarkerTree() {
    }

    @Override
    public void moveTextHappened(@NotNull Document document, int start2, int end, int newBase) {
        this.reTarget(start2, end, newBase);
    }

    @Override
    public int getPriority() {
        return 40;
    }

    public void documentChanged(@NotNull DocumentEvent event) {
        this.updateMarkersOnChange(event);
    }

    @Override
    protected int compareEqualStartIntervals(@NotNull IntervalTreeImpl.IntervalNode<T> i1, @NotNull IntervalTreeImpl.IntervalNode<T> i2) {
        boolean stickyR2;
        boolean greedyR2;
        int o2Length;
        boolean greedyL2;
        RMNode o1 = (RMNode)i1;
        RMNode o2 = (RMNode)i2;
        boolean greedyL1 = o1.isGreedyToLeft();
        if (greedyL1 != (greedyL2 = o2.isGreedyToLeft())) {
            return greedyL1 ? -1 : 1;
        }
        int o1Length = o1.intervalEnd() - o1.intervalStart();
        int d = o1Length - (o2Length = o2.intervalEnd() - o2.intervalStart());
        if (d != 0) {
            return d;
        }
        boolean greedyR1 = o1.isGreedyToRight();
        if (greedyR1 != (greedyR2 = o2.isGreedyToRight())) {
            return greedyR1 ? -1 : 1;
        }
        boolean stickyR1 = o1.isStickingToRight();
        if (stickyR1 != (stickyR2 = o2.isStickingToRight())) {
            return stickyR1 ? -1 : 1;
        }
        return 0;
    }

    void dispose(@NotNull Document document) {
        document.removeDocumentListener((DocumentListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public RMNode<T> addInterval(@NotNull T interval, int start2, int end, boolean greedyToLeft, boolean greedyToRight, boolean stickingToRight, int layer) {
        ((RangeMarkerImpl)interval).setValid(true);
        RMNode node = (RMNode)super.addInterval(interval, start2, end, greedyToLeft, greedyToRight, stickingToRight, layer);
        if (DEBUG && node.intervals.size() > 30 && !ApplicationInfoImpl.isInStressTest() && ApplicationManager.getApplication().isUnitTestMode()) {
            this.l.readLock().lock();
            try {
                String msg = this.errMsg(node);
                if (msg != null) {
                    LOG.warn(msg);
                }
            }
            finally {
                this.l.readLock().unlock();
            }
        }
        return node;
    }

    private String errMsg(@NotNull RMNode<T> node) {
        System.gc();
        AtomicInteger alive = new AtomicInteger();
        node.processAliveKeys(t -> {
            alive.incrementAndGet();
            return true;
        });
        if (alive.get() > 30) {
            return "Too many range markers (" + alive + ") registered for interval " + node;
        }
        return null;
    }

    @Override
    @NotNull
    protected RMNode<T> createNewNode(@NotNull T key, int start2, int end, boolean greedyToLeft, boolean greedyToRight, boolean stickingToRight, int layer) {
        return new RMNode<T>(this, key, start2, end, greedyToLeft, greedyToRight, stickingToRight);
    }

    @Override
    protected RMNode<T> lookupNode(@NotNull T key) {
        return ((RangeMarkerImpl)key).myNode;
    }

    @Override
    protected void setNode(@NotNull T key, IntervalTreeImpl.IntervalNode<T> intervalNode) {
        ((RangeMarkerImpl)key).myNode = (RMNode)intervalNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMarkersOnChange(@NotNull DocumentEvent e) {
        try {
            this.l.writeLock().lock();
            if (this.size() == 0) {
                return;
            }
            this.checkMax(true);
            this.incModCount();
            SmartList affected = new SmartList();
            this.collectAffectedMarkersAndShiftSubtrees(this.getRoot(), e, (List<? super IntervalTreeImpl.IntervalNode<T>>)affected);
            this.checkMax(false);
            if (!affected.isEmpty()) {
                for (int i = affected.size() - 1; i >= 0; --i) {
                    IntervalTreeImpl.IntervalNode node = (IntervalTreeImpl.IntervalNode)affected.get(i);
                    int startOffset = node.intervalStart();
                    int endOffset = node.intervalEnd();
                    this.removeNode(node);
                    this.checkMax(false);
                    node.clearDelta();
                    node.setParent(null);
                    node.setLeft(null);
                    node.setRight(null);
                    node.setValid(true);
                    assert (node.intervalStart() == startOffset);
                    assert (node.intervalEnd() == endOffset);
                }
                this.checkMax(true);
                for (IntervalTreeImpl.IntervalNode node : affected) {
                    List keys = node.intervals;
                    if (keys.isEmpty()) continue;
                    RangeMarkerImpl marker = null;
                    for (int i = keys.size() - 1; i >= 0; --i) {
                        Getter key = keys.get(i);
                        marker = (RangeMarkerImpl)key.get();
                        if (marker == null) continue;
                        if (marker.isValid()) break;
                        node.removeIntervalInternal(i);
                        marker = null;
                    }
                    if (marker == null) continue;
                    marker.documentChanged(e);
                    if (marker.isValid()) {
                        this.findOrInsertWithIntervals(node);
                        continue;
                    }
                    node.setValid(false);
                    ((RMNode)node).onRemoved();
                }
            }
            this.checkMax(true);
            IntervalTreeImpl.IntervalNode root = this.getRoot();
            assert (root == null || root.maxEnd + root.delta <= e.getDocument().getTextLength());
        }
        finally {
            this.l.writeLock().unlock();
        }
    }

    private void findOrInsertWithIntervals(IntervalTreeImpl.IntervalNode<T> node) {
        IntervalTreeImpl.IntervalNode<T> insertedNode = this.findOrInsert(node);
        if (insertedNode != node) {
            insertedNode.addIntervalsFrom(node);
        }
    }

    boolean collectAffectedMarkersAndShiftSubtrees(@Nullable IntervalTreeImpl.IntervalNode<T> root, @NotNull DocumentEvent e, @NotNull List<? super IntervalTreeImpl.IntervalNode<T>> affected) {
        if (root == null) {
            return true;
        }
        boolean norm = this.pushDelta(root);
        int maxEnd = root.maxEnd;
        assert (root.isValid());
        int offset = e.getOffset();
        int affectedEndOffset = offset + e.getOldLength();
        boolean hasAliveKeys = root.hasAliveKey(false);
        if (!hasAliveKeys) {
            affected.add(root);
        }
        if (offset <= maxEnd) {
            if (affectedEndOffset < root.intervalStart()) {
                int lengthDelta = e.getNewLength() - e.getOldLength();
                int newD = root.changeDelta(lengthDelta);
                norm &= newD == 0;
                RedBlackTree.Node left = root.getLeft();
                if (left != null) {
                    int newL = ((IntervalTreeImpl.IntervalNode)left).changeDelta(-lengthDelta);
                    norm &= newL == 0;
                }
                norm &= this.pushDelta(root);
                norm &= this.collectAffectedMarkersAndShiftSubtrees((IntervalTreeImpl.IntervalNode<T>)left, e, (List<? super IntervalTreeImpl.IntervalNode<T>>)affected);
                this.correctMax(root, 0);
            } else {
                if (offset <= root.intervalEnd()) {
                    if (hasAliveKeys) {
                        affected.add(root);
                    }
                    root.setValid(false);
                }
                norm &= this.collectAffectedMarkersAndShiftSubtrees((IntervalTreeImpl.IntervalNode<T>)root.getLeft(), e, (List<? super IntervalTreeImpl.IntervalNode<T>>)affected);
                norm &= this.collectAffectedMarkersAndShiftSubtrees((IntervalTreeImpl.IntervalNode<T>)root.getRight(), e, (List<? super IntervalTreeImpl.IntervalNode<T>>)affected);
                this.correctMax(root, 0);
            }
        }
        return norm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reTarget(int start2, int end, int newBase) {
        this.l.writeLock().lock();
        try {
            this.checkMax(true);
            ArrayList affected = new ArrayList();
            this.collectNodesToRetarget(this.getRoot(), start2, end, affected);
            if (affected.isEmpty()) {
                return;
            }
            for (IntervalTreeImpl.IntervalNode node : affected) {
                this.removeNode(node);
            }
            int shift = newBase - start2;
            for (IntervalTreeImpl.IntervalNode node : affected) {
                node.setLeft(null);
                node.setRight(null);
                node.setParent(null);
                node.changeDelta(shift);
                node.setValid(true);
                this.pushDelta(node);
                List keys = node.intervals;
                if (keys.isEmpty()) continue;
                RangeMarkerImpl marker = null;
                for (int i = keys.size() - 1; i >= 0; --i) {
                    Getter key = keys.get(i);
                    marker = (RangeMarkerImpl)key.get();
                    if (marker == null) continue;
                    if (marker.isValid()) break;
                    node.removeIntervalInternal(i);
                    marker = null;
                }
                if (marker == null) continue;
                marker.onReTarget(start2, end, newBase);
                if (marker.isValid()) {
                    this.findOrInsertWithIntervals(node);
                    continue;
                }
                node.setValid(false);
                ((RMNode)node).onRemoved();
            }
        }
        finally {
            this.checkMax(true);
            this.l.writeLock().unlock();
        }
    }

    private void collectNodesToRetarget(@Nullable IntervalTreeImpl.IntervalNode<T> root, int start2, int end, @NotNull List<? super IntervalTreeImpl.IntervalNode<T>> affected) {
        if (root == null) {
            return;
        }
        this.pushDelta(root);
        int maxEnd = root.maxEnd;
        assert (root.isValid());
        if (start2 > maxEnd) {
            return;
        }
        this.collectNodesToRetarget((IntervalTreeImpl.IntervalNode<T>)root.getLeft(), start2, end, (List<? super IntervalTreeImpl.IntervalNode<T>>)affected);
        if (start2 <= root.intervalStart() && root.intervalEnd() <= end) {
            affected.add(root);
        }
        if (end < root.intervalStart()) {
            return;
        }
        this.collectNodesToRetarget((IntervalTreeImpl.IntervalNode<T>)root.getRight(), start2, end, (List<? super IntervalTreeImpl.IntervalNode<T>>)affected);
    }

    static class RMNode<T extends RangeMarkerEx>
    extends IntervalTreeImpl.IntervalNode<T> {
        private static final byte EXPAND_TO_LEFT_FLAG = 8;
        private static final byte EXPAND_TO_RIGHT_FLAG = 16;
        private static final byte STICK_TO_RIGHT_FLAG = 32;

        RMNode(@NotNull RangeMarkerTree<T> rangeMarkerTree, @NotNull T key, int start2, int end, boolean greedyToLeft, boolean greedyToRight, boolean stickingToRight) {
            super(rangeMarkerTree, key, start2, end);
            this.setFlag((byte)8, greedyToLeft);
            this.setFlag((byte)16, greedyToRight);
            this.setFlag((byte)32, stickingToRight);
        }

        boolean isGreedyToLeft() {
            return this.isFlagSet((byte)8);
        }

        boolean isGreedyToRight() {
            return this.isFlagSet((byte)16);
        }

        boolean isStickingToRight() {
            return this.isFlagSet((byte)32);
        }

        void onRemoved() {
        }

        @Override
        public String toString() {
            return (this.isGreedyToLeft() ? "[" : "(") + this.intervalStart() + "," + this.intervalEnd() + (this.isGreedyToRight() ? "]" : ")");
        }
    }
}

