/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.util.Segment;
import com.intellij.util.Processor;
import java.util.Collection;
import java.util.Comparator;
import java.util.PriorityQueue;
import org.jetbrains.annotations.NotNull;

@FunctionalInterface
public interface SweepProcessor<T> {
    public boolean process(int var1, @NotNull T var2, boolean var3, @NotNull Collection<T> var4);

    public static <T extends Segment> boolean sweep(@NotNull Generator<? extends T> generator, @NotNull SweepProcessor<T> sweepProcessor) {
        PriorityQueue<Segment> ends = new PriorityQueue<Segment>(5, Comparator.comparingInt(Segment::getEndOffset));
        if (!generator.generateInStartOffsetOrder(marker -> {
            Segment previous;
            int prevEnd;
            int start2 = marker.getStartOffset();
            while (!ends.isEmpty() && (prevEnd = (previous = (Segment)ends.peek()).getEndOffset()) <= start2) {
                if (!sweepProcessor.process(prevEnd, previous, false, ends)) {
                    return false;
                }
                ends.remove();
            }
            if (!sweepProcessor.process(start2, (Segment)marker, true, (Collection<Segment>)ends)) {
                return false;
            }
            ends.offer((Segment)marker);
            return true;
        })) {
            return false;
        }
        while (!ends.isEmpty()) {
            Segment previous = (Segment)ends.remove();
            int prevEnd = previous.getEndOffset();
            if (sweepProcessor.process(prevEnd, previous, false, ends)) continue;
            return false;
        }
        return true;
    }

    @FunctionalInterface
    public static interface Generator<T> {
        public boolean generateInStartOffsetOrder(@NotNull Processor<T> var1);
    }
}

