/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.softwrap;

import com.intellij.diagnostic.Dumpable;
import com.intellij.openapi.editor.SoftWrap;
import com.intellij.openapi.editor.ex.SoftWrapChangeListener;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapImpl;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SoftWrapsStorage
implements Dumpable {
    private final List<SoftWrapImpl> myWraps = new ArrayList<SoftWrapImpl>();
    private final List<SoftWrapImpl> myWrapsView = Collections.unmodifiableList(this.myWraps);
    private final List<SoftWrapChangeListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();

    public boolean isEmpty() {
        return this.myWraps.isEmpty();
    }

    @Nullable
    public SoftWrap getSoftWrap(int offset) {
        int i = this.getSoftWrapIndex(offset);
        return i >= 0 ? (SoftWrap)this.myWraps.get(i) : null;
    }

    @NotNull
    public List<SoftWrapImpl> getSoftWraps() {
        return this.myWrapsView;
    }

    public int getSoftWrapIndex(int offset) {
        return ObjectUtils.binarySearch((int)0, (int)this.myWraps.size(), i -> Integer.compare(this.myWraps.get(i).getStart(), offset));
    }

    public int getNumberOfSoftWrapsInRange(int startOffset, int endOffset) {
        SoftWrap softWrap;
        int startIndex = this.getSoftWrapIndex(startOffset);
        if (startIndex < 0) {
            startIndex = -startIndex - 1;
        }
        if (startIndex >= this.myWraps.size()) {
            return 0;
        }
        int result2 = 0;
        for (int endIndex = startIndex; endIndex < this.myWraps.size() && (softWrap = (SoftWrap)this.myWraps.get(endIndex)).getStart() <= endOffset; ++endIndex) {
            ++result2;
        }
        return result2;
    }

    public void storeOrReplace(SoftWrapImpl softWrap) {
        int i = this.getSoftWrapIndex(softWrap.getStart());
        if (i >= 0) {
            this.myWraps.set(i, softWrap);
            return;
        }
        i = -i - 1;
        this.myWraps.add(i, softWrap);
    }

    public void remove(SoftWrapImpl softWrap) {
        if (this.myWraps.isEmpty()) {
            return;
        }
        int i = this.myWraps.size() - 1;
        if (this.myWraps.get(i).getStart() != softWrap.getStart()) {
            i = this.getSoftWrapIndex(softWrap.getStart());
        }
        if (i >= 0) {
            this.myWraps.remove(i);
        }
    }

    public List<SoftWrapImpl> removeStartingFrom(int offset) {
        int startIndex = this.getSoftWrapIndex(offset);
        if (startIndex < 0) {
            startIndex = -startIndex - 1;
        }
        if (startIndex >= this.myWraps.size()) {
            return Collections.emptyList();
        }
        List<SoftWrapImpl> tail = this.myWraps.subList(startIndex, this.myWraps.size());
        ArrayList<SoftWrapImpl> result2 = new ArrayList<SoftWrapImpl>(tail);
        tail.clear();
        return result2;
    }

    public void addAll(List<SoftWrapImpl> softWraps) {
        this.myWraps.addAll(softWraps);
    }

    public void removeAll() {
        this.myWraps.clear();
        this.notifyListenersAboutChange();
    }

    public boolean addSoftWrapChangeListener(@NotNull SoftWrapChangeListener listener2) {
        return this.myListeners.add(listener2);
    }

    public void notifyListenersAboutChange() {
        for (SoftWrapChangeListener listener2 : this.myListeners) {
            listener2.softWrapsChanged();
        }
    }

    @NotNull
    public String dumpState() {
        return this.myWraps.toString();
    }
}

