/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.softwrap.mapping;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.LogicalPosition;
import org.jetbrains.annotations.NotNull;

class EditorPosition
implements Cloneable {
    int logicalLine;
    int offset;
    int x;
    private final Editor myEditor;

    private EditorPosition(@NotNull Editor editor) {
        this.myEditor = editor;
    }

    EditorPosition(@NotNull LogicalPosition logical, int offset, @NotNull Editor editor) {
        this.myEditor = editor;
        this.logicalLine = logical.line;
        this.offset = offset;
    }

    void onNewLine() {
        ++this.logicalLine;
        this.x = 0;
        ++this.offset;
    }

    public void advance(@NotNull FoldRegion foldRegion) {
        this.offset = foldRegion.getEndOffset();
        Document document = this.myEditor.getDocument();
        int endOffsetLogicalLine = document.getLineNumber(foldRegion.getEndOffset());
        if (this.logicalLine != endOffsetLogicalLine) {
            int linesDiff = endOffsetLogicalLine - this.logicalLine;
            this.logicalLine += linesDiff;
        }
    }

    public void from(@NotNull EditorPosition position) {
        this.logicalLine = position.logicalLine;
        this.offset = position.offset;
        this.x = position.x;
    }

    protected EditorPosition clone() {
        EditorPosition result2 = new EditorPosition(this.myEditor);
        result2.logicalLine = this.logicalLine;
        result2.offset = this.offset;
        result2.x = this.x;
        return result2;
    }

    public String toString() {
        return String.format("logical line: %d; offset: %d", this.logicalLine, this.offset);
    }
}

