/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.softwrap.mapping;

import com.intellij.diagnostic.AttachmentFactory;
import com.intellij.diagnostic.Dumpable;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.LanguageLineWrapPositionStrategy;
import com.intellij.openapi.editor.LineWrapPositionStrategy;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.SoftWrap;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.ScrollingModelEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.DefaultEditorTextRepresentationHelper;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.EditorTextRepresentationHelper;
import com.intellij.openapi.editor.impl.SoftWrapModelImpl;
import com.intellij.openapi.editor.impl.TextChangeImpl;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapDrawingType;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapImpl;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapPainter;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapsStorage;
import com.intellij.openapi.editor.impl.softwrap.mapping.CachingSoftWrapDataMapper;
import com.intellij.openapi.editor.impl.softwrap.mapping.EditorPosition;
import com.intellij.openapi.editor.impl.softwrap.mapping.IncrementalCacheUpdateEvent;
import com.intellij.openapi.editor.impl.softwrap.mapping.SoftWrapAwareDocumentParsingListener;
import com.intellij.openapi.editor.impl.softwrap.mapping.SoftWrapAwareDocumentParsingListenerAdapter;
import com.intellij.openapi.editor.impl.view.IterationState;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.DocumentUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.JScrollBar;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SoftWrapApplianceManager
implements Dumpable {
    private static final Logger LOG = Logger.getInstance(SoftWrapApplianceManager.class);
    private static final int QUICK_DUMMY_WRAPPING = Integer.MAX_VALUE;
    private static final int QUICK_WRAP_CHAR_COUNT = 1000;
    private final List<SoftWrapAwareDocumentParsingListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final ProcessingContext myContext = new ProcessingContext();
    private final FontTypesStorage myOffset2fontType = new FontTypesStorage();
    private final WidthsStorage myOffset2widthInPixels = new WidthsStorage();
    private final SoftWrapsStorage myStorage;
    private final EditorImpl myEditor;
    private SoftWrapPainter myPainter;
    private final CachingSoftWrapDataMapper myDataMapper;
    private int myLastTopLeftCornerOffset;
    private VisibleAreaWidthProvider myWidthProvider;
    private LineWrapPositionStrategy myLineWrapPositionStrategy;
    private IncrementalCacheUpdateEvent myEventBeingProcessed;
    private boolean myCustomIndentUsedLastTime;
    private int myCustomIndentValueUsedLastTime;
    private int myVisibleAreaWidth;
    private boolean myInProgress;
    private boolean myIsDirty = true;
    private IncrementalCacheUpdateEvent myDocumentChangedEvent;
    private int myAvailableWidth = Integer.MAX_VALUE;

    public SoftWrapApplianceManager(@NotNull SoftWrapsStorage storage2, @NotNull EditorImpl editor, @NotNull SoftWrapPainter painter, CachingSoftWrapDataMapper dataMapper) {
        this.myStorage = storage2;
        this.myEditor = editor;
        this.myPainter = painter;
        this.myDataMapper = dataMapper;
        this.myWidthProvider = new DefaultVisibleAreaWidthProvider(editor);
        this.myEditor.getScrollingModel().addVisibleAreaListener(e -> {
            this.updateAvailableArea();
            this.updateLastTopLeftCornerOffset();
        });
    }

    public void registerSoftWrapIfNecessary() {
        this.recalculateIfNecessary();
    }

    public void reset() {
        this.myIsDirty = true;
        for (SoftWrapAwareDocumentParsingListener listener2 : this.myListeners) {
            listener2.reset();
        }
    }

    public void release() {
        this.myLineWrapPositionStrategy = null;
    }

    private void recalculate(IncrementalCacheUpdateEvent e) {
        if (this.myIsDirty) {
            return;
        }
        if (this.myVisibleAreaWidth <= 0) {
            this.myIsDirty = true;
            return;
        }
        this.recalculateSoftWraps(e);
        this.onRecalculationEnd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recalculate(@NotNull List<? extends Segment> ranges) {
        if (this.myIsDirty) {
            return;
        }
        if (this.myVisibleAreaWidth <= 0) {
            this.myIsDirty = true;
            return;
        }
        Collections.sort(ranges, (o1, o2) -> {
            int startDiff = o1.getStartOffset() - o2.getStartOffset();
            return startDiff == 0 ? o2.getEndOffset() - o1.getEndOffset() : startDiff;
        });
        final int[] lastRecalculatedOffset = new int[]{0};
        SoftWrapAwareDocumentParsingListenerAdapter listener2 = new SoftWrapAwareDocumentParsingListenerAdapter(){

            @Override
            public void onRecalculationEnd(@NotNull IncrementalCacheUpdateEvent event) {
                lastRecalculatedOffset[0] = event.getActualEndOffset();
            }
        };
        this.myListeners.add(listener2);
        try {
            for (Segment segment : ranges) {
                int lastOffset = lastRecalculatedOffset[0];
                if (segment.getEndOffset() <= lastOffset) continue;
                this.recalculateSoftWraps(new IncrementalCacheUpdateEvent(Math.max(segment.getStartOffset(), lastOffset), segment.getEndOffset(), this.myEditor));
            }
        }
        finally {
            this.myListeners.remove(listener2);
        }
        this.onRecalculationEnd();
    }

    private boolean recalculateSoftWraps() {
        if (!this.myIsDirty) {
            return true;
        }
        if (this.myVisibleAreaWidth <= 0) {
            return false;
        }
        this.myIsDirty = false;
        this.recalculateSoftWraps(new IncrementalCacheUpdateEvent(this.myEditor.getDocument()));
        this.onRecalculationEnd();
        return true;
    }

    private void onRecalculationEnd() {
        this.updateLastTopLeftCornerOffset();
        for (SoftWrapAwareDocumentParsingListener listener2 : this.myListeners) {
            listener2.recalculationEnds();
        }
    }

    private void recalculateSoftWraps(@NotNull IncrementalCacheUpdateEvent event) {
        if (this.myEditor.getDocument() instanceof DocumentImpl && ((DocumentImpl)this.myEditor.getDocument()).acceptsSlashR()) {
            LOG.error("Soft wrapping is not supported for documents with non-standard line endings. File: " + this.myEditor.getVirtualFile());
        }
        if (this.myInProgress) {
            LOG.error("Detected race condition at soft wraps recalculation", new Throwable(), new Attachment[]{AttachmentFactory.createContext(this.myEditor.dumpState(), event)});
        }
        this.myInProgress = true;
        try {
            this.myEventBeingProcessed = event;
            this.notifyListenersOnCacheUpdateStart(event);
            int endOffsetUpperEstimate = this.getEndOffsetUpperEstimate(event);
            if (this.myVisibleAreaWidth == Integer.MAX_VALUE) {
                this.doRecalculateSoftWrapsRoughly(event);
            } else {
                this.doRecalculateSoftWraps(event, endOffsetUpperEstimate);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Soft wrap recalculation done: " + event.toString() + ". " + (event.getActualEndOffset() - event.getStartOffset()) + " characters processed");
            }
            if (event.getActualEndOffset() > endOffsetUpperEstimate) {
                LOG.error("Unexpected error at soft wrap recalculation", new Attachment[]{new Attachment("softWrapModel.txt", this.myEditor.getSoftWrapModel().toString())});
            }
            this.notifyListenersOnCacheUpdateEnd(event);
            this.myEventBeingProcessed = null;
        }
        finally {
            this.myInProgress = false;
        }
        Project project = this.myEditor.getProject();
        VirtualFile file2 = this.myEditor.getVirtualFile();
        if (project != null && file2 != null && this.myEditor.getUserData(EditorImpl.FORCED_SOFT_WRAPS) != null) {
            if (this.myStorage.isEmpty()) {
                this.myEditor.putUserData(EditorImpl.SOFT_WRAPS_EXIST, null);
            } else if (this.myEditor.getUserData(EditorImpl.SOFT_WRAPS_EXIST) == null) {
                this.myEditor.putUserData(EditorImpl.SOFT_WRAPS_EXIST, Boolean.TRUE);
                EditorNotifications.getInstance((Project)project).updateNotifications(file2);
            }
        }
    }

    private void doRecalculateSoftWraps(IncrementalCacheUpdateEvent event, int endOffsetUpperEstimate) {
        this.myContext.reset();
        this.myOffset2fontType.clear();
        this.myOffset2widthInPixels.clear();
        EditorTextRepresentationHelper editorTextRepresentationHelper = SoftWrapModelImpl.getEditorTextRepresentationHelper(this.myEditor);
        if (editorTextRepresentationHelper instanceof DefaultEditorTextRepresentationHelper) {
            ((DefaultEditorTextRepresentationHelper)editorTextRepresentationHelper).updateContext();
        }
        int start2 = event.getStartOffset();
        LogicalPosition logical = event.getStartLogicalPosition();
        DocumentEx document = this.myEditor.getDocument();
        this.myContext.text = document.getCharsSequence();
        this.myContext.tokenStartOffset = start2;
        IterationState iterationState = new IterationState(this.myEditor, start2, document.getTextLength(), null, false, false, true, false);
        TextAttributes attributes = iterationState.getMergedAttributes();
        this.myContext.fontType = SoftWrapApplianceManager.normalizeFontType(attributes.getFontType());
        this.myContext.rangeEndOffset = event.getMandatoryEndOffset();
        EditorPosition position = new EditorPosition(logical, start2, this.myEditor);
        position.x = start2 == 0 ? this.myEditor.getPrefixTextWidthInPixels() : 0;
        int spaceWidth = EditorUtil.getSpaceWidth(this.myContext.fontType, this.myEditor);
        int plainSpaceWidth = EditorUtil.getSpaceWidth(0, this.myEditor);
        this.myContext.logicalLineData.update(logical.line, spaceWidth, plainSpaceWidth);
        this.myContext.currentPosition = position;
        this.myContext.lineStartPosition = position.clone();
        this.myContext.fontType2spaceWidth.put(this.myContext.fontType, spaceWidth);
        this.myContext.softWrapStartOffset = position.offset;
        this.myContext.reservedWidthInPixels = this.myPainter.getMinDrawingWidth(SoftWrapDrawingType.BEFORE_SOFT_WRAP_LINE_FEED);
        SoftWrap softWrapAtStartPosition = this.myStorage.getSoftWrap(start2);
        if (softWrapAtStartPosition != null) {
            this.myContext.currentPosition.x = softWrapAtStartPosition.getIndentInPixels();
            ++this.myContext.softWrapStartOffset;
        }
        this.myContext.inlineInlays = this.myEditor.getInlayModel().getInlineElementsInRange(start2, endOffsetUpperEstimate);
        this.myContext.afterLineEndInlays = this.myEditor.getInlayModel().getAfterLineEndElementsInRange(DocumentUtil.getLineStartOffset(start2, document), endOffsetUpperEstimate);
        while (!iterationState.atEnd()) {
            FoldRegion currentFold = iterationState.getCurrentFold();
            if (currentFold == null) {
                this.myContext.tokenEndOffset = iterationState.getEndOffset();
                this.myContext.nextIsFoldRegion = iterationState.nextIsFoldRegion();
                if (this.processNonFoldToken()) {
                    break;
                }
            } else {
                if (this.processCollapsedFoldRegion(currentFold)) break;
                this.myOffset2widthInPixels.clear();
            }
            iterationState.advance();
            attributes = iterationState.getMergedAttributes();
            this.myContext.fontType = SoftWrapApplianceManager.normalizeFontType(attributes.getFontType());
            this.myContext.tokenStartOffset = iterationState.getStartOffset();
            this.myOffset2fontType.fill(this.myContext.tokenStartOffset, iterationState.getEndOffset(), this.myContext.fontType);
        }
        if (this.myContext.delayedSoftWrap != null) {
            this.myStorage.remove(this.myContext.delayedSoftWrap);
        }
        event.setActualEndOffset(this.myContext.currentPosition.offset);
    }

    @JdkConstants.FontStyle
    private static int normalizeFontType(int fontType) {
        return fontType & 3;
    }

    private void doRecalculateSoftWrapsRoughly(IncrementalCacheUpdateEvent event) {
        DocumentEx document = this.myEditor.getDocument();
        int lineCount = document.getLineCount();
        int offset = event.getStartOffset();
        int line = document.getLineNumber(offset);
        int mandatoryEnd = event.getMandatoryEndOffset();
        while (true) {
            if ((offset += 1000) >= document.getLineEndOffset(line)) {
                if (++line >= lineCount) {
                    offset = document.getTextLength();
                } else {
                    offset = document.getLineStartOffset(line);
                    if (offset <= mandatoryEnd || this.myEditor.getFoldingModel().getCollapsedRegionAtOffset(offset - 1) != null) continue;
                }
                break;
            }
            FoldRegion foldRegion = this.myEditor.getFoldingModel().getCollapsedRegionAtOffset(offset);
            if (foldRegion != null) {
                offset = foldRegion.getEndOffset();
                line = document.getLineNumber(offset);
            }
            if (DocumentUtil.isInsideSurrogatePair(document, offset)) {
                ++offset;
            }
            if (offset >= document.getLineEndOffset(line)) continue;
            SoftWrapImpl wrap = new SoftWrapImpl(new TextChangeImpl("\n", offset), 1, 1);
            this.myStorage.storeOrReplace(wrap);
            if (offset > mandatoryEnd && this.myDataMapper.matchesOldSoftWrap(wrap, event.getLengthDiff())) break;
        }
        event.setActualEndOffset(offset);
    }

    private int getEndOffsetUpperEstimate(IncrementalCacheUpdateEvent event) {
        int endOffsetUpperEstimate = EditorUtil.getNotFoldedLineEndOffset(this.myEditor, event.getMandatoryEndOffset());
        int line = this.myEditor.getDocument().getLineNumber(endOffsetUpperEstimate);
        if (line < this.myEditor.getDocument().getLineCount() - 1) {
            endOffsetUpperEstimate = this.myEditor.getDocument().getLineStartOffset(line + 1);
        }
        return endOffsetUpperEstimate;
    }

    private boolean processCollapsedFoldRegion(FoldRegion foldRegion) {
        int newX;
        int c;
        DocumentEx document = this.myEditor.getDocument();
        if (!foldRegion.isValid() || foldRegion.getStartOffset() != this.myContext.tokenStartOffset || foldRegion.getEndOffset() > document.getTextLength()) {
            LOG.error("Inconsistent fold region state: fold region: " + foldRegion + ", soft wrap model state: " + this.myEditor.getSoftWrapModel() + ", folding model state: " + this.myEditor.getFoldingModel());
            return true;
        }
        String placeholder = foldRegion.getPlaceholderText();
        int placeholderWidthInPixels = 0;
        for (int i = 0; i < placeholder.length(); ++i) {
            c = placeholder.charAt(i);
            if (c == 10) {
                c = 32;
            }
            placeholderWidthInPixels += SoftWrapModelImpl.getEditorTextRepresentationHelper(this.myEditor).charWidth(c, this.myContext.fontType);
        }
        if (!(this.myContext.delayedSoftWrap != null || this.myContext.exceedsVisualEdge(newX = this.myContext.currentPosition.x + placeholderWidthInPixels) && this.myContext.currentPosition.offset != this.myContext.lineStartPosition.offset)) {
            this.myContext.advance(foldRegion, placeholderWidthInPixels);
            return false;
        }
        this.myContext.logicalLineData.update(foldRegion.getStartOffset());
        SoftWrapImpl softWrap = null;
        if (this.myContext.delayedSoftWrap == null && this.myContext.exceedsVisualEdge(this.myContext.currentPosition.x + this.myContext.reservedWidthInPixels)) {
            softWrap = this.registerSoftWrap(this.myContext.softWrapStartOffset, this.myContext.tokenStartOffset, this.myContext.tokenStartOffset, this.myContext.getSpaceWidth(), this.myContext.logicalLineData);
        }
        if (this.myContext.delayedSoftWrap != null) {
            this.myStorage.remove(this.myContext.delayedSoftWrap);
            this.myContext.delayedSoftWrap = null;
        }
        if (softWrap == null) {
            softWrap = this.registerSoftWrap(foldRegion.getStartOffset(), this.myContext.getSpaceWidth(), this.myContext.logicalLineData);
        }
        this.myContext.softWrapStartOffset = softWrap.getStart();
        if (softWrap.getStart() < this.myContext.tokenStartOffset) {
            for (int j = foldRegion.getStartOffset() - 1; j >= softWrap.getStart(); --j) {
                --this.myContext.currentPosition.offset;
            }
        }
        this.myContext.currentPosition.x = softWrap.getIndentInPixels();
        this.myContext.clearLastFoldInfo();
        this.myContext.skipToLineEnd = false;
        if (this.checkIsDoneAfterSoftWrap()) {
            return true;
        }
        while (this.myContext.currentPosition.offset < this.myContext.tokenStartOffset) {
            c = Character.codePointAt(this.myContext.text, this.myContext.currentPosition.offset);
            this.myContext.onNonLineFeedSymbol(c, this.calculateNewX(c));
        }
        this.myOffset2fontType.clear();
        this.myContext.advance(foldRegion, placeholderWidthInPixels);
        return false;
    }

    private boolean processNonFoldToken() {
        int limit = 3 * (this.myContext.tokenEndOffset - this.myContext.lineStartPosition.offset);
        int counter = 0;
        int startOffset = this.myContext.currentPosition.offset;
        while (this.myContext.currentPosition.offset < this.myContext.tokenEndOffset) {
            int c;
            if (counter++ > limit) {
                LOG.error("Cycled soft wraps recalculation detected", new Throwable(), new Attachment[]{AttachmentFactory.createContext(String.format("Start recalculation offset: %d, visible area width: %d, calculation context: %s, editor info: %s", startOffset, this.myVisibleAreaWidth, this.myContext, this.myEditor.dumpState()), new Object[0])});
                while (this.myContext.currentPosition.offset < this.myContext.tokenEndOffset) {
                    int c2 = Character.codePointAt(this.myContext.text, this.myContext.currentPosition.offset);
                    if (c2 == 10) {
                        this.myContext.onNewLine();
                        if (!this.checkIsDoneAfterNewLine()) continue;
                        return true;
                    }
                    this.myContext.onNonLineFeedSymbol(c2);
                }
                return false;
            }
            int offset = this.myContext.currentPosition.offset;
            if (this.myContext.delayedSoftWrap != null && this.myContext.delayedSoftWrap.getStart() == offset) {
                this.processSoftWrap(this.myContext.delayedSoftWrap);
                this.myContext.delayedSoftWrap = null;
                if (this.checkIsDoneAfterSoftWrap()) {
                    return true;
                }
            }
            if ((c = Character.codePointAt(this.myContext.text, offset)) == 10) {
                this.myContext.onNewLine();
                if (!this.checkIsDoneAfterNewLine()) continue;
                return true;
            }
            if (this.myContext.skipToLineEnd) {
                this.myContext.skipToLineEnd = false;
                if (!this.createSoftWrapIfPossible()) continue;
                return true;
            }
            int[] metrics = this.offsetToX(offset, c);
            if (this.myContext.exceedsVisualEdge(metrics[0]) && this.myContext.delayedSoftWrap == null) {
                if (!this.createSoftWrapIfPossible()) continue;
                return true;
            }
            this.myContext.onNonLineFeedSymbol(c, metrics);
        }
        return false;
    }

    private boolean checkIsDoneAfterNewLine() {
        return this.myContext.currentPosition.offset > this.myContext.rangeEndOffset;
    }

    private boolean checkIsDoneAfterSoftWrap() {
        SoftWrapImpl lastSoftWrap = this.myDataMapper.getLastSoftWrap();
        LOG.assertTrue(lastSoftWrap != null);
        return this.myContext.currentPosition.offset > this.myContext.rangeEndOffset && this.myDataMapper.matchesOldSoftWrap(lastSoftWrap, this.myEventBeingProcessed.getLengthDiff());
    }

    private int[] offsetToX(int offset, int c) {
        if (this.myOffset2widthInPixels.end > offset && this.myOffset2widthInPixels.anchor + this.myOffset2widthInPixels.end > offset) {
            int width = this.myOffset2widthInPixels.data[offset - this.myOffset2widthInPixels.anchor];
            return new int[]{this.myContext.currentPosition.x + width + this.myContext.getInlaysWidth(), width};
        }
        return this.calculateNewX(c);
    }

    private boolean createSoftWrapIfPossible() {
        int offset = this.myContext.currentPosition.offset;
        this.myContext.logicalLineData.update(offset);
        int softWrapStartOffset = this.myContext.softWrapStartOffset;
        int preferredOffset = Math.max(softWrapStartOffset, offset - 1);
        SoftWrapImpl softWrap = this.registerSoftWrap(softWrapStartOffset, preferredOffset, this.myContext.logicalLineData.endLineOffset, this.myContext.getSpaceWidth(), this.myContext.logicalLineData);
        FoldRegion revertedToFoldRegion = null;
        if (softWrap == null) {
            EditorPosition wrapPosition = null;
            if (this.myContext.lastFoldEndPosition != null && this.myStorage.getSoftWrap(this.myContext.lastFoldEndPosition.offset) == null) {
                wrapPosition = this.myContext.lastFoldEndPosition;
            }
            if (wrapPosition == null && this.myContext.lastFoldStartPosition != null && this.myStorage.getSoftWrap(this.myContext.lastFoldStartPosition.offset) == null && this.myContext.lastFoldStartPosition.offset < this.myContext.currentPosition.offset) {
                wrapPosition = this.myContext.lastFoldStartPosition;
            }
            if (wrapPosition != null) {
                this.myContext.currentPosition = wrapPosition;
                softWrap = this.registerSoftWrap(wrapPosition.offset, this.myContext.getSpaceWidth(), this.myContext.logicalLineData);
                this.myContext.tokenStartOffset = wrapPosition.offset;
                revertedToFoldRegion = this.myContext.lastFold;
            } else {
                return this.myContext.tryToShiftToNextLine();
            }
        }
        this.myContext.skipToLineEnd = false;
        int actualSoftWrapOffset = softWrap.getStart();
        if (actualSoftWrapOffset > this.myContext.tokenEndOffset) {
            this.myContext.delayedSoftWrap = softWrap;
            this.myContext.onNonLineFeedSymbol(Character.codePointAt(this.myContext.text, offset));
            return false;
        }
        if (actualSoftWrapOffset < offset) {
            if (revertedToFoldRegion == null) {
                while (this.myContext.currentPosition.offset > actualSoftWrapOffset) {
                    int prevOffset = Character.offsetByCodePoints(this.myContext.text, this.myContext.currentPosition.offset, -1);
                    int pixelsDiff = this.myOffset2widthInPixels.data[prevOffset - this.myOffset2widthInPixels.anchor];
                    this.myContext.currentPosition.offset = prevOffset;
                    this.myContext.currentPosition.x -= pixelsDiff;
                }
            }
        } else if (actualSoftWrapOffset > offset) {
            while (this.myContext.currentPosition.offset < actualSoftWrapOffset) {
                this.myContext.onNonLineFeedSymbol(Character.codePointAt(this.myContext.text, this.myContext.currentPosition.offset));
            }
        }
        this.processSoftWrap(softWrap);
        this.myContext.currentPosition.offset = actualSoftWrapOffset;
        this.myOffset2fontType.clear();
        this.myOffset2widthInPixels.clear();
        if (this.checkIsDoneAfterSoftWrap()) {
            return true;
        }
        if (revertedToFoldRegion != null && this.myContext.currentPosition.offset == revertedToFoldRegion.getStartOffset()) {
            return this.processCollapsedFoldRegion(revertedToFoldRegion);
        }
        return false;
    }

    private int[] calculateNewX(int c) {
        if (c == 9) {
            int xStart = this.myContext.currentPosition.x + this.myContext.getInlaysPrefixWidth();
            int xEnd = EditorUtil.nextTabStop(xStart, this.myEditor);
            return new int[]{xEnd + this.myContext.getInlaysSuffixWidth(), xEnd - xStart};
        }
        int width = SoftWrapModelImpl.getEditorTextRepresentationHelper(this.myEditor).charWidth(c, this.myContext.fontType);
        return new int[]{this.myContext.currentPosition.x + width + this.myContext.getInlaysWidth(), width};
    }

    private static int calculateWidthInColumns(char c, int widthInPixels, int plainSpaceWithInPixels) {
        if (c != '\t') {
            return 1;
        }
        int result2 = widthInPixels / plainSpaceWithInPixels;
        if (widthInPixels % plainSpaceWithInPixels > 0) {
            ++result2;
        }
        return result2;
    }

    @Nullable
    private SoftWrapImpl registerSoftWrap(int minOffset, int preferredOffset, int maxOffset, int spaceSize, LogicalLineData lineData) {
        int softWrapOffset = this.calculateBackwardSpaceOffsetIfPossible(minOffset, preferredOffset);
        if (softWrapOffset < 0) {
            softWrapOffset = this.calculateBackwardOffsetForEasternLanguageIfPossible(minOffset, preferredOffset);
        }
        if (softWrapOffset < 0) {
            DocumentEx document = this.myEditor.getDocument();
            if (this.myLineWrapPositionStrategy == null) {
                this.myLineWrapPositionStrategy = LanguageLineWrapPositionStrategy.INSTANCE.forEditor((Editor)this.myEditor);
            }
            if (DocumentUtil.isInsideSurrogatePair(document, softWrapOffset = this.myLineWrapPositionStrategy.calculateWrapPosition((Document)document, this.myEditor.getProject(), minOffset, maxOffset, preferredOffset, true, true))) {
                --softWrapOffset;
            }
        }
        if (softWrapOffset >= lineData.endLineOffset || softWrapOffset < 0 || softWrapOffset <= minOffset || this.myCustomIndentUsedLastTime && softWrapOffset == lineData.nonWhiteSpaceSymbolOffset || softWrapOffset > preferredOffset && this.myContext.lastFoldStartPosition != null && this.myContext.lastFoldStartPosition.offset <= preferredOffset) {
            return null;
        }
        return this.registerSoftWrap(softWrapOffset, spaceSize, lineData);
    }

    @NotNull
    private SoftWrapImpl registerSoftWrap(int offset, int spaceSize, LogicalLineData lineData) {
        assert (!DocumentUtil.isInsideSurrogatePair(this.myEditor.getDocument(), offset));
        int indentInColumns = 0;
        int indentInPixels = this.myPainter.getMinDrawingWidth(SoftWrapDrawingType.AFTER_SOFT_WRAP);
        if (this.myCustomIndentUsedLastTime) {
            indentInColumns = this.myCustomIndentValueUsedLastTime + lineData.indentInColumns;
            indentInPixels += lineData.indentInPixels + this.myCustomIndentValueUsedLastTime * spaceSize;
        }
        SoftWrapImpl result2 = new SoftWrapImpl(new TextChangeImpl("\n" + StringUtil.repeatSymbol((char)' ', (int)indentInColumns), offset, offset), indentInColumns + 1, indentInPixels);
        this.myStorage.storeOrReplace(result2);
        return result2;
    }

    private int calculateBackwardSpaceOffsetIfPossible(int minOffset, int preferredOffset) {
        int maxTrackBackSymbolsNumber = 10;
        int minOffsetToUse = minOffset;
        if (preferredOffset - minOffset > maxTrackBackSymbolsNumber) {
            minOffsetToUse = preferredOffset - maxTrackBackSymbolsNumber;
        }
        for (int i = preferredOffset - 1; i >= minOffsetToUse; --i) {
            char c = this.myContext.text.charAt(i);
            if (c != ' ') continue;
            return i + 1;
        }
        return -1;
    }

    private int calculateBackwardOffsetForEasternLanguageIfPossible(int minOffset, int preferredOffset) {
        int maxTrackBackSymbolsNumber = 10;
        int minOffsetToUse = minOffset;
        if (preferredOffset - minOffset > maxTrackBackSymbolsNumber) {
            minOffsetToUse = preferredOffset - maxTrackBackSymbolsNumber;
        }
        for (int i = preferredOffset - 1; i >= minOffsetToUse; --i) {
            char c = this.myContext.text.charAt(i);
            if (c < '\u2f00' || !Character.isBmpCodePoint(Character.codePointAt(this.myContext.text, i))) continue;
            return i + 1;
        }
        return -1;
    }

    private void processSoftWrap(SoftWrap softWrap) {
        EditorPosition position = this.myContext.currentPosition;
        this.myContext.lineStartPosition.from(this.myContext.currentPosition);
        position.x = softWrap.getIndentInPixels();
        this.myContext.softWrapStartOffset = softWrap.getStart() + 1;
        this.myContext.clearLastFoldInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean recalculateIfNecessary() {
        int softWrapsNow;
        if (this.myInProgress) {
            return false;
        }
        boolean indentChanged = false;
        IndentType currentIndentType = this.getIndentToUse();
        boolean useCustomIndent = currentIndentType == IndentType.CUSTOM;
        int currentCustomIndent = this.myEditor.getSettings().getCustomSoftWrapIndent();
        if (useCustomIndent ^ this.myCustomIndentUsedLastTime || useCustomIndent && this.myCustomIndentValueUsedLastTime != currentCustomIndent) {
            indentChanged = true;
        }
        this.myCustomIndentUsedLastTime = useCustomIndent;
        this.myCustomIndentValueUsedLastTime = currentCustomIndent;
        int currentVisibleAreaWidth = this.myAvailableWidth;
        if (!indentChanged && this.myVisibleAreaWidth == currentVisibleAreaWidth) {
            return this.recalculateSoftWraps();
        }
        JScrollBar scrollBar = this.myEditor.getScrollPane().getVerticalScrollBar();
        int verticalScrollBarWidth = scrollBar.getWidth();
        if (verticalScrollBarWidth <= 0) {
            verticalScrollBarWidth = scrollBar.getPreferredSize().width;
        }
        if (Math.abs(currentVisibleAreaWidth - this.myVisibleAreaWidth) == verticalScrollBarWidth) {
            this.myVisibleAreaWidth = currentVisibleAreaWidth;
            return this.recalculateSoftWraps();
        }
        int softWrapsBefore = -1;
        ScrollingModelEx scrollingModel = this.myEditor.getScrollingModel();
        int yScrollOffset = scrollingModel.getVerticalScrollOffset();
        int anchorOffset = this.myLastTopLeftCornerOffset;
        if (this.myVisibleAreaWidth != Integer.MAX_VALUE) {
            softWrapsBefore = this.getNumberOfSoftWrapsBefore(anchorOffset);
        }
        this.reset();
        this.myStorage.removeAll();
        this.myVisibleAreaWidth = currentVisibleAreaWidth;
        boolean result2 = this.recalculateSoftWraps();
        if (!result2) {
            return false;
        }
        if (softWrapsBefore >= 0 && (softWrapsNow = this.getNumberOfSoftWrapsBefore(anchorOffset)) != softWrapsBefore) {
            scrollingModel.disableAnimation();
            try {
                scrollingModel.scrollVertically(yScrollOffset + (softWrapsNow - softWrapsBefore) * this.myEditor.getLineHeight());
            }
            finally {
                scrollingModel.enableAnimation();
            }
        }
        this.updateLastTopLeftCornerOffset();
        return true;
    }

    private void updateLastTopLeftCornerOffset() {
        int visualLine = 1 + this.myEditor.getScrollingModel().getVisibleArea().y / this.myEditor.getLineHeight();
        this.myLastTopLeftCornerOffset = this.myEditor.visualLineStartOffset(visualLine);
    }

    private int getNumberOfSoftWrapsBefore(int offset) {
        int i = this.myStorage.getSoftWrapIndex(offset);
        return i >= 0 ? i : -i - 1;
    }

    private IndentType getIndentToUse() {
        return this.myEditor.getSettings().isUseCustomSoftWrapIndent() ? IndentType.CUSTOM : IndentType.NONE;
    }

    public boolean addListener(@NotNull SoftWrapAwareDocumentParsingListener listener2) {
        return this.myListeners.add(listener2);
    }

    public boolean removeListener(@NotNull SoftWrapAwareDocumentParsingListener listener2) {
        return this.myListeners.remove(listener2);
    }

    private void notifyListenersOnCacheUpdateStart(IncrementalCacheUpdateEvent event) {
        for (int i = 0; i < this.myListeners.size(); ++i) {
            SoftWrapAwareDocumentParsingListener listener2 = this.myListeners.get(i);
            listener2.onCacheUpdateStart(event);
        }
    }

    private void notifyListenersOnCacheUpdateEnd(IncrementalCacheUpdateEvent event) {
        for (int i = 0; i < this.myListeners.size(); ++i) {
            SoftWrapAwareDocumentParsingListener listener2 = this.myListeners.get(i);
            listener2.onRecalculationEnd(event);
        }
    }

    public void beforeDocumentChange(DocumentEvent event) {
        this.myDocumentChangedEvent = new IncrementalCacheUpdateEvent(event, this.myEditor);
    }

    public void documentChanged(DocumentEvent event, boolean processAlsoLineEnd) {
        int lineEndOffset;
        LOG.assertTrue(this.myDocumentChangedEvent != null);
        this.recalculate(this.myDocumentChangedEvent);
        if (processAlsoLineEnd && (lineEndOffset = DocumentUtil.getLineEndOffset(this.myDocumentChangedEvent.getMandatoryEndOffset(), event.getDocument())) > this.myDocumentChangedEvent.getActualEndOffset()) {
            this.recalculate(new IncrementalCacheUpdateEvent(lineEndOffset, lineEndOffset, this.myEditor));
        }
        this.myDocumentChangedEvent = null;
    }

    public void setWidthProvider(@NotNull VisibleAreaWidthProvider widthProvider) {
        this.myWidthProvider = widthProvider;
        this.reset();
    }

    @NotNull
    public String dumpState() {
        return String.format("recalculation in progress: %b; event being processed: %s, available width: %d, visible width: %d, dirty: %b", this.myInProgress, this.myEventBeingProcessed, this.myAvailableWidth, this.myVisibleAreaWidth, this.myIsDirty);
    }

    public String toString() {
        return this.dumpState();
    }

    public void setSoftWrapPainter(SoftWrapPainter painter) {
        this.myPainter = painter;
    }

    public void updateAvailableArea() {
        Rectangle visibleArea = this.myEditor.getScrollingModel().getVisibleArea();
        if (visibleArea.isEmpty()) {
            return;
        }
        int width = this.myWidthProvider.getVisibleAreaWidth();
        if (width <= 0) {
            return;
        }
        this.myAvailableWidth = width;
    }

    private static class PrimitiveIntMap {
        private int[] myData = new int[16];
        private int myShift;

        private PrimitiveIntMap() {
        }

        public int get(int key) {
            int index = key + this.myShift;
            if (index < 0 || index >= this.myData.length) {
                return -1;
            }
            return this.myData[index];
        }

        public void put(int key, int value) {
            int index = key + this.myShift;
            if (index < 0) {
                int[] tmp = new int[this.myData.length - index];
                System.arraycopy(this.myData, 0, tmp, -index, this.myData.length);
                this.myData = tmp;
                this.myShift -= index;
                index = 0;
            }
            this.myData[index] = value;
        }

        public void reset() {
            this.myShift = 0;
            Arrays.fill(this.myData, 0);
        }
    }

    private class ProcessingContext {
        final PrimitiveIntMap fontType2spaceWidth = new PrimitiveIntMap();
        final LogicalLineData logicalLineData = new LogicalLineData();
        CharSequence text;
        EditorPosition lineStartPosition;
        EditorPosition currentPosition;
        EditorPosition lastFoldStartPosition;
        EditorPosition lastFoldEndPosition;
        FoldRegion lastFold;
        SoftWrapImpl delayedSoftWrap;
        int reservedWidthInPixels;
        int softWrapStartOffset;
        int rangeEndOffset;
        int tokenStartOffset;
        int tokenEndOffset;
        boolean nextIsFoldRegion;
        @JdkConstants.FontStyle
        int fontType;
        boolean skipToLineEnd;
        List<Inlay> inlineInlays;
        int inlineInlayIndex;
        List<Inlay> afterLineEndInlays;
        int afterLineEndInlayIndex;

        private ProcessingContext() {
        }

        public String toString() {
            return "reserved width: " + this.reservedWidthInPixels + ", soft wrap start offset: " + this.softWrapStartOffset + ", range end offset: " + this.rangeEndOffset + ", token offsets: [" + this.tokenStartOffset + "; " + this.tokenEndOffset + "], font type: " + this.fontType + ", skip to line end: " + this.skipToLineEnd + ", delayed soft wrap: " + this.delayedSoftWrap + ", current position: " + this.currentPosition + "line start position: " + this.lineStartPosition;
        }

        public void reset() {
            this.text = null;
            this.lineStartPosition = null;
            this.currentPosition = null;
            this.clearLastFoldInfo();
            this.delayedSoftWrap = null;
            this.reservedWidthInPixels = 0;
            this.softWrapStartOffset = 0;
            this.rangeEndOffset = 0;
            this.tokenStartOffset = 0;
            this.tokenEndOffset = 0;
            this.nextIsFoldRegion = false;
            this.fontType = 0;
            this.skipToLineEnd = false;
            this.fontType2spaceWidth.reset();
            this.logicalLineData.reset();
            this.inlineInlays = null;
            this.inlineInlayIndex = 0;
            this.afterLineEndInlays = null;
            this.afterLineEndInlayIndex = 0;
        }

        int getSpaceWidth() {
            return this.getSpaceWidth(this.fontType);
        }

        int getPlainSpaceWidth() {
            return this.getSpaceWidth(0);
        }

        private int getSpaceWidth(@JdkConstants.FontStyle int fontType) {
            int result2 = this.fontType2spaceWidth.get(fontType);
            if (result2 <= 0) {
                result2 = EditorUtil.getSpaceWidth(fontType, SoftWrapApplianceManager.this.myEditor);
                this.fontType2spaceWidth.put(fontType, result2);
            }
            assert (result2 > 0);
            return result2;
        }

        void onNewLine() {
            this.currentPosition.onNewLine();
            this.softWrapStartOffset = this.currentPosition.offset;
            this.clearLastFoldInfo();
            this.lineStartPosition.from(this.currentPosition);
            this.logicalLineData.update(this.currentPosition.logicalLine, this.getSpaceWidth(), this.getPlainSpaceWidth());
            this.fontType = SoftWrapApplianceManager.this.myOffset2fontType.get(this.currentPosition.offset);
            SoftWrapApplianceManager.this.myOffset2fontType.clear();
            SoftWrapApplianceManager.this.myOffset2widthInPixels.clear();
            this.skipToLineEnd = false;
        }

        private void clearLastFoldInfo() {
            this.lastFoldStartPosition = null;
            this.lastFoldEndPosition = null;
            this.lastFold = null;
        }

        void onNonLineFeedSymbol(int c) {
            int[] metrics;
            if (((SoftWrapApplianceManager)SoftWrapApplianceManager.this).myOffset2widthInPixels.end > ((SoftWrapApplianceManager)SoftWrapApplianceManager.this).myContext.currentPosition.offset && ((SoftWrapApplianceManager)SoftWrapApplianceManager.this).myOffset2widthInPixels.anchor + ((SoftWrapApplianceManager)SoftWrapApplianceManager.this).myOffset2widthInPixels.end > ((SoftWrapApplianceManager)SoftWrapApplianceManager.this).myContext.currentPosition.offset) {
                int width = ((SoftWrapApplianceManager)SoftWrapApplianceManager.this).myOffset2widthInPixels.data[((SoftWrapApplianceManager)SoftWrapApplianceManager.this).myContext.currentPosition.offset - ((SoftWrapApplianceManager)SoftWrapApplianceManager.this).myOffset2widthInPixels.anchor];
                metrics = new int[]{((SoftWrapApplianceManager)SoftWrapApplianceManager.this).myContext.currentPosition.x + width + this.getInlaysWidth(), width};
            } else {
                metrics = SoftWrapApplianceManager.this.calculateNewX(c);
            }
            this.onNonLineFeedSymbol(c, metrics);
        }

        void onNonLineFeedSymbol(int codePoint, int[] metrics) {
            if (((SoftWrapApplianceManager)SoftWrapApplianceManager.this).myOffset2widthInPixels.anchor <= 0) {
                ((SoftWrapApplianceManager)SoftWrapApplianceManager.this).myOffset2widthInPixels.anchor = this.currentPosition.offset;
            }
            if (this.currentPosition.offset - ((SoftWrapApplianceManager)SoftWrapApplianceManager.this).myOffset2widthInPixels.anchor >= ((SoftWrapApplianceManager)SoftWrapApplianceManager.this).myOffset2widthInPixels.data.length) {
                int newLength = Math.max(((SoftWrapApplianceManager)SoftWrapApplianceManager.this).myOffset2widthInPixels.data.length * 2, this.currentPosition.offset - ((SoftWrapApplianceManager)SoftWrapApplianceManager.this).myOffset2widthInPixels.anchor + 1);
                int[] newData = new int[newLength];
                System.arraycopy(((SoftWrapApplianceManager)SoftWrapApplianceManager.this).myOffset2widthInPixels.data, 0, newData, 0, ((SoftWrapApplianceManager)SoftWrapApplianceManager.this).myOffset2widthInPixels.data.length);
                ((SoftWrapApplianceManager)SoftWrapApplianceManager.this).myOffset2widthInPixels.data = newData;
            }
            ((SoftWrapApplianceManager)SoftWrapApplianceManager.this).myOffset2widthInPixels.data[this.currentPosition.offset - ((SoftWrapApplianceManager)SoftWrapApplianceManager.this).myOffset2widthInPixels.anchor] = metrics[1];
            ++((SoftWrapApplianceManager)SoftWrapApplianceManager.this).myOffset2widthInPixels.end;
            this.currentPosition.x = metrics[0];
            this.currentPosition.offset = this.currentPosition.offset + (Character.isBmpCodePoint(codePoint) ? 1 : 2);
            this.fontType = SoftWrapApplianceManager.this.myOffset2fontType.get(this.currentPosition.offset);
        }

        private int getInlaysWidth() {
            return this.getInlaysPrefixWidth() + this.getInlaysSuffixWidth();
        }

        private int getInlaysPrefixWidth() {
            return this.getInlaysWidthForOffset(this.currentPosition.offset);
        }

        private int getInlaysWidthForOffset(int offset) {
            while (this.inlineInlayIndex < this.inlineInlays.size() && this.inlineInlays.get(this.inlineInlayIndex).getOffset() < offset) {
                ++this.inlineInlayIndex;
            }
            while (this.inlineInlayIndex > 0 && this.inlineInlays.get(this.inlineInlayIndex - 1).getOffset() >= offset) {
                --this.inlineInlayIndex;
            }
            int width = 0;
            while (this.inlineInlayIndex < this.inlineInlays.size() && this.inlineInlays.get(this.inlineInlayIndex).getOffset() == offset) {
                width += this.inlineInlays.get(this.inlineInlayIndex++).getWidthInPixels();
            }
            return width;
        }

        private int getInlaysSuffixWidth() {
            int nextOffset = this.currentPosition.offset + 1;
            return nextOffset < this.text.length() && this.text.charAt(nextOffset) != '\n' || nextOffset > this.tokenEndOffset || nextOffset == this.tokenEndOffset && this.nextIsFoldRegion ? 0 : this.getInlaysWidthForOffset(nextOffset) + this.getAfterLineEndInlaysWidth(this.currentPosition.logicalLine);
        }

        private int getAfterLineEndInlaysWidth(int logicalLine) {
            Inlay inlay;
            int offset;
            int startOffset = SoftWrapApplianceManager.this.myEditor.getDocument().getLineStartOffset(logicalLine);
            int endOffset = SoftWrapApplianceManager.this.myEditor.getDocument().getLineEndOffset(logicalLine);
            while (this.afterLineEndInlayIndex < this.afterLineEndInlays.size() && this.afterLineEndInlays.get(this.afterLineEndInlayIndex).getOffset() < startOffset) {
                ++this.afterLineEndInlayIndex;
            }
            while (this.afterLineEndInlayIndex > 0 && this.afterLineEndInlays.get(this.afterLineEndInlayIndex - 1).getOffset() >= startOffset) {
                --this.afterLineEndInlayIndex;
            }
            int width = 0;
            while (this.afterLineEndInlayIndex < this.afterLineEndInlays.size() && (offset = (inlay = this.afterLineEndInlays.get(this.afterLineEndInlayIndex)).getOffset()) >= startOffset && offset <= endOffset) {
                width += inlay.getWidthInPixels();
                ++this.afterLineEndInlayIndex;
            }
            return width;
        }

        private void advance(FoldRegion foldRegion, int placeHolderWidthInPixels) {
            this.lastFoldStartPosition = this.currentPosition.clone();
            this.lastFold = foldRegion;
            int logicalLineBefore = this.currentPosition.logicalLine;
            this.currentPosition.advance(foldRegion);
            this.currentPosition.x += placeHolderWidthInPixels;
            if (this.currentPosition.logicalLine > logicalLineBefore) {
                DocumentEx document = SoftWrapApplianceManager.this.myEditor.getDocument();
                int endFoldLine = document.getLineNumber(foldRegion.getEndOffset());
                this.logicalLineData.endLineOffset = document.getLineEndOffset(endFoldLine);
            }
            this.tokenStartOffset = ((SoftWrapApplianceManager)SoftWrapApplianceManager.this).myContext.currentPosition.offset;
            this.softWrapStartOffset = foldRegion.getEndOffset();
            this.lastFoldEndPosition = this.currentPosition.clone();
        }

        boolean tryToShiftToNextLine() {
            while (this.currentPosition.offset < this.tokenEndOffset) {
                int c = Character.codePointAt(this.text, this.currentPosition.offset);
                if (c == 10) {
                    this.onNewLine();
                    return SoftWrapApplianceManager.this.checkIsDoneAfterNewLine();
                }
                this.onNonLineFeedSymbol(c, SoftWrapApplianceManager.this.offsetToX(this.currentPosition.offset, c));
            }
            this.skipToLineEnd = true;
            return false;
        }

        boolean exceedsVisualEdge(int x) {
            return x > SoftWrapApplianceManager.this.myVisibleAreaWidth;
        }
    }

    private static class FontTypesStorage {
        private int[] myStarts = new int[256];
        private int[] myEnds = new int[256];
        @JdkConstants.FontStyle
        private int[] myData = new int[256];
        private int myLastIndex = -1;

        private FontTypesStorage() {
        }

        void fill(int start2, int end, @JdkConstants.FontStyle int value) {
            if (this.myLastIndex >= 0 && this.myData[this.myLastIndex] == value && this.myEnds[this.myLastIndex] == start2) {
                this.myEnds[this.myLastIndex] = end;
                return;
            }
            if (++this.myLastIndex >= this.myData.length) {
                this.expand();
            }
            this.myStarts[this.myLastIndex] = start2;
            this.myEnds[this.myLastIndex] = end;
            this.myData[this.myLastIndex] = value;
        }

        @JdkConstants.FontStyle
        public int get(int offset) {
            if (this.myLastIndex < 0) {
                return -1;
            }
            for (int i = this.myLastIndex; i >= 0 && this.myEnds[i] >= offset; --i) {
                if (this.myStarts[i] > offset) continue;
                return this.myData[i];
            }
            return -1;
        }

        public void clear() {
            this.myLastIndex = -1;
        }

        private void expand() {
            int[] tmp = new int[this.myStarts.length * 2];
            System.arraycopy(this.myStarts, 0, tmp, 0, this.myStarts.length);
            this.myStarts = tmp;
            tmp = new int[this.myEnds.length * 2];
            System.arraycopy(this.myEnds, 0, tmp, 0, this.myEnds.length);
            this.myEnds = tmp;
            tmp = new int[this.myData.length * 2];
            System.arraycopy(this.myData, 0, tmp, 0, this.myData.length);
            this.myData = tmp;
        }
    }

    private static class WidthsStorage {
        public int[] data = new int[256];
        public int anchor;
        public int end;

        private WidthsStorage() {
        }

        public void clear() {
            this.anchor = 0;
            this.end = 0;
        }
    }

    private static class DefaultVisibleAreaWidthProvider
    implements VisibleAreaWidthProvider {
        private final EditorImpl myEditor;

        DefaultVisibleAreaWidthProvider(EditorImpl editor) {
            this.myEditor = editor;
        }

        @Override
        public int getVisibleAreaWidth() {
            int rightMargin;
            Insets insets = this.myEditor.getContentComponent().getInsets();
            int width = Math.max(0, this.myEditor.getScrollingModel().getVisibleArea().width - insets.left - insets.right);
            if (this.myEditor.isInDistractionFreeMode() && (rightMargin = this.myEditor.getSettings().getRightMargin(this.myEditor.getProject())) > 0) {
                width = Math.min(width, rightMargin * EditorUtil.getPlainSpaceWidth(this.myEditor));
            }
            return width;
        }
    }

    @FunctionalInterface
    public static interface VisibleAreaWidthProvider {
        public int getVisibleAreaWidth();
    }

    private class LogicalLineData {
        int indentInColumns;
        int indentInPixels;
        int endLineOffset;
        int nonWhiteSpaceSymbolOffset;

        private LogicalLineData() {
        }

        public void update(int logicalLine, int spaceWidth, int plainSpaceWidth) {
            int startLineOffset;
            DocumentEx document = SoftWrapApplianceManager.this.myEditor.getDocument();
            if (logicalLine >= document.getLineCount()) {
                startLineOffset = this.endLineOffset = document.getTextLength();
            } else {
                startLineOffset = document.getLineStartOffset(logicalLine);
                this.endLineOffset = document.getLineEndOffset(logicalLine);
            }
            CharSequence text = document.getCharsSequence();
            this.indentInColumns = 0;
            this.indentInPixels = 0;
            this.nonWhiteSpaceSymbolOffset = -1;
            block4: for (int i = startLineOffset; i < this.endLineOffset; ++i) {
                char c = text.charAt(i);
                switch (c) {
                    case ' ': {
                        ++this.indentInColumns;
                        this.indentInPixels += spaceWidth;
                        continue block4;
                    }
                    case '\t': {
                        int x = EditorUtil.nextTabStop(this.indentInPixels, SoftWrapApplianceManager.this.myEditor);
                        this.indentInColumns += SoftWrapApplianceManager.calculateWidthInColumns(c, x - this.indentInPixels, plainSpaceWidth);
                        this.indentInPixels = x;
                        continue block4;
                    }
                    default: {
                        this.nonWhiteSpaceSymbolOffset = i;
                        return;
                    }
                }
            }
        }

        public void update(int softWrapOffset) {
            if (this.nonWhiteSpaceSymbolOffset >= 0 && softWrapOffset > this.nonWhiteSpaceSymbolOffset) {
                return;
            }
            this.indentInColumns = 0;
            this.indentInPixels = 0;
        }

        public void reset() {
            this.indentInColumns = 0;
            this.indentInPixels = 0;
            this.endLineOffset = 0;
        }
    }

    static enum IndentType {
        NONE,
        CUSTOM;

    }
}

