/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.view;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.SoftWrap;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.FoldingModelImpl;
import com.intellij.openapi.editor.impl.SoftWrapModelImpl;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapDrawingType;
import com.intellij.openapi.editor.impl.view.EditorView;
import com.intellij.openapi.editor.impl.view.VisualLineFragmentsIterator;
import com.intellij.openapi.editor.impl.view.VisualLinesIterator;
import com.intellij.util.DocumentUtil;
import com.intellij.util.ObjectUtils;
import java.awt.geom.Point2D;
import java.util.Iterator;
import java.util.List;
import javax.swing.JScrollBar;
import org.jetbrains.annotations.NotNull;

class EditorCoordinateMapper {
    private final EditorView myView;
    private final Document myDocument;
    private final FoldingModelImpl myFoldingModel;

    EditorCoordinateMapper(EditorView view) {
        this.myView = view;
        this.myDocument = this.myView.getEditor().getDocument();
        this.myFoldingModel = this.myView.getEditor().getFoldingModel();
    }

    int visualLineToY(int line) {
        if (line < 0) {
            line = 0;
        }
        return this.myView.getInsets().top + line * this.myView.getLineHeight() + this.myView.getEditor().getInlayModel().getHeightOfBlockElementsBeforeVisualLine(line);
    }

    int yToVisualLine(int y) {
        int lineHeight = this.myView.getLineHeight();
        if ((y = Math.max(0, y - this.myView.getInsets().top)) < lineHeight) {
            return 0;
        }
        int lineMin = 0;
        int yMin = 0;
        int lineMax = this.myView.getEditor().getVisibleLineCount() - 1;
        int yMax = this.visualLineToY(lineMax + 1);
        if (y >= yMax) {
            return lineMax + 1 + (y - yMax) / lineHeight;
        }
        while (lineMin < lineMax) {
            if (yMax - yMin == (lineMax - lineMin + 1) * lineHeight) {
                return lineMin + (y - yMin) / lineHeight;
            }
            int lineMid = (lineMin + lineMax) / 2;
            int yMid = this.visualLineToY(lineMid);
            if (y < yMid) {
                int yMidMin = yMid - this.getInlaysHeight(lineMid, true);
                if (y >= yMidMin) {
                    return lineMid;
                }
                lineMax = lineMid - 1;
                yMax = yMidMin;
                continue;
            }
            int yMidMax = yMid + lineHeight + this.getInlaysHeight(lineMid, false);
            if (y < yMidMax) {
                return lineMid;
            }
            lineMin = lineMid + 1;
            yMin = yMidMax;
        }
        return lineMin;
    }

    private int getInlaysHeight(int visualLine, boolean above) {
        return EditorUtil.getTotalInlaysHeight(this.myView.getEditor().getInlayModel().getBlockElementsForVisualLine(visualLine, above));
    }

    @NotNull
    LogicalPosition offsetToLogicalPosition(int offset) {
        return this.myView.getLogicalPositionCache().offsetToLogicalPosition(offset);
    }

    int logicalPositionToOffset(@NotNull LogicalPosition pos) {
        return this.myView.getLogicalPositionCache().logicalPositionToOffset(pos);
    }

    @NotNull
    VisualPosition logicalToVisualPosition(@NotNull LogicalPosition pos, boolean beforeSoftWrap) {
        int line = pos.line;
        int column = pos.column;
        int logicalLineCount = this.myDocument.getLineCount();
        if (line >= logicalLineCount) {
            if (line == 0) {
                int resultColumn = this.logToVisWithInlays(0, column, pos.leansForward);
                if (resultColumn < 0) {
                    resultColumn = Integer.MAX_VALUE;
                }
                return new VisualPosition(0, resultColumn, pos.leansForward);
            }
            return new VisualPosition(line - logicalLineCount + this.myView.getEditor().getVisibleLineCount(), column, pos.leansForward);
        }
        int offset = this.logicalPositionToOffset(pos);
        int visualLine = this.offsetToVisualLine(offset, beforeSoftWrap);
        int maxVisualColumn = 0;
        int maxLogicalColumn = 0;
        int endLogicalLine = line;
        for (VisualLineFragmentsIterator.Fragment fragment : VisualLineFragmentsIterator.create(this.myView, offset, beforeSoftWrap)) {
            if (!pos.leansForward && offset == fragment.getVisualLineStartOffset()) {
                return new VisualPosition(visualLine, fragment.getStartVisualColumn());
            }
            endLogicalLine = fragment.getEndLogicalLine();
            maxVisualColumn = fragment.getEndVisualColumn();
            if (fragment.isCollapsedFoldRegion()) {
                int startLogicalLine = fragment.getStartLogicalLine();
                int startLogicalColumn = fragment.getStartLogicalColumn();
                int endLogicalColumn = fragment.getEndLogicalColumn();
                if ((line > startLogicalLine || line == startLogicalLine && (column > startLogicalColumn || column == startLogicalColumn && pos.leansForward)) && (line < endLogicalLine || line == endLogicalLine && column < endLogicalColumn)) {
                    return new VisualPosition(visualLine, fragment.getStartVisualColumn(), true);
                }
                if (line == endLogicalLine && column == endLogicalColumn && !pos.leansForward) {
                    return new VisualPosition(visualLine, maxVisualColumn);
                }
                maxLogicalColumn = startLogicalLine == endLogicalLine ? Math.max(maxLogicalColumn, endLogicalColumn) : endLogicalColumn;
                continue;
            }
            if (fragment.getCurrentInlay() != null) continue;
            int minColumn = fragment.getMinLogicalColumn();
            int maxColumn = fragment.getMaxLogicalColumn();
            if (line == fragment.getStartLogicalLine() && (column > minColumn && column < maxColumn || column == minColumn && pos.leansForward || column == maxColumn && !pos.leansForward)) {
                return new VisualPosition(visualLine, fragment.logicalToVisualColumn(column), fragment.isRtl() ^ pos.leansForward);
            }
            maxLogicalColumn = Math.max(maxLogicalColumn, maxColumn);
        }
        int resultColumn = maxVisualColumn + this.logToVisWithInlays(endLogicalLine, column - maxLogicalColumn, pos.leansForward);
        if (resultColumn < 0) {
            resultColumn = Integer.MAX_VALUE;
        }
        return new VisualPosition(visualLine, resultColumn, pos.leansForward);
    }

    private int logToVisWithInlays(int logLine, int remainingLogColumn, boolean leansForward) {
        if (remainingLogColumn > 1 || remainingLogColumn == 1 && leansForward) {
            remainingLogColumn += this.myView.getEditor().getInlayModel().getAfterLineEndElementsForLogicalLine(logLine).size();
        }
        return remainingLogColumn;
    }

    private int visToLogWithInlays(int logLine, int remainingVisColumns, boolean[] leansForward) {
        if (remainingVisColumns == 0) {
            return 0;
        }
        int inlayCount = this.myView.getEditor().getInlayModel().getAfterLineEndElementsForLogicalLine(logLine).size();
        if (inlayCount == 0) {
            return remainingVisColumns;
        }
        if (remainingVisColumns < inlayCount + 1) {
            leansForward[0] = false;
            return 1;
        }
        if (remainingVisColumns == inlayCount + 1) {
            leansForward[0] = true;
        }
        return remainingVisColumns - inlayCount;
    }

    @NotNull
    LogicalPosition visualToLogicalPosition(@NotNull VisualPosition pos) {
        int line = pos.line;
        int column = pos.column;
        int visualLineCount = this.myView.getEditor().getVisibleLineCount();
        if (line >= visualLineCount) {
            if (line == 0) {
                boolean[] leansForward = new boolean[]{pos.leansRight};
                int resultColumn = this.visToLogWithInlays(0, column, leansForward);
                return new LogicalPosition(0, resultColumn, leansForward[0]);
            }
            return new LogicalPosition(line - visualLineCount + this.myDocument.getLineCount(), column, pos.leansRight);
        }
        int offset = this.visualLineToOffset(line);
        int logicalLine = this.myDocument.getLineNumber(offset);
        int maxVisualColumn = 0;
        int maxLogicalColumn = 0;
        int maxOffset = offset;
        LogicalPosition delayedResult = null;
        for (VisualLineFragmentsIterator.Fragment fragment : VisualLineFragmentsIterator.create(this.myView, offset, false)) {
            if (delayedResult != null) {
                return delayedResult.leanForward(fragment.getCurrentInlay() == null);
            }
            int minColumn = fragment.getStartVisualColumn();
            int maxColumn = fragment.getEndVisualColumn();
            if (column < minColumn || column == minColumn && !pos.leansRight) {
                return this.offsetToLogicalPosition(offset);
            }
            if (column > minColumn && column < maxColumn || column == minColumn || column == maxColumn && !pos.leansRight) {
                if (column == maxColumn && fragment.getCurrentInlay() != null) {
                    delayedResult = new LogicalPosition(fragment.getEndLogicalLine(), fragment.getEndLogicalColumn(), true);
                } else {
                    return new LogicalPosition(column == maxColumn ? fragment.getEndLogicalLine() : fragment.getStartLogicalLine(), fragment.visualToLogicalColumn(column), fragment.isCollapsedFoldRegion() ? column < maxColumn : fragment.getCurrentInlay() == null && fragment.isRtl() ^ pos.leansRight);
                }
            }
            maxLogicalColumn = logicalLine == fragment.getEndLogicalLine() ? Math.max(maxLogicalColumn, fragment.getMaxLogicalColumn()) : fragment.getMaxLogicalColumn();
            maxVisualColumn = maxColumn;
            logicalLine = fragment.getEndLogicalLine();
            maxOffset = Math.max(maxOffset, fragment.getMaxOffset());
        }
        if (this.myView.getEditor().getSoftWrapModel().getSoftWrap(maxOffset) == null) {
            boolean[] leansForward = new boolean[]{pos.leansRight};
            int resultColumn = maxLogicalColumn + this.visToLogWithInlays(logicalLine, column - maxVisualColumn, leansForward);
            if (resultColumn < 0) {
                resultColumn = Integer.MAX_VALUE;
            }
            return new LogicalPosition(logicalLine, resultColumn, leansForward[0]);
        }
        return this.offsetToLogicalPosition(maxOffset).leanForward(true);
    }

    @NotNull
    VisualPosition offsetToVisualPosition(int offset, boolean leanTowardsLargerOffsets, boolean beforeSoftWrap) {
        return this.logicalToVisualPosition(this.offsetToLogicalPosition(offset).leanForward(leanTowardsLargerOffsets), beforeSoftWrap);
    }

    int visualPositionToOffset(VisualPosition visualPosition) {
        return this.logicalPositionToOffset(this.visualToLogicalPosition(visualPosition));
    }

    int offsetToVisualLine(int offset, boolean beforeSoftWrap) {
        int wrapIndex;
        int textLength = this.myDocument.getTextLength();
        if (offset < 0 || textLength == 0) {
            return 0;
        }
        offset = Math.min(offset, textLength);
        FoldRegion outermostCollapsed = this.myFoldingModel.getCollapsedRegionAtOffset(offset = DocumentUtil.alignToCodePointBoundary(this.myDocument, offset));
        if (outermostCollapsed != null && offset > outermostCollapsed.getStartOffset()) {
            assert (outermostCollapsed.isValid());
            offset = outermostCollapsed.getStartOffset();
            beforeSoftWrap = false;
        }
        int softWrapsBeforeOrAtOffset = (wrapIndex = this.myView.getEditor().getSoftWrapModel().getSoftWrapIndex(offset)) < 0 ? -wrapIndex - 1 : wrapIndex + (beforeSoftWrap ? 0 : 1);
        return this.myDocument.getLineNumber(offset) - this.myFoldingModel.getFoldedLinesCountBefore(offset) + softWrapsBeforeOrAtOffset;
    }

    int visualLineToOffset(int visualLine) {
        int start2 = 0;
        int end = this.myDocument.getTextLength();
        if (visualLine <= 0) {
            return start2;
        }
        if (visualLine >= this.myView.getEditor().getVisibleLineCount()) {
            return end;
        }
        int current = ObjectUtils.binarySearch((int)0, (int)this.myDocument.getTextLength(), mid -> Integer.compare(this.offsetToVisualLine(mid, false), visualLine));
        if (current < 0) {
            current = -current - 1;
        }
        return this.visualLineStartOffset(current, true);
    }

    private int visualLineStartOffset(int offset, boolean leanForward) {
        SoftWrap currentOrPrevWrap;
        EditorImpl editor = this.myView.getEditor();
        offset = DocumentUtil.alignToCodePointBoundary(this.myDocument, offset);
        int result2 = EditorUtil.getNotFoldedLineStartOffset(editor, offset);
        SoftWrapModelImpl softWrapModel = editor.getSoftWrapModel();
        List<? extends SoftWrap> softWraps = softWrapModel.getRegisteredSoftWraps();
        int currentOrPrevWrapIndex = softWrapModel.getSoftWrapIndex(offset);
        if (currentOrPrevWrapIndex < 0) {
            currentOrPrevWrap = (currentOrPrevWrapIndex = -currentOrPrevWrapIndex - 2) < 0 || currentOrPrevWrapIndex >= softWraps.size() ? null : softWraps.get(currentOrPrevWrapIndex);
        } else {
            SoftWrap softWrap = currentOrPrevWrap = leanForward ? softWraps.get(currentOrPrevWrapIndex) : null;
        }
        if (currentOrPrevWrap != null && currentOrPrevWrap.getStart() > result2) {
            result2 = currentOrPrevWrap.getStart();
        }
        return result2;
    }

    private float getStartX(int line) {
        return this.myView.getEditor().isRightAligned() ? this.getRightAlignmentLineStartX(line) : (float)this.myView.getInsets().left + (line == 0 ? this.myView.getPrefixTextWidthInPixels() : 0.0f);
    }

    float getRightAlignmentLineStartX(int visualLine) {
        float shift;
        this.checkRightAlignment();
        EditorImpl editor = this.myView.getEditor();
        int max = this.getRightAlignmentMarginX();
        float f = shift = visualLine == 0 ? this.myView.getPrefixTextWidthInPixels() : 0.0f;
        if (visualLine >= editor.getVisibleLineCount()) {
            return (float)max - shift;
        }
        int lineWidth = this.myView.getSizeManager().getVisualLineWidth(new VisualLinesIterator(editor, visualLine), false);
        return Math.max(max - lineWidth, 0);
    }

    int getRightAlignmentMarginX() {
        this.checkRightAlignment();
        EditorImpl editor = this.myView.getEditor();
        JScrollBar vsb = editor.getScrollPane().getVerticalScrollBar();
        int vsbWidth = vsb != null && editor.getVerticalScrollbarOrientation() == 1 ? vsb.getWidth() : 0;
        return editor.getContentComponent().getWidth() - this.myView.getInsets().right - editor.getSettings().getLineCursorWidth() - vsbWidth;
    }

    private void checkRightAlignment() {
        if (!this.myView.getEditor().isRightAligned()) {
            throw new IllegalStateException("Editor is not right-aligned");
        }
    }

    @NotNull
    VisualPosition xyToVisualPosition(@NotNull Point2D p) {
        int visualLine = this.yToVisualLine((int)p.getY());
        int lastColumn = 0;
        float x = this.getStartX(visualLine);
        float px = (float)p.getX();
        int logicalLine = -1;
        if (visualLine < this.myView.getEditor().getVisibleLineCount()) {
            int visualLineStartOffset = this.visualLineToOffset(visualLine);
            int maxOffset = 0;
            for (VisualLineFragmentsIterator.Fragment fragment : VisualLineFragmentsIterator.create(this.myView, visualLineStartOffset, false, true)) {
                if (px <= fragment.getStartX()) {
                    if (fragment.getStartVisualColumn() == 0) {
                        return new VisualPosition(visualLine, 0);
                    }
                    int markerWidth = this.myView.getEditor().getSoftWrapModel().getMinDrawingWidthInPixels(SoftWrapDrawingType.AFTER_SOFT_WRAP);
                    float indent = fragment.getStartX() - (float)markerWidth;
                    if (px <= indent) break;
                    boolean after = px >= indent + (float)(markerWidth / 2);
                    return new VisualPosition(visualLine, fragment.getStartVisualColumn() - (after ? 0 : 1), !after);
                }
                float nextX = fragment.getEndX();
                if (px <= nextX) {
                    int[] column = fragment.xToVisualColumn(px);
                    return new VisualPosition(visualLine, column[0], column[1] > 0);
                }
                x = nextX;
                lastColumn = fragment.getEndVisualColumn();
                maxOffset = Math.max(maxOffset, fragment.getMaxOffset());
                logicalLine = fragment.getEndLogicalLine();
            }
            if (this.myView.getEditor().getSoftWrapModel().getSoftWrap(maxOffset) != null) {
                int markerWidth = this.myView.getEditor().getSoftWrapModel().getMinDrawingWidthInPixels(SoftWrapDrawingType.BEFORE_SOFT_WRAP_LINE_FEED);
                if (px <= x + (float)markerWidth) {
                    boolean after = px >= x + (float)(markerWidth / 2);
                    return new VisualPosition(visualLine, lastColumn + (after ? 1 : 0), !after);
                }
                px -= (float)markerWidth;
                ++lastColumn;
                logicalLine = -1;
            } else if (logicalLine == -1) {
                logicalLine = this.myDocument.getLineNumber(visualLineStartOffset);
            }
        } else if (visualLine == 0) {
            logicalLine = 0;
        }
        float plainSpaceWidth = this.myView.getPlainSpaceWidth();
        float remainingShift = px - x;
        if (remainingShift > plainSpaceWidth && logicalLine >= 0) {
            List<Inlay> inlays = this.myView.getEditor().getInlayModel().getAfterLineEndElementsForLogicalLine(logicalLine);
            int inlaysWidth = 0;
            int inlayCount = 0;
            for (Inlay inlay : inlays) {
                int width = inlay.getWidthInPixels();
                int newWidth = inlaysWidth + width;
                if (remainingShift <= plainSpaceWidth + (float)newWidth) {
                    boolean leftPart = remainingShift <= plainSpaceWidth + (float)((inlaysWidth + newWidth) / 2);
                    return new VisualPosition(visualLine, lastColumn + 1 + inlayCount + (leftPart ? 0 : 1), leftPart);
                }
                inlaysWidth = newWidth;
                ++inlayCount;
            }
            remainingShift -= (float)inlaysWidth;
            lastColumn += inlayCount;
        }
        int additionalColumns = remainingShift <= 0.0f ? 0 : Math.round(remainingShift / plainSpaceWidth);
        return new VisualPosition(visualLine, lastColumn + additionalColumns, remainingShift > (float)additionalColumns * plainSpaceWidth);
    }

    @NotNull
    Point2D visualPositionToXY(@NotNull VisualPosition pos) {
        int visualLine = pos.line;
        int column = pos.column;
        int y = this.visualLineToY(visualLine);
        float x = this.getStartX(visualLine);
        int lastColumn = 0;
        int logicalLine = -1;
        if (visualLine < this.myView.getEditor().getVisibleLineCount()) {
            VisualLineFragmentsIterator.Fragment fragment;
            int startVisualColumn;
            int visualLineStartOffset = this.visualLineToOffset(visualLine);
            int maxOffset = 0;
            Iterator<VisualLineFragmentsIterator.Fragment> iterator = VisualLineFragmentsIterator.create(this.myView, visualLineStartOffset, false, true).iterator();
            while (iterator.hasNext() && column >= (startVisualColumn = (fragment = iterator.next()).getStartVisualColumn()) && (column != startVisualColumn || pos.leansRight)) {
                int endColumn = fragment.getEndVisualColumn();
                if (column < endColumn || column == endColumn && !pos.leansRight) {
                    return new Point2D.Double(fragment.visualColumnToX(column), y);
                }
                x = fragment.getEndX();
                lastColumn = endColumn;
                maxOffset = Math.max(maxOffset, fragment.getMaxOffset());
                logicalLine = fragment.getEndLogicalLine();
            }
            if (column > lastColumn && this.myView.getEditor().getSoftWrapModel().getSoftWrap(maxOffset) != null) {
                --column;
                x += (float)this.myView.getEditor().getSoftWrapModel().getMinDrawingWidthInPixels(SoftWrapDrawingType.BEFORE_SOFT_WRAP_LINE_FEED);
            } else if (logicalLine == -1) {
                logicalLine = this.myDocument.getLineNumber(visualLineStartOffset);
            }
        } else if (visualLine == 0) {
            logicalLine = 0;
        }
        if (column > lastColumn + 1 && logicalLine >= 0) {
            List<Inlay> inlays = this.myView.getEditor().getInlayModel().getAfterLineEndElementsForLogicalLine(logicalLine);
            int inlaysWidth = 0;
            int inlayCount = 0;
            for (Inlay inlay : inlays) {
                inlaysWidth += inlay.getWidthInPixels();
                if (column != lastColumn + 1 + ++inlayCount) continue;
                break;
            }
            x += (float)inlaysWidth;
            column -= inlayCount;
        }
        float additionalShift = column <= lastColumn ? 0.0f : (float)(column - lastColumn) * this.myView.getPlainSpaceWidth();
        return new Point2D.Double(x + additionalShift, y);
    }

    @NotNull
    Point2D offsetToXY(int offset, boolean leanTowardsLargerOffsets, boolean beforeSoftWrap) {
        offset = Math.max(0, Math.min(this.myDocument.getTextLength(), offset));
        offset = DocumentUtil.alignToCodePointBoundary(this.myDocument, offset);
        int logicalLine = this.myDocument.getLineNumber(offset);
        int visualLine = this.offsetToVisualLine(offset, beforeSoftWrap);
        int visualLineStartOffset = this.visualLineToOffset(visualLine);
        int y = this.visualLineToY(visualLine);
        float x = this.getStartX(logicalLine);
        if (this.myDocument.getTextLength() > 0) {
            boolean firstFragment = true;
            for (VisualLineFragmentsIterator.Fragment fragment : VisualLineFragmentsIterator.create(this.myView, offset, beforeSoftWrap, true)) {
                if (firstFragment && offset == visualLineStartOffset && !leanTowardsLargerOffsets) {
                    x = fragment.getStartX();
                    break;
                }
                firstFragment = false;
                int minOffset = fragment.getMinOffset();
                int maxOffset = fragment.getMaxOffset();
                if (fragment.getCurrentInlay() == null && (offset > minOffset && offset < maxOffset || offset == minOffset && leanTowardsLargerOffsets || offset == maxOffset && !leanTowardsLargerOffsets)) {
                    x = fragment.offsetToX(offset);
                    break;
                }
                x = fragment.getEndX();
            }
        }
        return new Point2D.Double(x, y);
    }
}

