/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.richcopy;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ReflectionUtil;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class FontMapper {
    private static final Logger LOG = Logger.getInstance(FontMapper.class);
    private static final String[] logicalFontsToMap = new String[]{"Dialog", "DialogInput", "Monospaced", "Serif", "SansSerif"};
    private static final Map<String, String> logicalToPhysicalMapping = new HashMap<String, String>();

    @NotNull
    public static String getPhysicalFontName(@NotNull String logicalFontName) {
        String mapped = logicalToPhysicalMapping.get(logicalFontName);
        return mapped == null ? logicalFontName : mapped;
    }

    static {
        try {
            Object fontManager = null;
            try {
                fontManager = Class.forName("sun.font.FontManagerFactory").getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            Method findFontMethod = Class.forName("sun.font.FontManager").getMethod("findFont2D", String.class, Integer.TYPE, Integer.TYPE);
            for (String logicalFont : logicalFontsToMap) {
                Object font2D = findFontMethod.invoke(fontManager, logicalFont, 0, 0);
                if (font2D == null) continue;
                String fontClassName = font2D.getClass().getName();
                String physicalFont = null;
                if ("sun.font.CompositeFont".equals(fontClassName)) {
                    Object physicalFontObject = Class.forName("sun.font.CompositeFont").getMethod("getSlotFont", Integer.TYPE).invoke(font2D, 0);
                    physicalFont = (String)Class.forName("sun.font.Font2D").getMethod("getFamilyName", Locale.class).invoke(physicalFontObject, Locale.getDefault());
                } else if ("sun.font.CFont".equals(fontClassName)) {
                    physicalFont = (String)ReflectionUtil.getField(Class.forName("sun.font.CFont"), (Object)font2D, String.class, (String)"nativeFontName");
                }
                if (physicalFont == null) continue;
                logicalToPhysicalMapping.put(logicalFont, physicalFont);
            }
        }
        catch (Throwable e) {
            LOG.warn("Failed to determine logical to physical font mappings");
        }
    }
}

