/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.richcopy;

import com.intellij.ide.highlighter.HighlighterFactory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.richcopy.SyntaxInfoBuilder;
import com.intellij.openapi.editor.richcopy.model.SyntaxInfo;
import com.intellij.openapi.editor.richcopy.view.HtmlSyntaxInfoReader;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HtmlSyntaxInfoUtil {
    @Nullable
    public static CharSequence getHtmlContent(@NotNull PsiFile file2, @NotNull CharSequence text, @Nullable SyntaxInfoBuilder.RangeIterator ownRangeIterator, @NotNull EditorColorsScheme schemeToUse, int startOffset, int endOffset) {
        EditorHighlighter highlighter = HighlighterFactory.createHighlighter((VirtualFile)file2.getViewProvider().getVirtualFile(), (EditorColorsScheme)schemeToUse, (Project)file2.getProject());
        highlighter.setText(text);
        SyntaxInfoBuilder.HighlighterRangeIterator highlighterRangeIterator = new SyntaxInfoBuilder.HighlighterRangeIterator(highlighter, startOffset, endOffset);
        ownRangeIterator = ownRangeIterator == null ? highlighterRangeIterator : new SyntaxInfoBuilder.CompositeRangeIterator(schemeToUse, highlighterRangeIterator, ownRangeIterator);
        return HtmlSyntaxInfoUtil.getHtmlContent(text, ownRangeIterator, schemeToUse, endOffset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static CharSequence getHtmlContent(@NotNull CharSequence text, @NotNull SyntaxInfoBuilder.RangeIterator ownRangeIterator, @NotNull EditorColorsScheme schemeToUse, int stopOffset) {
        SyntaxInfoBuilder.Context context = new SyntaxInfoBuilder.Context(text, schemeToUse, 0);
        SyntaxInfoBuilder.MyMarkupIterator iterator = new SyntaxInfoBuilder.MyMarkupIterator(text, ownRangeIterator, schemeToUse);
        try {
            context.iterate(iterator, stopOffset);
        }
        finally {
            iterator.dispose();
        }
        SyntaxInfo info = context.finish();
        try (SimpleHtmlSyntaxInfoReader data = new SimpleHtmlSyntaxInfoReader(info);){
            data.setRawText(text.toString());
            CharSequence charSequence = data.getBuffer();
            return charSequence;
        }
        catch (IOException e) {
            Logger.getInstance(HtmlSyntaxInfoUtil.class).error((Throwable)e);
            return null;
        }
    }

    private static final class SimpleHtmlSyntaxInfoReader
    extends HtmlSyntaxInfoReader {
        public SimpleHtmlSyntaxInfoReader(SyntaxInfo info) {
            super(info, 2);
        }

        @Override
        protected void appendCloseTags() {
        }

        @Override
        protected void appendStartTags() {
        }

        @Override
        protected void defineBackground(int id, @NotNull StringBuilder styleBuffer) {
        }

        @Override
        protected void appendFontFamilyRule(@NotNull StringBuilder styleBuffer, int fontFamilyId) {
        }
    }
}

