/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.richcopy;

import com.intellij.codeInsight.editorActions.CopyPastePostProcessor;
import com.intellij.codeInsight.editorActions.CopyPastePreProcessor;
import com.intellij.ide.highlighter.HighlighterFactory;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.richcopy.SyntaxInfoBuilder;
import com.intellij.openapi.editor.richcopy.model.SyntaxInfo;
import com.intellij.openapi.editor.richcopy.settings.RichCopySettings;
import com.intellij.openapi.editor.richcopy.view.HtmlTransferableData;
import com.intellij.openapi.editor.richcopy.view.RawTextWithMarkup;
import com.intellij.openapi.editor.richcopy.view.RtfTransferableData;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextWithMarkupProcessor
extends CopyPastePostProcessor<RawTextWithMarkup> {
    private static final Logger LOG = Logger.getInstance(TextWithMarkupProcessor.class);
    private List<RawTextWithMarkup> myResult;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<RawTextWithMarkup> collectTransferableData(PsiFile file2, Editor editor, int[] startOffsets, int[] endOffsets) {
        if (!RichCopySettings.getInstance().isEnabled()) {
            return Collections.emptyList();
        }
        EditorHighlighter highlighter = null;
        try {
            int indentSymbolsToStrip;
            int firstLineStartOffset;
            RichCopySettings settings = RichCopySettings.getInstance();
            List carets = editor.getCaretModel().getAllCarets();
            Caret firstCaret = (Caret)carets.get(0);
            if (Registry.is((String)"editor.richcopy.strip.indents") && carets.size() == 1) {
                Pair<Integer, Integer> p = TextWithMarkupProcessor.calcIndentSymbolsToStrip(editor.getDocument(), firstCaret.getSelectionStart(), firstCaret.getSelectionEnd());
                firstLineStartOffset = (Integer)p.first;
                indentSymbolsToStrip = (Integer)p.second;
            } else {
                firstLineStartOffset = firstCaret.getSelectionStart();
                indentSymbolsToStrip = 0;
            }
            TextWithMarkupProcessor.logInitial(editor, startOffsets, endOffsets, indentSymbolsToStrip, firstLineStartOffset);
            CharSequence text = editor.getDocument().getCharsSequence();
            EditorColorsScheme schemeToUse = settings.getColorsScheme(editor.getColorsScheme());
            highlighter = HighlighterFactory.createHighlighter((VirtualFile)file2.getViewProvider().getVirtualFile(), (EditorColorsScheme)schemeToUse, (Project)file2.getProject());
            highlighter.setText(text);
            MarkupModel markupModel = DocumentMarkupModel.forDocument(editor.getDocument(), file2.getProject(), false);
            SyntaxInfoBuilder.Context context = new SyntaxInfoBuilder.Context(text, schemeToUse, indentSymbolsToStrip);
            int endOffset = 0;
            Caret prevCaret = null;
            for (Caret caret : carets) {
                int startOffsetToUse;
                int caretSelectionStart = caret.getSelectionStart();
                int caretSelectionEnd = caret.getSelectionEnd();
                int additionalShift = 0;
                if (caret == firstCaret) {
                    startOffsetToUse = firstLineStartOffset;
                } else {
                    startOffsetToUse = caretSelectionStart;
                    assert (prevCaret != null);
                    String prevCaretSelectedText = prevCaret.getSelectedText();
                    int fillStringLength = prevCaretSelectedText == null ? 0 : prevCaretSelectedText.length() - (prevCaret.getSelectionEnd() - prevCaret.getSelectionStart());
                    context.addCharacter(endOffset + fillStringLength);
                    additionalShift = fillStringLength + 1;
                }
                context.reset(endOffset - caretSelectionStart + additionalShift);
                endOffset = caretSelectionEnd;
                prevCaret = caret;
                if (endOffset <= startOffsetToUse) continue;
                SyntaxInfoBuilder.MyMarkupIterator markupIterator = SyntaxInfoBuilder.createMarkupIterator(highlighter, text, schemeToUse, markupModel, startOffsetToUse, endOffset);
                try {
                    context.iterate(markupIterator, endOffset);
                }
                finally {
                    markupIterator.dispose();
                }
            }
            SyntaxInfo syntaxInfo = context.finish();
            TextWithMarkupProcessor.logSyntaxInfo(syntaxInfo);
            this.createResult(syntaxInfo, editor);
            return (List)ObjectUtils.notNull(this.myResult, Collections.emptyList());
        }
        catch (Throwable t) {
            LOG.error("Error generating text with markup", new Attachment[]{new Attachment("exception", t), new Attachment("highlighter.txt", String.valueOf(highlighter))});
            return Collections.emptyList();
        }
    }

    void createResult(SyntaxInfo syntaxInfo, Editor editor) {
        this.myResult = new ArrayList<RawTextWithMarkup>(2);
        this.myResult.add(new HtmlTransferableData(syntaxInfo, EditorUtil.getTabSize(editor)));
        this.myResult.add(new RtfTransferableData(syntaxInfo));
    }

    private void setRawText(String rawText) {
        if (this.myResult == null) {
            return;
        }
        for (RawTextWithMarkup data : this.myResult) {
            data.setRawText(rawText);
        }
        this.myResult = null;
    }

    private static void logInitial(@NotNull Editor editor, @NotNull int[] startOffsets, @NotNull int[] endOffsets, int indentSymbolsToStrip, int firstLineStartOffset) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        StringBuilder buffer = new StringBuilder();
        Document document = editor.getDocument();
        CharSequence text = document.getCharsSequence();
        for (int i = 0; i < startOffsets.length; ++i) {
            int start2 = startOffsets[i];
            int lineStart = document.getLineStartOffset(document.getLineNumber(start2));
            int end = endOffsets[i];
            int lineEnd = document.getLineEndOffset(document.getLineNumber(end));
            buffer.append("    region #").append(i).append(": ").append(start2).append('-').append(end).append(", text at range ").append(lineStart).append('-').append(lineEnd).append(": \n'").append(text.subSequence(lineStart, lineEnd)).append("'\n");
        }
        if (buffer.length() > 0) {
            buffer.setLength(buffer.length() - 1);
        }
        LOG.debug(String.format("Preparing syntax-aware text. Given: %s selection, indent symbols to strip=%d, first line start offset=%d, selected text:%n%s", startOffsets.length > 1 ? "block" : "regular", indentSymbolsToStrip, firstLineStartOffset, buffer));
    }

    private static void logSyntaxInfo(@NotNull SyntaxInfo info) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Constructed syntax info: " + info);
        }
    }

    private static Pair<Integer, Integer> calcIndentSymbolsToStrip(@NotNull Document document, int startOffset, int endOffset) {
        int startLine = document.getLineNumber(startOffset);
        int endLine = document.getLineNumber(endOffset);
        CharSequence text = document.getCharsSequence();
        int maximumCommonIndent = Integer.MAX_VALUE;
        int firstLineStart = startOffset;
        int firstLineEnd = startOffset;
        for (int line = startLine; line <= endLine; ++line) {
            int indent;
            int lineStartOffset = document.getLineStartOffset(line);
            int lineEndOffset = document.getLineEndOffset(line);
            if (line == startLine) {
                firstLineStart = lineStartOffset;
                firstLineEnd = lineEndOffset;
            }
            int nonWsOffset = lineEndOffset;
            for (int i = lineStartOffset; i < lineEndOffset && i - lineStartOffset < maximumCommonIndent && i < endOffset; ++i) {
                char c = text.charAt(i);
                if (c == ' ' || c == '\t') continue;
                nonWsOffset = i;
                break;
            }
            if (nonWsOffset < lineEndOffset && (maximumCommonIndent = Math.min(maximumCommonIndent, indent = nonWsOffset - lineStartOffset)) == 0) break;
        }
        int startOffsetToUse = Math.min(firstLineEnd, Math.max(startOffset, firstLineStart + maximumCommonIndent));
        return Pair.create((Object)startOffsetToUse, (Object)maximumCommonIndent);
    }

    public static class RawTextSetter
    implements CopyPastePreProcessor {
        private final TextWithMarkupProcessor myProcessor;

        public RawTextSetter(TextWithMarkupProcessor processor2) {
            this.myProcessor = processor2;
        }

        @Override
        @Nullable
        public String preprocessOnCopy(PsiFile file2, int[] startOffsets, int[] endOffsets, String text) {
            this.myProcessor.setRawText(text);
            return null;
        }

        @Override
        @NotNull
        public String preprocessOnPaste(Project project, PsiFile file2, Editor editor, String text, RawText rawText) {
            return text;
        }
    }
}

