/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.richcopy.view;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.richcopy.model.SyntaxInfo;
import com.intellij.openapi.util.registry.Registry;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSyntaxAwareReader
extends Reader {
    private static final Logger LOG = Logger.getInstance(AbstractSyntaxAwareReader.class);
    protected String myRawText;
    @NotNull
    protected final SyntaxInfo mySyntaxInfo;
    @Nullable
    private transient Reader myDelegate;

    public AbstractSyntaxAwareReader(@NotNull SyntaxInfo syntaxInfo) {
        this.mySyntaxInfo = syntaxInfo;
    }

    @Override
    public int read() throws IOException {
        return this.getDelegate().read();
    }

    @Override
    public int read(@NotNull char[] cbuf, int off, int len) throws IOException {
        return this.getDelegate().read(cbuf, off, len);
    }

    @Override
    public void close() throws IOException {
        this.myDelegate = null;
    }

    public void setRawText(String rawText) {
        this.myRawText = rawText;
    }

    @NotNull
    private Reader getDelegate() {
        if (this.myDelegate != null) {
            return this.myDelegate;
        }
        this.myDelegate = new StringReader(this.getBuffer().toString());
        return this.myDelegate;
    }

    @NotNull
    public final CharSequence getBuffer() {
        StringBuilder buffer = new StringBuilder();
        try {
            this.build(buffer, Registry.intValue((String)"editor.richcopy.max.size.megabytes") * 0x100000);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Resulting text: \n" + buffer);
        }
        return buffer;
    }

    protected abstract void build(@NotNull StringBuilder var1, int var2);
}

