/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.textarea;

import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorGutter;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.IndentsModel;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.SoftWrapModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.impl.EmptyIndentsModel;
import com.intellij.openapi.editor.impl.SettingsImpl;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.textarea.TextAreaDocument;
import com.intellij.openapi.editor.textarea.TextComponentCaretModel;
import com.intellij.openapi.editor.textarea.TextComponentDocument;
import com.intellij.openapi.editor.textarea.TextComponentEditor;
import com.intellij.openapi.editor.textarea.TextComponentFoldingModel;
import com.intellij.openapi.editor.textarea.TextComponentInlayModel;
import com.intellij.openapi.editor.textarea.TextComponentScrollingModel;
import com.intellij.openapi.editor.textarea.TextComponentSelectionModel;
import com.intellij.openapi.editor.textarea.TextComponentSoftWrapModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.util.ui.JBUI;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextComponentEditorImpl
extends UserDataHolderBase
implements TextComponentEditor {
    private final Project myProject;
    private final JTextComponent myTextComponent;
    private final TextComponentDocument myDocument;
    private final TextComponentCaretModel myCaretModel;
    private final TextComponentSelectionModel mySelectionModel;
    private final TextComponentScrollingModel myScrollingModel;
    private final TextComponentSoftWrapModel mySoftWrapModel;
    private final TextComponentFoldingModel myFoldingModel;
    private EditorSettings mySettings;

    public TextComponentEditorImpl(Project project, @NotNull JTextComponent textComponent) {
        this.myProject = project;
        this.myTextComponent = textComponent;
        this.myDocument = textComponent instanceof JTextArea ? new TextAreaDocument((JTextArea)textComponent) : new TextComponentDocument(textComponent);
        this.myCaretModel = new TextComponentCaretModel(textComponent, this);
        this.mySelectionModel = new TextComponentSelectionModel(textComponent, this);
        this.myScrollingModel = new TextComponentScrollingModel(textComponent);
        this.mySoftWrapModel = new TextComponentSoftWrapModel();
        this.myFoldingModel = new TextComponentFoldingModel();
    }

    @NotNull
    public Document getDocument() {
        return this.myDocument;
    }

    public boolean isViewer() {
        return !this.myTextComponent.isEditable();
    }

    @NotNull
    public JComponent getComponent() {
        return this.myTextComponent;
    }

    @NotNull
    public JComponent getContentComponent() {
        return this.myTextComponent;
    }

    public void setBorder(@Nullable Border border) {
    }

    public Insets getInsets() {
        return JBUI.emptyInsets();
    }

    @NotNull
    public TextComponentSelectionModel getSelectionModel() {
        return this.mySelectionModel;
    }

    @NotNull
    public MarkupModel getMarkupModel() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @NotNull
    public FoldingModel getFoldingModel() {
        return this.myFoldingModel;
    }

    @NotNull
    public ScrollingModel getScrollingModel() {
        return this.myScrollingModel;
    }

    @NotNull
    public CaretModel getCaretModel() {
        return this.myCaretModel;
    }

    @NotNull
    public SoftWrapModel getSoftWrapModel() {
        return this.mySoftWrapModel;
    }

    @NotNull
    public InlayModel getInlayModel() {
        return new TextComponentInlayModel();
    }

    @NotNull
    public EditorKind getEditorKind() {
        return EditorKind.UNTYPED;
    }

    @NotNull
    public EditorSettings getSettings() {
        if (this.mySettings == null) {
            this.mySettings = new SettingsImpl();
        }
        return this.mySettings;
    }

    @NotNull
    public EditorColorsScheme getColorsScheme() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public int getLineHeight() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @NotNull
    public Point logicalPositionToXY(@NotNull LogicalPosition pos) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public int logicalPositionToOffset(@NotNull LogicalPosition pos) {
        if (pos.line >= this.myDocument.getLineCount()) {
            return this.myDocument.getTextLength();
        }
        return this.myDocument.getLineStartOffset(pos.line) + pos.column;
    }

    @NotNull
    public VisualPosition logicalToVisualPosition(@NotNull LogicalPosition logicalPos) {
        return new VisualPosition(logicalPos.line, logicalPos.column);
    }

    @NotNull
    public Point visualPositionToXY(@NotNull VisualPosition visible) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @NotNull
    public Point2D visualPositionToPoint2D(@NotNull VisualPosition pos) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @NotNull
    public LogicalPosition visualToLogicalPosition(@NotNull VisualPosition visiblePos) {
        return new LogicalPosition(visiblePos.line, visiblePos.column);
    }

    @NotNull
    public LogicalPosition offsetToLogicalPosition(int offset) {
        int line = this.myDocument.getLineNumber(offset);
        int lineStartOffset = this.myDocument.getLineStartOffset(line);
        return new LogicalPosition(line, offset - lineStartOffset);
    }

    @NotNull
    public VisualPosition offsetToVisualPosition(int offset) {
        int line = this.myDocument.getLineNumber(offset);
        int lineStartOffset = this.myDocument.getLineStartOffset(line);
        return new VisualPosition(line, offset - lineStartOffset);
    }

    @NotNull
    public VisualPosition offsetToVisualPosition(int offset, boolean leanForward, boolean beforeSoftWrap) {
        return this.offsetToVisualPosition(offset);
    }

    @NotNull
    public LogicalPosition xyToLogicalPosition(@NotNull Point p) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @NotNull
    public VisualPosition xyToVisualPosition(@NotNull Point p) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @NotNull
    public VisualPosition xyToVisualPosition(@NotNull Point2D p) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void addEditorMouseListener(@NotNull EditorMouseListener listener2) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void removeEditorMouseListener(@NotNull EditorMouseListener listener2) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void addEditorMouseMotionListener(@NotNull EditorMouseMotionListener listener2) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void removeEditorMouseMotionListener(@NotNull EditorMouseMotionListener listener2) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean isDisposed() {
        return false;
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    public boolean isInsertMode() {
        return true;
    }

    public boolean isColumnMode() {
        return false;
    }

    public boolean isOneLineMode() {
        return !(this.myTextComponent instanceof JTextArea);
    }

    @NotNull
    public EditorGutter getGutter() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Nullable
    public EditorMouseEventArea getMouseEventArea(@NotNull MouseEvent e) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void setHeaderComponent(@Nullable JComponent header) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean hasHeaderComponent() {
        return false;
    }

    @Nullable
    public JComponent getHeaderComponent() {
        return null;
    }

    @NotNull
    public IndentsModel getIndentsModel() {
        return new EmptyIndentsModel();
    }
}

