/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.file.exclude;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.file.exclude.EnforcedPlainTextFileTypeManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeConsumer;
import com.intellij.openapi.fileTypes.FileTypeFactory;
import com.intellij.openapi.fileTypes.ex.FileTypeIdentifiableByVirtualFile;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class EnforcedPlainTextFileTypeFactory
extends FileTypeFactory {
    @Deprecated
    public static final LayeredIcon ENFORCED_PLAIN_TEXT_ICON = new LayeredIcon(new Icon[0]);
    public static final String ENFORCED_PLAIN_TEXT = "Enforced Plain Text";
    private static final Icon ENFORCED_PLAIN_TEXT_LAZY_ICON = new IconLoader.LazyIcon(){

        protected Icon compute() {
            return new LayeredIcon(new Icon[]{AllIcons.FileTypes.Text, PlatformIcons.EXCLUDED_FROM_COMPILE_ICON});
        }
    };
    private final FileTypeIdentifiableByVirtualFile myFileType;

    public EnforcedPlainTextFileTypeFactory() {
        final EnforcedPlainTextFileTypeManager typeManager = EnforcedPlainTextFileTypeManager.getInstance();
        this.myFileType = new FileTypeIdentifiableByVirtualFile(){

            public boolean isMyFileType(@NotNull VirtualFile file2) {
                return typeManager != null && typeManager.isMarkedAsPlainText(file2);
            }

            @NotNull
            public String getName() {
                return EnforcedPlainTextFileTypeFactory.ENFORCED_PLAIN_TEXT;
            }

            @NotNull
            public String getDescription() {
                return EnforcedPlainTextFileTypeFactory.ENFORCED_PLAIN_TEXT;
            }

            @NotNull
            public String getDefaultExtension() {
                return "fakeTxt";
            }

            public Icon getIcon() {
                return ENFORCED_PLAIN_TEXT_LAZY_ICON;
            }

            public boolean isBinary() {
                return false;
            }

            public boolean isReadOnly() {
                return true;
            }

            public String getCharset(@NotNull VirtualFile file2, @NotNull byte[] content) {
                return null;
            }
        };
    }

    @NotNull
    public static Icon getEnforcedPlainTextIcon() {
        return ENFORCED_PLAIN_TEXT_LAZY_ICON;
    }

    public void createFileTypes(@NotNull FileTypeConsumer consumer) {
        consumer.consume((FileType)this.myFileType, "");
    }
}

