/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.actions;

import com.intellij.ide.DeleteProvider;
import com.intellij.ide.actions.DeleteAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.fileChooser.FileSystemTree;
import com.intellij.openapi.fileChooser.actions.VirtualFileDeleteProvider;
import com.intellij.openapi.fileChooser.ex.FileChooserKeys;
import org.jetbrains.annotations.NotNull;

public class FileDeleteAction
extends DeleteAction {
    public FileDeleteAction() {
        this.setEnabledInModalContext(true);
    }

    @Override
    protected DeleteProvider getDeleteProvider(DataContext dataContext) {
        return new VirtualFileDeleteProvider();
    }

    @Override
    public void update(@NotNull AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        FileSystemTree tree = (FileSystemTree)event.getData(FileSystemTree.DATA_KEY);
        if (tree == null) {
            presentation.setEnabledAndVisible(false);
            return;
        }
        Boolean available = (Boolean)event.getData(FileChooserKeys.DELETE_ACTION_AVAILABLE);
        if (available != null && !available.booleanValue()) {
            presentation.setEnabledAndVisible(false);
            return;
        }
        presentation.setEnabledAndVisible(true);
        super.update(event);
    }
}

